/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessElementType;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.engine.support.AbstractCoreBpmnRuntimeProcessSupport;
import org.dom4j.Document;
import org.dom4j.Element;

public class CoreBpmnRuntimeEndProcessSupport<T extends Auditable<ID>, ID extends Serializable>
extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
    @Override
    protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        int j = sourceList.size();
        for (int i = 0; i < j; ++i) {
            CoreBpmnRuntimeSource<T, ID> source = sourceList.get(i);
            SinoConcurrentLocker.isolated(source.getTargetId());
            Document diagram = BpmnRuntimeCacheProvider.getBpmnRuntimeDocument(source);
            Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
            String passValidatorSql = BpmnDiagramHelper.getPassValidatorSql(taskElement);
            if (!StringUtils.isBlank(passValidatorSql)) {
                this.prepareValidateSql(i + 1, passValidatorSql, source.getId());
            }
            this.prepareCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.pass, taskElement, source.getId());
            Element endEventElement = BpmnDiagramHelper.getProcessElement(diagram, ProcessElementType.END_EVENT);
            this.prepareEndCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.end, endEventElement, source.getId());
        }
    }

    @Override
    protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        ArrayList<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList<CoreBpmnInstanceStatusDTO<ID>>();
        for (CoreBpmnRuntimeSource<T, ID> source : sourceList) {
            CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
            source.setRuntimeInitiator(instance.getInitiator());
            source.setRuntimeProcId(instance.getProcId());
            List<CoreBpmnInstanceTaskBean> instanceTaskList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTaskList(source);
            Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstance(instance);
            CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO<ID>();
            instanceStatus.setId(source.getId());
            instanceStatus.setProcessStatus(ProcessStatus.DONE);
            StringBuilder sb = new StringBuilder();
            for (CoreBpmnInstanceTaskBean instanceTask : instanceTaskList) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(instanceTask.getStatusCode());
            }
            instanceStatus.setStatusCode(sb.toString());
            instanceStatusList.add(instanceStatus);
            if (StringUtils.isEmpty(source.getComment())) {
                source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.END", new String[0]));
            }
            String sourceName = XmlUtils.getAttributeValue(taskElement, "name");
            String targetName = I18nHelper.getMessage("SINO.BPMN.TASK.END", new String[0]);
            this.insertComment(instance.getTargetId(), taskElement, CommentStatus.END, source, this.getRoute(sourceName, targetName));
            BpmnRuntimeCacheProvider.getProcessData().addDeleteBpmnTargetIdList(source.getTargetId());
        }
        return instanceStatusList;
    }
}

