/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.data.Pair;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.ProcessElementType;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.diagram.TaskStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.engine.support.AbstractCoreBpmnRuntimeProcessSupport;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreBpmnRuntimeCompleteProcessSupport<T extends Auditable<ID>, ID extends Serializable>
extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(CoreBpmnRuntimeCompleteProcessSupport.class);

    @Override
    protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        int j = sourceList.size();
        for (int i = 0; i < j; ++i) {
            CoreBpmnRuntimeSource<T, ID> source = sourceList.get(i);
            SinoConcurrentLocker.isolated(source.getTargetId());
            Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
            if (BpmnDiagramHelper.isCommentRequiredTask(taskElement) && StringUtils.isEmpty(source.getComment())) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_DRAFT.TIP.COMMENT_REQUIRED");
            }
            String passValidatorSql = BpmnDiagramHelper.getPassValidatorSql(taskElement);
            if (!StringUtils.isBlank(passValidatorSql)) {
                this.prepareValidateSql(i + 1, passValidatorSql, source.getId());
            }
            this.prepareCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.pass, taskElement, source.getId());
        }
    }

    @Override
    protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        return new ArrayList<CoreBpmnInstanceStatusDTO<ID>>();
    }

    private Pair<ProcessStatus, String> completeTask(Document diagram, CoreBpmnInstanceBean instance, CoreBpmnInstanceTaskBean task, CoreBpmnRuntimeSource<T, ID> source) {
        List<Element> nextTaskElementList;
        CoreBpmnInstanceTaskBean instanceTask = new CoreBpmnInstanceTaskBean();
        instanceTask.setId(task.getId());
        instanceTask.setStatus(TaskStatus.COMPLETED.name());
        BpmnRuntimeCacheProvider.getProcessData().addUpdateInstanceTaskStatus(instanceTask);
        if (task.getId() != null) {
            BpmnRuntimeCacheProvider.getProcessData().addDeleteCandidatorInstanceTaskId(task.getId());
        }
        if (!(nextTaskElementList = BpmnRuntimeCacheProvider.getNextTask(source).getNextTaskElementList()).isEmpty()) {
            if (nextTaskElementList.stream().anyMatch(t -> ProcessElementType.END_EVENT.equals((Object)BpmnDiagramHelper.getProcessElementType(t)))) {
                BpmnRuntimeCacheProvider.getProcessData().addDeleteInstance(instance);
                return Pair.of(ProcessStatus.DONE, null);
            }
            this.insertNextInstanceTask(diagram, instance, nextTaskElementList, source);
        } else {
            List<Element> sequenceFlowList = BpmnDiagramHelper.getOutgoingSequenceFlowList(diagram, task.getTaskId());
            if (sequenceFlowList.size() != 1) {
                throw new BpmnException("SINO.BPMN.TIP.NEXT_TASK_NOT_FOUND");
            }
            Element sequenceFlow = sequenceFlowList.get(0);
            Element targetElement = BpmnDiagramHelper.getTargetElement(diagram, sequenceFlow);
            ProcessElementType targetElementType = BpmnDiagramHelper.getProcessElementType(targetElement);
            if (!ProcessElementType.PARALLEL_GATEWAY.equals((Object)targetElementType)) {
                throw new BpmnException("SINO.BPMN.TIP.NEXT_TASK_NOT_FOUND");
            }
            if (BpmnDiagramHelper.getIncomingSequenceFlowIdList(diagram, targetElement).size() <= 1) {
                throw new BpmnException("SINO.BPMN.TIP.NEXT_TASK_NOT_FOUND");
            }
        }
        String nextStatusCode = nextTaskElementList.stream().map(t -> BpmnDiagramHelper.getUserTaskStatusCode(t)).collect(Collectors.joining(","));
        return Pair.of(ProcessStatus.APPROVE, nextStatusCode);
    }
}

