/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.support;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.context.SinoBeanContext;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.checked.CheckedException;
import net.sinodawn.framework.executor.ExecutorHelper;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.mybatis.mapper.GlobalMapper;
import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnCommentBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskCandidatorDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskHisBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskHisCandidatorDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskRoleBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskUserBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnTargetBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.diagram.TaskStatus;
import net.sinodawn.module.sys.bpmn.diagram.attribute.CandidatorFilterStrategy;
import net.sinodawn.module.sys.bpmn.diagram.attribute.CounterSignStrategy;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeService;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeData;
import net.sinodawn.module.sys.bpmn.event.CoreBpmnNotificationEvent;
import net.sinodawn.module.sys.bpmn.event.CoreBpmnUpdateStatusEvent;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnCommentService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDiagramService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskHisService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskRoleService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskUserService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnTargetService;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractCoreBpmnRuntimeProcessSupport<T extends Auditable<ID>, ID extends Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCoreBpmnRuntimeProcessSupport.class);
    protected static final String BPMN_VALIDATOR_SQL_SN = "SN_";
    protected static final String BPMN_VALIDATOR_SQL_TYPE = "TYPE_";
    protected static final String BPMN_VALIDATOR_SQL_DESC = "DESC_";
    protected static final String BPMN_VALIDATOR_SQL_TABLE = "TABLE_";
    protected final GlobalMapper globalMapper = ApplicationContextHelper.getBean(GlobalMapper.class);
    protected final CoreBpmnProcService procService = ApplicationContextHelper.getBean(CoreBpmnProcService.class);
    protected final CoreBpmnDiagramService diagramService = ApplicationContextHelper.getBean(CoreBpmnDiagramService.class);
    protected final CoreBpmnInstanceService instanceService = ApplicationContextHelper.getBean(CoreBpmnInstanceService.class);
    protected final CoreBpmnInstanceTaskService instanceTaskService = ApplicationContextHelper.getBean(CoreBpmnInstanceTaskService.class);
    protected final CoreBpmnInstanceTaskUserService instanceTaskUserService = ApplicationContextHelper.getBean(CoreBpmnInstanceTaskUserService.class);
    protected final CoreBpmnInstanceTaskRoleService instanceTaskRoleService = ApplicationContextHelper.getBean(CoreBpmnInstanceTaskRoleService.class);
    protected final CoreBpmnCommentService commentService = ApplicationContextHelper.getBean(CoreBpmnCommentService.class);
    protected final CoreBpmnTargetService bpmnTargetService = ApplicationContextHelper.getBean(CoreBpmnTargetService.class);
    protected final CoreBpmnInstanceTaskHisService taskHisService = ApplicationContextHelper.getBean(CoreBpmnInstanceTaskHisService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CoreBpmnInstanceStatusDTO<ID>> apply(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        List<CoreBpmnInstanceStatusDTO<ID>> var7;
        try {
            Map endCallback;
            Collections.sort(sourceList, (s1, s2) -> ObjectUtils.toString(s1.getId()).compareTo(ObjectUtils.toString(s2.getId())));
            BpmnRuntimeCacheProvider.init(sourceList);
            this.doValidate(sourceList);
            this.validateBySql();
            List<CoreBpmnInstanceStatusDTO<ID>> statusList = this.doProcess(sourceList);
            this.processData();
            String tableName = sourceList.get(0).getTableName();
            this.updateProcessStatus(tableName, statusList);
            CoreBpmnUpdateStatusEvent event = new CoreBpmnUpdateStatusEvent(tableName, statusList);
            ApplicationContextHelper.getApplicationContext().publishEvent((ApplicationEvent)event);
            Map callback = BpmnRuntimeCacheProvider.getBpmnRuntimeCallback();
            if (!CollectionUtils.isEmpty(callback)) {
                this.doCallback(callback);
            }
            if (!CollectionUtils.isEmpty(endCallback = BpmnRuntimeCacheProvider.getBpmnRuntimeEndCallback())) {
                this.doCallback(endCallback);
            }
            if (BpmnRuntimeCacheProvider.getProcessData().isAsync()) {
                ExecutorHelper.submitAfterCommitTransaction(() -> this.sendNotification(sourceList, statusList));
            } else {
                this.sendNotification(sourceList, statusList);
            }
            var7 = statusList;
        }
        finally {
            BpmnRuntimeCacheProvider.remove();
        }
        return var7;
    }

    protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
    }

    protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        return Collections.emptyList();
    }

    protected void sendNotification(List<CoreBpmnRuntimeSource<T, ID>> sourceList, List<CoreBpmnInstanceStatusDTO<ID>> statusList) {
        ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
        ArrayList auditingInstanceStatusList = new ArrayList();
        Iterator<CoreBpmnInstanceStatusDTO<ID>> var5 = statusList.iterator();
        while (true) {
            CoreBpmnNotificationEvent event;
            CoreBpmnRuntimeSource source;
            if (!var5.hasNext()) {
                if (!auditingInstanceStatusList.isEmpty()) {
                    List<CoreBpmnRuntimeSource<T, ID>> auditingSourceList = sourceList.stream().filter(s -> auditingInstanceStatusList.stream().anyMatch(a -> a.getId().equals(s.getId()))).collect(Collectors.toList());
                    List<CoreBpmnInstanceBean> instanceList = this.getBpmnRuntimeInstanceListFromDatabase(auditingSourceList);
                    List<Long> idList = instanceList.stream().map(i -> i.getId()).collect(Collectors.toList());
                    List taskList = this.instanceTaskService.getDao().selectListByOneColumnValues(idList, "INSTID", new Order[0]);
                    List<CoreBpmnInstanceTaskCandidatorDTO> instanceTaskCandidatorList = this.instanceService.selectInstanceTaskAuditorList(idList);
                    for (CoreBpmnInstanceTaskBean task : taskList) {
                        CoreBpmnInstanceBean instance = instanceList.stream().filter(i -> i.getId().equals(task.getInstId())).findAny().get();
                        CoreBpmnRuntimeSource source2 = sourceList.stream().filter(s -> s.getTargetId().equals(instance.getTargetId())).findAny().get();
                        CoreBpmnInstanceStatusDTO status = statusList.stream().filter(s -> s.getId().equals(source2.getId())).findAny().get();
                        List candidatorList = instanceTaskCandidatorList.stream().filter(i -> i.getInstTaskId().equals(task.getId())).collect(Collectors.toList());
                        if (candidatorList.isEmpty()) continue;
                        CoreBpmnNotificationEvent event2 = new CoreBpmnNotificationEvent(status.getProcessStatus(), I18nHelper.getMessage(source2.getTableName().toUpperCase() + ".SERVICE_NAME", new String[0]), source2.getDesc(), task.getTaskName(), LocalContextHelper.getLoginUserId(), source2.getComment(), candidatorList.stream().map(c -> c.getCandidatorId()).distinct().collect(Collectors.toList()));
                        applicationContext.publishEvent((ApplicationEvent)event2);
                    }
                }
                return;
            }
            CoreBpmnInstanceStatusDTO instanceStatus = var5.next();
            if (ProcessStatus.DONE.equals((Object)instanceStatus.getProcessStatus()) || ProcessStatus.DRAFT_UNDO.equals((Object)instanceStatus.getProcessStatus())) continue;
            if (ProcessStatus.DRAFT_WITHDRAWED.equals((Object)instanceStatus.getProcessStatus())) {
                CoreBpmnInstanceStatusDTO finalInstanceStatus = instanceStatus;
                source = sourceList.stream().filter(s -> s.getId().equals(finalInstanceStatus.getId())).findAny().get();
                event = new CoreBpmnNotificationEvent(instanceStatus.getProcessStatus(), I18nHelper.getMessage(source.getTableName().toUpperCase() + ".SERVICE_NAME", new String[0]), source.getDesc(), I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_DIAGRAM.START_NODE", new String[0]), LocalContextHelper.getLoginUserId(), source.getComment(), source.getCandidatorList());
                applicationContext.publishEvent((ApplicationEvent)event);
                continue;
            }
            if (!ProcessStatus.DRAFT.equals((Object)instanceStatus.getProcessStatus()) && !ProcessStatus.DRAFT_REJECTED.equals((Object)instanceStatus.getProcessStatus())) {
                auditingInstanceStatusList.add(instanceStatus);
                continue;
            }
            CoreBpmnInstanceStatusDTO finalInstanceStatus1 = instanceStatus;
            source = sourceList.stream().filter(s -> s.getId().equals(finalInstanceStatus1.getId())).findAny().get();
            event = new CoreBpmnNotificationEvent(instanceStatus.getProcessStatus(), I18nHelper.getMessage(source.getTableName().toUpperCase() + ".SERVICE_NAME", new String[0]), source.getDesc(), I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_DIAGRAM.START_NODE", new String[0]), LocalContextHelper.getLoginUserId(), source.getComment(), Arrays.asList(source.getRuntimeInitiator()));
            applicationContext.publishEvent((ApplicationEvent)event);
        }
    }

    protected void insertComment(String targetId, Element taskElement, CommentStatus commentStatus, CoreBpmnRuntimeSource<T, ID> source, String route) {
        CoreBpmnCommentBean bpmnComment = new CoreBpmnCommentBean();
        bpmnComment.setId(ApplicationContextHelper.getNextIdentity());
        bpmnComment.setTargetId(targetId);
        bpmnComment.setProcId(source.getRuntimeProcId());
        if (!StringUtils.isEmpty(source.getRuntimeTaskName())) {
            bpmnComment.setTaskName(source.getRuntimeTaskName());
        } else {
            if (taskElement != null) {
                bpmnComment.setTaskId(XmlUtils.getAttributeValue(taskElement, "id"));
                bpmnComment.setTaskName(XmlUtils.getAttributeValue(taskElement, "name"));
                bpmnComment.setStatusCode(XmlUtils.getAttributeValue(taskElement, "statusCode"));
            }
            if (StringUtils.isEmpty(bpmnComment.getTaskName())) {
                if (CommentStatus.SUBMIT.equals((Object)commentStatus)) {
                    bpmnComment.setTaskName(I18nHelper.getMessage("SINO.BPMN.TASK.START", new String[0]));
                } else if (CommentStatus.UNDO.equals((Object)commentStatus)) {
                    bpmnComment.setTaskName(I18nHelper.getMessage("SINO.BPMN.TASK.END", new String[0]));
                }
            }
        }
        bpmnComment.setAttachmentId(source.getAttachmentId());
        bpmnComment.setUserId(LocalContextHelper.getLoginUserId());
        bpmnComment.setRoleId(LocalContextHelper.getLoginRoleId());
        bpmnComment.setStatus(commentStatus.name());
        bpmnComment.setComment(source.getComment());
        bpmnComment.setRoute(route);
        if (source.getNextCandidateRoleList().isEmpty() && source.getNextCandidatorList().isEmpty()) {
            if (!StringUtils.isBlank(source.getTransferCandidator())) {
                CoreUserService userService = ApplicationContextHelper.getBean(CoreUserService.class);
                CoreUserBean transferCandidator = (CoreUserBean)userService.selectById(source.getTransferCandidator());
                StringBuilder sb = new StringBuilder("(").append(I18nHelper.getMessage("SINO.BPMN.COMMENT.TRANSFER", LocalContextHelper.getLoginUserName(), transferCandidator.getUserName())).append(")");
                bpmnComment.setComment(bpmnComment.getComment() + sb.toString());
            }
        } else {
            List userList;
            boolean start;
            StringBuilder sb;
            if (!source.getNextCandidateRoleList().isEmpty()) {
                sb = new StringBuilder("(").append(I18nHelper.getMessage("SINO.BPMN.COMMENT.SELECTED_CANDIDATE_ROLE", new String[0])).append(":");
                start = true;
                CoreRoleService roleService = ApplicationContextHelper.getBean(CoreRoleService.class);
                userList = roleService.selectListByIds(source.getNextCandidateRoleList());
                for (CoreRoleBean role : userList) {
                    if (start) {
                        start = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(role.getRoleName());
                }
                sb.append(")");
                bpmnComment.setComment(bpmnComment.getComment() + sb.toString());
            }
            if (!source.getNextCandidatorList().isEmpty()) {
                sb = new StringBuilder("(").append(I18nHelper.getMessage("SINO.BPMN.COMMENT.SELECTED_CANDIDATOR", new String[0])).append(":");
                start = true;
                CoreUserService userService = ApplicationContextHelper.getBean(CoreUserService.class);
                userList = userService.selectListByIds(source.getNextCandidatorList());
                for (CoreUserBean user : userList) {
                    if (start) {
                        start = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(user.getUserName());
                }
                sb.append(")");
                bpmnComment.setComment(bpmnComment.getComment() + sb.toString());
            }
        }
        BpmnRuntimeCacheProvider.getProcessData().addInsertComment(bpmnComment);
    }

    protected void prepareValidateSql(int serialNumber, String sql, ID id) {
        this.getValidateSqlMap(serialNumber + 1, sql, id).forEach((k, v) -> BpmnRuntimeCacheProvider.cacheBpmnRuntimeValidateSql(k, v));
    }

    protected Map<String, String> getValidateSqlMap(int serialNumber, String validatorSql, Object id) {
        String[] sqls;
        if (StringUtils.isBlank(validatorSql)) {
            return CollectionUtils.emptyMap();
        }
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        String[] var6 = sqls = StringUtils.split(validatorSql, ";");
        int var7 = sqls.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            String sql = var6[var8];
            if (StringUtils.isBlank(sql)) continue;
            String replacedSql = this.getReplacedValidatorSql(sql, id);
            sqlMap.put(sql, "SELECT '" + serialNumber + "' AS SN_, " + StringUtils.removeStartIgnoreCase(StringUtils.trim(replacedSql), "select"));
        }
        return sqlMap;
    }

    protected void validateBySql() {
        Map<String, List<String>> cacheMap = BpmnRuntimeCacheProvider.getBpmnRuntimeValidateSql();
        if (cacheMap != null && !cacheMap.isEmpty()) {
            cacheMap.values().forEach(this::lambda$validateBySql$15);
        }
    }

    protected void prepareCallback(CallbackCategory callbackCateogry, Element element, ID id) {
        String callback = null;
        if (CallbackCategory.pass.equals((Object)callbackCateogry)) {
            callback = BpmnDiagramHelper.getPassCallback(element);
        } else if (CallbackCategory.reject.equals((Object)callbackCateogry)) {
            callback = BpmnDiagramHelper.getRejectCallback(element);
        } else if (CallbackCategory.end.equals((Object)callbackCateogry)) {
            callback = BpmnDiagramHelper.getEndCallback(element);
        }
        if (!StringUtils.isBlank(callback)) {
            BpmnRuntimeCacheProvider.cacheBpmnRuntimeCallback(callback, id);
        }
    }

    protected void prepareEndCallback(CallbackCategory callbackCateogry, Element element, ID id) {
        String endCallback = null;
        if (CallbackCategory.pass.equals((Object)callbackCateogry)) {
            endCallback = BpmnDiagramHelper.getPassCallback(element);
        } else if (CallbackCategory.reject.equals((Object)callbackCateogry)) {
            endCallback = BpmnDiagramHelper.getRejectCallback(element);
        } else if (CallbackCategory.end.equals((Object)callbackCateogry)) {
            endCallback = BpmnDiagramHelper.getEndCallback(element);
        }
        if (!StringUtils.isBlank(endCallback)) {
            BpmnRuntimeCacheProvider.cacheBpmnRuntimeEndCallback(endCallback, id);
        }
    }

    protected void insertNextInstanceTask(Document diagram, CoreBpmnInstanceBean instance, List<Element> nextTaskElementList, CoreBpmnRuntimeSource<T, ID> source) {
        CoreBpmnInstanceTaskHisBean taskHis = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskHisMap() != null ? BpmnRuntimeCacheProvider.getBpmnRuntimeTaskHisMap().get(source.getId()) : null;
        for (Element nextTaskElement : nextTaskElementList) {
            ArrayList<CoreBpmnInstanceTaskUserBean> roleList;
            Long taskId = ApplicationContextHelper.getNextIdentity();
            if (taskHis == null) {
                List<Object> taskRoleList;
                String createdByOrgId;
                boolean nextCandidatorSelected;
                ArrayList<String> userList = new ArrayList<String>();
                roleList = new ArrayList<CoreBpmnInstanceTaskUserBean>();
                if (!StringUtils.isEmpty(BpmnDiagramHelper.getUserTaskInitiatorValue(nextTaskElement)) && !StringUtils.isEmpty(instance.getInitiator())) {
                    userList.add(instance.getInitiator());
                }
                boolean bl = nextCandidatorSelected = !source.getNextCandidatorList().isEmpty() || !source.getNextCandidateRoleList().isEmpty();
                if (nextCandidatorSelected) {
                    userList.addAll(source.getNextCandidatorList());
                    roleList.addAll(source.getNextCandidateRoleList());
                } else {
                    Map<Long, String> userTaskRoleMap;
                    Map<String, String> userTaskCandidatorMap;
                    createdByOrgId = BpmnDiagramHelper.getUserTaskDynamicValue(nextTaskElement);
                    if (!StringUtils.isEmpty(createdByOrgId)) {
                        String[] dynamicValues;
                        String[] var14 = dynamicValues = StringUtils.split(createdByOrgId, ",");
                        int var15 = dynamicValues.length;
                        for (int var16 = 0; var16 < var15; ++var16) {
                            String role;
                            String value = var14[var16];
                            if (StringUtils.startsWith(value, "u:")) {
                                role = (String)source.getVars().get(StringUtils.removeStart(value, "u:"));
                                if (role == null) {
                                    throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.DYNAMIC_USER_NOT_EXISTS");
                                }
                                userList.add(role);
                                continue;
                            }
                            if (!StringUtils.startsWith(value, "r:")) continue;
                            role = ObjectUtils.toString(source.getVars().get(StringUtils.removeStart(value, "r:")));
                            if (StringUtils.isEmpty(role)) {
                                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.DYNAMIC_ROLE_NOT_EXISTS");
                            }
                            roleList.add((CoreBpmnInstanceTaskUserBean)((Object)Long.valueOf(NumberUtils.parseLong(role))));
                        }
                    }
                    if (!(userTaskCandidatorMap = BpmnDiagramHelper.getUserTaskCandidatorValue(nextTaskElement)).isEmpty()) {
                        userList.addAll(userTaskCandidatorMap.keySet());
                    }
                    if (!(userTaskRoleMap = BpmnDiagramHelper.getUserTaskRoleValue(nextTaskElement)).isEmpty()) {
                        roleList.addAll(userTaskRoleMap.keySet());
                    }
                }
                if (BpmnDiagramHelper.isFilterPreviousCandidatorsTask(nextTaskElement)) {
                    taskRoleList = BpmnDiagramHelper.getIncomingUserTaskElementList(diagram, nextTaskElement);
                    if (!taskRoleList.isEmpty()) {
                        for (Element userTaskElement : taskRoleList) {
                            List<String> auditedByList = this.commentService.selectUserTaskAuditedByList(source.getTargetId(), BpmnDiagramHelper.getUserTaskStatusCode(userTaskElement));
                            if (auditedByList == null) continue;
                            userList.removeIf(u -> auditedByList.contains(u));
                        }
                    }
                    userList.remove(LocalContextHelper.getLoginUserId());
                }
                if (userList.isEmpty() && roleList.isEmpty()) {
                    throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.CANDIDATOR_AND_ROLE_NOT_EXISTS");
                }
                if (!userList.isEmpty()) {
                    if (CandidatorFilterStrategy.sameDept.equals((Object)BpmnDiagramHelper.getCandidatorFilterStrategy(nextTaskElement))) {
                        createdByOrgId = (String)CollectionUtils.getValueIgnorecase(source.getVars(), "createdByOrgId");
                        if (!StringUtils.isBlank(createdByOrgId)) {
                            CoreUserService userService = ApplicationContextHelper.getBean(CoreUserService.class);
                            List selectedUserList = userService.selectListByIds(userList);
                            String finalCreatedByOrgId = createdByOrgId;
                            userList.removeIf(u -> selectedUserList.stream().filter(s -> s.getId().equals(u)).noneMatch(s -> finalCreatedByOrgId.equals(s.getOrgId())));
                        } else {
                            logger.warn("No createdByOrgId column in (" + source.getTableName() + "), ignore candidator filter strategy.");
                        }
                    }
                    taskRoleList = userList.stream().distinct().map(u -> {
                        CoreBpmnInstanceTaskUserBean taskUser = new CoreBpmnInstanceTaskUserBean();
                        taskUser.setId(ApplicationContextHelper.getNextIdentity());
                        taskUser.setInstId(instance.getId());
                        taskUser.setInstTaskId(taskId);
                        taskUser.setUserId((String)u);
                        return taskUser;
                    }).collect(Collectors.toList());
                    BpmnRuntimeCacheProvider.getProcessData().addInsertInstanceTaskUser(taskRoleList);
                }
                if (!roleList.isEmpty()) {
                    taskRoleList = roleList.stream().distinct().map(r -> {
                        CoreBpmnInstanceTaskRoleBean taskRole = new CoreBpmnInstanceTaskRoleBean();
                        taskRole.setId(ApplicationContextHelper.getNextIdentity());
                        taskRole.setInstId(instance.getId());
                        taskRole.setInstTaskId(taskId);
                        taskRole.setRoleId((Long)r);
                        return taskRole;
                    }).collect(Collectors.toList());
                    BpmnRuntimeCacheProvider.getProcessData().addInsertInstanceTaskRole(taskRoleList);
                }
                if (userList.isEmpty() && roleList.isEmpty()) {
                    throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.CANDIDATOR_AND_ROLE_NOT_EXISTS");
                }
            } else {
                CoreBpmnInstanceTaskHisCandidatorDTO taskHisCandidator = (CoreBpmnInstanceTaskHisCandidatorDTO)JSON.parseObject((String)taskHis.getCandidatorJson(), CoreBpmnInstanceTaskHisCandidatorDTO.class);
                if (!CollectionUtils.isEmpty(taskHisCandidator.getUserIdList())) {
                    roleList = new ArrayList();
                    for (String createdByOrgId : taskHisCandidator.getUserIdList()) {
                        CoreBpmnInstanceTaskUserBean taskUser = new CoreBpmnInstanceTaskUserBean();
                        taskUser.setId(ApplicationContextHelper.getNextIdentity());
                        taskUser.setInstId(instance.getId());
                        taskUser.setInstTaskId(taskId);
                        taskUser.setUserId(createdByOrgId);
                        roleList.add(taskUser);
                    }
                    BpmnRuntimeCacheProvider.getProcessData().addInsertInstanceTaskUser(roleList);
                }
                if (!CollectionUtils.isEmpty(taskHisCandidator.getRoleIdList())) {
                    roleList = new ArrayList();
                    for (Long roleId : taskHisCandidator.getRoleIdList()) {
                        CoreBpmnInstanceTaskRoleBean taskRole = new CoreBpmnInstanceTaskRoleBean();
                        taskRole.setId(ApplicationContextHelper.getNextIdentity());
                        taskRole.setInstId(instance.getId());
                        taskRole.setInstTaskId(taskId);
                        taskRole.setRoleId(roleId);
                        roleList.add((CoreBpmnInstanceTaskUserBean)((Object)taskRole));
                    }
                    BpmnRuntimeCacheProvider.getProcessData().addInsertInstanceTaskRole(roleList);
                }
            }
            CoreBpmnInstanceTaskBean task = new CoreBpmnInstanceTaskBean();
            task.setId(taskId);
            task.setInstId(instance.getId());
            task.setTaskId(XmlUtils.getAttributeValue(nextTaskElement, "id"));
            task.setTaskName(XmlUtils.getAttributeValue(nextTaskElement, "name"));
            task.setStatusCode(XmlUtils.getAttributeValue(nextTaskElement, "statusCode"));
            if (CounterSignStrategy.none.equals((Object)BpmnDiagramHelper.getCounterSignStrategy(nextTaskElement))) {
                task.setCounterSign("0");
            } else {
                task.setCounterSign("1");
            }
            task.setStatus(TaskStatus.CREATED.name());
            BpmnRuntimeCacheProvider.getProcessData().addInsertInstanceTask(task);
        }
    }

    protected CoreBpmnTargetBean getBpmnTarget(CoreBpmnRuntimeSource<T, ID> source, ProcessStatus status) {
        CoreBpmnTargetBean target = new CoreBpmnTargetBean();
        target.setId(source.getTargetId());
        target.setTargetId(ObjectUtils.toString(source.getId()));
        target.setTargetTable(source.getTableName());
        target.setTargetDesc(source.getDesc());
        target.setProcessStatus(status.name());
        return target;
    }

    protected String getRoute(String sourceName, String targetName) {
        return sourceName + " -> " + Optional.ofNullable(targetName).orElse(I18nHelper.getMessage("SINO.BPMN.TASK.GATEWAY", new String[0]));
    }

    protected String getElementName(Document diagram, String statusCodes) {
        if (StringUtils.isBlank(statusCodes)) {
            return null;
        }
        String[] codes = StringUtils.split(statusCodes, ",");
        StringBuilder sb = new StringBuilder();
        String[] var5 = codes;
        int var6 = codes.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            String code = var5[var7];
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(XmlUtils.getAttributeValue(BpmnDiagramHelper.getProcessElementByStatusCode(diagram, code), "name"));
        }
        return sb.toString();
    }

    protected void updateProcessStatus(String table, List<CoreBpmnInstanceStatusDTO<ID>> statusList) {
        Auditable item;
        Object service = SinoBeanContext.getServiceByTable(table);
        BpmnRuntimeData.BpmnProcessData data = BpmnRuntimeCacheProvider.getProcessData();
        ArrayList<Auditable> itemList = new ArrayList<Auditable>();
        for (CoreBpmnInstanceStatusDTO<ID> status : statusList) {
            item = (Auditable)ClassUtils.newInstance(service.getDao().getType());
            item.setId(status.getId());
            if (data.isAsync()) {
                item.setProcessStatus("waiting$" + status.getProcessStatus().name().toLowerCase());
            } else {
                item.setProcessStatus(status.getProcessStatus().name().toLowerCase());
            }
            itemList.add(item);
        }
        if (data.isAsync()) {
            ArrayList<Auditable> asyncItemList = new ArrayList<Auditable>();
            Iterator<CoreBpmnInstanceStatusDTO<ID>> iterator = statusList.iterator();
            while (iterator.hasNext()) {
                CoreBpmnInstanceStatusDTO<ID> idCoreBpmnInstanceStatusDTO;
                CoreBpmnInstanceStatusDTO<ID> status = idCoreBpmnInstanceStatusDTO = iterator.next();
                item = (Auditable)ClassUtils.newInstance(service.getDao().getType());
                item.setId(status.getId());
                item.setProcessStatus(status.getProcessStatus().name().toLowerCase());
                asyncItemList.add(item);
            }
            data.setUpdateProcessStatusRunnable(() -> service.getDao().update((String[])asyncItemList, (String[])new String[]{"PROCESSSTATUS"}));
        }
        service.getDao().update(itemList, (String[])new String[]{"PROCESSSTATUS"});
    }

    protected void doCallback(Map<String, List<ID>> callbackMap) {
        callbackMap.forEach((k, v) -> {
            int lastIndexOf = k.lastIndexOf(".");
            String className = k.substring(0, lastIndexOf);
            String methodName = k.substring(lastIndexOf + 1);
            Class clazz = ClassUtils.getClass(className);
            Object bean = ApplicationContextHelper.getBean(clazz);
            Method method = ReflectionUtils.findMethod(clazz, methodName, List.class);
            ReflectionUtils.invokeMethod(method, bean, v);
        });
    }

    protected void processData() {
        BpmnRuntimeData.BpmnProcessData data = BpmnRuntimeCacheProvider.getProcessData();
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        int limit = (Integer)ApplicationContextHelper.getEnvironment().getProperty("sino.bpmn.process-data-limit", Integer.class, (Object)50);
        if (limit <= 0 || data.getInsertInstanceList().size() <= limit && data.getInsertInstanceTaskList().size() <= limit) {
            runtimeService.processData(data);
        } else {
            data.setAsync(true);
            LoginUser loginUser = ObjectUtils.clone(LocalContextHelper.getLoginPrincipal());
            ExecutorHelper.submitAfterCommitTransaction(() -> {
                try {
                    if (loginUser != null) {
                        LocalContextHelper.setUserLogin(loginUser);
                    }
                    runtimeService.processData(data);
                }
                finally {
                    if (loginUser != null) {
                        LocalContextHelper.removeUserLogin();
                    }
                }
            });
        }
    }

    private List<CoreBpmnInstanceBean> getBpmnRuntimeInstanceListFromDatabase(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        List targetIdList = sourceList.stream().map(CoreBpmnRuntimeSource::getTargetId).collect(Collectors.toList());
        return this.instanceService.getDao().selectListByOneColumnValues(targetIdList, "TARGETID", new Order[0]);
    }

    private String getReplacedValidatorSql(String sql, Object id) {
        sql = StringUtils.replace(sql, "${id}", ObjectUtils.toString(id));
        sql = StringUtils.replace(sql, "${loginUser.id}", LocalContextHelper.getLoginUserId());
        sql = StringUtils.replace(sql, "${loginUser.userName}", LocalContextHelper.getLoginUserName());
        sql = StringUtils.replace(sql, "${loginUser.orgId}", LocalContextHelper.getLoginUser().getOrgId());
        return StringUtils.replace(sql, "${loginUser.orgName}", LocalContextHelper.getLoginUser().getOrgName());
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$validateBySql$15(List sql) {
        mapList = this.globalMapper.selectListBySqlList(sql);
        invalidContainer = new HashMap<Integer, Object>();
        var4 = mapList.iterator();
        block0: while (true) {
            if (!var4.hasNext()) {
                if (!invalidContainer.isEmpty()) {
                    sbx = new StringBuilder();
                    invalidContainer.forEach((BiConsumer<Integer, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$validateBySql$13(java.lang.StringBuilder java.lang.Integer java.lang.String ), (Ljava/lang/Integer;Ljava/lang/String;)V)((StringBuilder)sbx));
                    throw new CheckedException(sbx.toString());
                }
                return;
            }
            map = var4.next();
            CollectionUtils.upperCaseKey(map);
            finalInvalidColumnList = invalidColumnList = new ArrayList<E>();
            map.forEach((BiConsumer<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$validateBySql$14(java.util.ArrayList java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)V)(finalInvalidColumnList));
            if (invalidColumnList.isEmpty()) continue;
            serialNumber = NumberUtils.parseInt(map.get("SN_"));
            type = (String)map.get("TYPE_");
            table = (String)map.get("TABLE_");
            desc = (String)map.get("DESC_");
            var11 = invalidColumnList.iterator();
            while (true) {
                if (var11.hasNext()) ** break;
                continue block0;
                column = (String)var11.next();
                message = (String)invalidContainer.get(serialNumber);
                if (StringUtils.isEmpty((String)message)) {
                    sb = new StringBuilder();
                    if (StringUtils.isEmpty(desc)) {
                        sb.append(I18nHelper.getMessage("SINO.VALIDATOR.INVALID_ROWNUMBER", new String[0])).append(" ").append(serialNumber);
                    } else {
                        sb.append(I18nHelper.getMessage("SINO.VALIDATOR.CHECKED_DATA", new String[0])).append(" ").append(desc);
                    }
                    sb.append(" :<br>").append(I18nHelper.getMessage(table + "." + column, new String[0])).append(" ").append(I18nHelper.getMessage(type, new String[0]));
                    message = sb.toString();
                } else {
                    message = (String)message + "<br>" + I18nHelper.getMessage(table + "." + column, new String[0]) + " " + I18nHelper.getMessage(type, new String[0]);
                }
                invalidContainer.put(serialNumber, message);
            }
            break;
        }
    }

    private static /* synthetic */ void lambda$validateBySql$14(ArrayList finalInvalidColumnList, Object k, Object v) {
        if ("0".equals(v)) {
            finalInvalidColumnList.add(k);
        }
    }

    private static /* synthetic */ void lambda$validateBySql$13(StringBuilder sbx, Integer k, String v) {
        if (sbx.length() > 0) {
            sbx.append(";");
        }
        sbx.append(v);
    }

    protected static enum CallbackCategory {
        pass,
        reject,
        end;

    }
}

