/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.impl;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.executor.ExecutorHelper;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.support.PersistableMetadataHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.CoreBpmnHelper;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceNextTaskElementDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskHisBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskHisCandidatorDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskRoleBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskUserBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnTargetBean;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeService;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeData;
import net.sinodawn.module.sys.bpmn.engine.support.CoreBpmnRuntimeCompleteProcessSupport;
import net.sinodawn.module.sys.bpmn.engine.support.CoreBpmnRuntimeEndProcessSupport;
import net.sinodawn.module.sys.bpmn.engine.support.CoreBpmnRuntimeOddRejectProcessSupport;
import net.sinodawn.module.sys.bpmn.engine.support.CoreBpmnRuntimeRejectProcessSupport;
import net.sinodawn.module.sys.bpmn.engine.support.CoreBpmnRuntimeStartProcessSupport;
import net.sinodawn.module.sys.bpmn.engine.support.CoreBpmnRuntimeTransferProcessSupport;
import net.sinodawn.module.sys.bpmn.engine.support.CoreBpmnRuntimeUndoProcessSupport;
import net.sinodawn.module.sys.bpmn.engine.support.CoreBpmnRuntimeWithdrawProcessSupport;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnCommentService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskHisService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskRoleService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskUserService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnTargetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreBpmnRuntimeServiceImpl
implements CoreBpmnRuntimeService {
    @Autowired
    private CoreBpmnProcService procService;
    @Autowired
    private CoreBpmnInstanceService instanceService;
    @Autowired
    private CoreBpmnInstanceTaskService instanceTaskService;
    @Autowired
    private CoreBpmnInstanceTaskUserService instanceTaskUserService;
    @Autowired
    private CoreBpmnInstanceTaskRoleService instanceTaskRoleService;
    @Autowired
    private CoreBpmnCommentService commentService;
    @Autowired
    private CoreBpmnTargetService bpmnTargetService;
    @Autowired
    private CoreBpmnInstanceTaskHisService taskHisService;

    @Override
    @Transactional(timeout=300)
    public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> startProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        CoreBpmnRuntimeStartProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeStartProcessSupport<T, ID>();
        return processSupport.apply(sourceList);
    }

    @Override
    @Transactional(timeout=300)
    public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> withdrawProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        CoreBpmnRuntimeWithdrawProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeWithdrawProcessSupport<T, ID>();
        return processSupport.apply(sourceList);
    }

    @Override
    @Transactional(timeout=300)
    public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> completeTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        CoreBpmnRuntimeCompleteProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeCompleteProcessSupport<T, ID>();
        return processSupport.apply(sourceList);
    }

    @Override
    @Transactional(timeout=300)
    public <T extends Auditable<ID>, ID extends Serializable> void transferTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        CoreBpmnRuntimeTransferProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeTransferProcessSupport<T, ID>();
        processSupport.apply(sourceList);
    }

    @Override
    @Transactional(timeout=300)
    public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> endTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        CoreBpmnRuntimeEndProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeEndProcessSupport<T, ID>();
        return processSupport.apply(sourceList);
    }

    @Override
    @Transactional(timeout=300)
    public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> undo(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        CoreBpmnRuntimeUndoProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeUndoProcessSupport<T, ID>();
        return processSupport.apply(sourceList);
    }

    @Override
    @Transactional(timeout=300)
    public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> rejectTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        CoreBpmnRuntimeRejectProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeRejectProcessSupport<T, ID>();
        return processSupport.apply(sourceList);
    }

    @Override
    @Transactional(timeout=300)
    public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> oddRejectTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        CoreBpmnRuntimeOddRejectProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeOddRejectProcessSupport<T, ID>();
        return processSupport.apply(sourceList);
    }

    @Override
    public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceNextTaskElementDTO<ID>> getNextTaskList(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        List var2;
        try {
            BpmnRuntimeCacheProvider.init(sourceList);
            var2 = BpmnRuntimeCacheProvider.getNextTaskList();
        }
        finally {
            BpmnRuntimeCacheProvider.remove();
        }
        return var2;
    }

    @Override
    public <T extends Auditable<ID>, ID extends Serializable> Map<ID, CoreBpmnProcBean> selectRuntimeBpmnProcList(List<T> itemList) {
        if (itemList.isEmpty()) {
            return CollectionUtils.emptyMap();
        }
        ArrayList<Auditable> rawItemList = new ArrayList<Auditable>();
        ArrayList<Auditable> approveItemList = new ArrayList<Auditable>();
        for (Auditable item : itemList) {
            if (StringUtils.startsWithIgnoreCase(item.getProcessStatus(), ProcessStatus.DRAFT.name())) {
                rawItemList.add(item);
                continue;
            }
            if (!StringUtils.startsWithIgnoreCase(item.getProcessStatus(), ProcessStatus.APPROVE.name())) continue;
            approveItemList.add(item);
        }
        HashMap<Serializable, CoreBpmnProcBean> runtimeMap = new HashMap<Serializable, CoreBpmnProcBean>();
        if (!rawItemList.isEmpty()) {
            List<CoreBpmnProcBean> procList = this.procService.selectRuntimeBpmnProcList(PersistableMetadataHelper.getTableName(((Auditable)itemList.get(0)).getClass()), LocalContextHelper.getLoginOrgId());
            if (procList.isEmpty()) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_NOT_EXISTS");
            }
            for (Auditable rawItem : rawItemList) {
                ArrayList<CoreBpmnProcBean> matchProcList = new ArrayList<CoreBpmnProcBean>();
                for (CoreBpmnProcBean proc : procList) {
                    if (StringUtils.isBlank(proc.getExpression())) {
                        matchProcList.add(proc);
                        continue;
                    }
                    Map<String, Object> vars = BeanUtils.deeplyToMap(rawItem);
                    if (!CoreBpmnHelper.evalExpression(proc.getExpression(), vars)) continue;
                    if (!matchProcList.isEmpty() && !StringUtils.isBlank(((CoreBpmnProcBean)matchProcList.get(0)).getExpression())) {
                        throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.MATCH_MULTIPLE_PROC");
                    }
                    matchProcList.add(0, proc);
                }
                if (matchProcList.isEmpty()) {
                    throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_NOT_EXISTS");
                }
                if (matchProcList.size() == 1) {
                    runtimeMap.put((Serializable)rawItem.getId(), (CoreBpmnProcBean)matchProcList.get(0));
                    continue;
                }
                if (!StringUtils.isBlank(((CoreBpmnProcBean)matchProcList.get(0)).getExpression())) {
                    runtimeMap.put((Serializable)rawItem.getId(), (CoreBpmnProcBean)matchProcList.get(0));
                    continue;
                }
                for (CoreBpmnProcBean proc : matchProcList) {
                    if (StringUtils.startsWith(proc.getExt$Item("orgqty"), "0")) continue;
                    if (runtimeMap.get(rawItem.getId()) != null) {
                        throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.MATCH_MULTIPLE_PROC");
                    }
                    runtimeMap.put((Serializable)rawItem.getId(), proc);
                }
                if (runtimeMap.get(rawItem.getId()) != null) continue;
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.MATCH_MULTIPLE_PROC");
            }
        }
        if (!approveItemList.isEmpty()) {
            String tableName = PersistableMetadataHelper.getTableName(((Auditable)itemList.get(0)).getClass());
            List targetIdList = approveItemList.stream().map(i -> tableName + "$" + i.getId()).collect(Collectors.toList());
            List instanceList = this.instanceService.selectListByFilter(SearchFilter.instance().match("TARGETID", targetIdList).filter(MatchPattern.OR), new Order[0]);
            approveItemList.forEach(a -> {
                CoreBpmnProcBean var10000 = runtimeMap.put((Serializable)a.getId(), (CoreBpmnProcBean)this.procService.selectById(instanceList.stream().filter(i -> i.getTargetId().equals(tableName + "$" + a.getId())).findAny().get().getProcId()));
            });
        }
        return runtimeMap;
    }

    @Override
    public CoreBpmnProcBean getLatestBpmnProc(String procCode) {
        return this.procService.selectLatestProc(procCode);
    }

    @Override
    public <ID extends Serializable> List<CoreBpmnInstanceTaskBean> selectAuditableInstanceTaskList(String table, ID id, @Nullable String userId) {
        CoreBpmnInstanceBean filter = new CoreBpmnInstanceBean();
        filter.setTargetId(CoreBpmnHelper.getTargetId(table, id));
        CoreBpmnInstanceBean instance = this.instanceService.getDao().selectOneIfPresent((CoreBpmnInstanceBean)filter, new String[0]);
        return instance == null ? CollectionUtils.emptyList() : this.instanceTaskService.selectAuditableInstanceTaskList(userId, Arrays.asList(instance.getId()));
    }

    @Override
    @Transactional
    public void processData(BpmnRuntimeData.BpmnProcessData data) {
        ArrayList<CoreBpmnInstanceTaskHisBean> taskHisList;
        CoreBpmnTargetBean bpmnTarget;
        List selectedBpmnTargetList;
        List deleteTaskHisList;
        if (!data.getInsertOrUpdateBpmnTargetList().isEmpty()) {
            deleteTaskHisList = data.getInsertOrUpdateBpmnTargetList().stream().map(CoreBpmnTargetBean::getId).collect(Collectors.toList());
            List finalSelectedBpmnTargetList = selectedBpmnTargetList = this.bpmnTargetService.getDao().selectListByIds(deleteTaskHisList, new Order[0]);
            List insertBpmnTargetList = data.getInsertOrUpdateBpmnTargetList().stream().filter(i -> finalSelectedBpmnTargetList.stream().noneMatch(s -> s.getId().equals(i.getId()))).collect(Collectors.toList());
            if (!insertBpmnTargetList.isEmpty()) {
                this.bpmnTargetService.getDao().insert(insertBpmnTargetList);
            }
            ArrayList<CoreBpmnTargetBean> updateBpmnTargetList = new ArrayList<CoreBpmnTargetBean>();
            Iterator<Object> var6 = selectedBpmnTargetList.iterator();
            while (true) {
                if (!var6.hasNext()) {
                    if (updateBpmnTargetList.isEmpty()) break;
                    this.bpmnTargetService.getDao().update(updateBpmnTargetList, (String[])new String[]{"TARGETDESC", "PROCESSSTATUS"});
                    break;
                }
                CoreBpmnTargetBean finalBpmnTarget = bpmnTarget = (CoreBpmnTargetBean)var6.next();
                bpmnTarget = data.getInsertOrUpdateBpmnTargetList().stream().filter(i -> i.getId().equals(finalBpmnTarget.getId())).findAny().get();
                if (ObjectUtils.equals(bpmnTarget.getTargetDesc(), bpmnTarget.getTargetDesc()) && ObjectUtils.equals(bpmnTarget.getProcessStatus(), bpmnTarget.getProcessStatus())) continue;
                updateBpmnTargetList.add(bpmnTarget);
            }
        }
        if (!data.getUpdateProcessStatusBpmnTargetList().isEmpty()) {
            deleteTaskHisList = data.getUpdateProcessStatusBpmnTargetList().stream().map(CoreBpmnTargetBean::getId).collect(Collectors.toList());
            selectedBpmnTargetList = this.bpmnTargetService.getDao().selectListByIds(deleteTaskHisList, new Order[0]);
            ArrayList<CoreBpmnTargetBean> updateBpmnTargetList = new ArrayList<CoreBpmnTargetBean>();
            for (CoreBpmnTargetBean selectedBpmnTarget : selectedBpmnTargetList) {
                bpmnTarget = data.getUpdateProcessStatusBpmnTargetList().stream().filter(i -> i.getId().equals(selectedBpmnTarget.getId())).findAny().get();
                if (ObjectUtils.equals(bpmnTarget.getProcessStatus(), selectedBpmnTarget.getProcessStatus())) continue;
                updateBpmnTargetList.add(bpmnTarget);
            }
            if (!updateBpmnTargetList.isEmpty()) {
                this.bpmnTargetService.getDao().update(data.getUpdateProcessStatusBpmnTargetList(), (String[])new String[]{"PROCESSSTATUS"});
            }
        }
        if (!data.getDeleteBpmnTargetIdList().isEmpty()) {
            this.bpmnTargetService.getDao().deleteByIdList(data.getDeleteBpmnTargetIdList());
        }
        if (!data.getInsertInstanceList().isEmpty()) {
            if (!data.getDeleteInstanceList().isEmpty()) {
                data.getInsertInstanceList().removeIf(i -> data.getDeleteInstanceList().stream().anyMatch(d -> d.getId().equals(i.getId())));
            }
            if (!data.getInsertInstanceList().isEmpty()) {
                this.instanceService.getDao().insert(data.getInsertInstanceList());
            }
        }
        if (!data.getDeleteInstanceList().isEmpty()) {
            ArrayList<CoreBpmnInstanceTaskHisBean> finalTaskHisList = taskHisList = new ArrayList<CoreBpmnInstanceTaskHisBean>();
            data.getDeleteInstanceList().forEach(i -> {
                CoreBpmnInstanceTaskBean taskFilter = new CoreBpmnInstanceTaskBean();
                taskFilter.setInstId(i.getId());
                finalTaskHisList.add((CoreBpmnInstanceTaskHisBean)((Object)taskFilter));
            });
            data.addDeleteInstanceTaskId(this.instanceTaskService.getDao().selectIdList(taskHisList, new Order[0]));
            this.instanceService.getDao().deleteBy(data.getDeleteInstanceList(), new String[0]);
        }
        if (!data.getDeleteInstanceTaskIdList().isEmpty() || !data.getDeleteCandidatorInstanceTaskIdList().isEmpty()) {
            taskHisList = new ArrayList();
            ArrayList taskRoleFilterList = new ArrayList();
            ArrayList<CoreBpmnInstanceTaskHisBean> finalTaskHisList1 = taskHisList;
            data.getDeleteInstanceTaskIdList().forEach(i -> {
                CoreBpmnInstanceTaskUserBean taskUserFilter = new CoreBpmnInstanceTaskUserBean();
                taskUserFilter.setInstTaskId((Long)i);
                finalTaskHisList1.add((CoreBpmnInstanceTaskHisBean)((Object)taskUserFilter));
                CoreBpmnInstanceTaskRoleBean taskRoleFilter = new CoreBpmnInstanceTaskRoleBean();
                taskRoleFilter.setInstTaskId((Long)i);
                taskRoleFilterList.add(taskRoleFilter);
            });
            ArrayList<CoreBpmnInstanceTaskHisBean> finalTaskHisList2 = taskHisList;
            data.getDeleteCandidatorInstanceTaskIdList().forEach(i -> {
                CoreBpmnInstanceTaskUserBean taskUserFilter = new CoreBpmnInstanceTaskUserBean();
                taskUserFilter.setInstTaskId((Long)i);
                finalTaskHisList2.add((CoreBpmnInstanceTaskHisBean)((Object)taskUserFilter));
                CoreBpmnInstanceTaskRoleBean taskRoleFilter = new CoreBpmnInstanceTaskRoleBean();
                taskRoleFilter.setInstTaskId((Long)i);
                taskRoleFilterList.add(taskRoleFilter);
            });
            data.addDeleteInstanceTaskUserId(this.instanceTaskUserService.getDao().selectIdList(taskHisList, new Order[0]));
            data.addDeleteInstanceTaskRoleId(this.instanceTaskRoleService.getDao().selectIdList(taskRoleFilterList, new Order[0]));
            if (!data.getDeleteInstanceTaskIdList().isEmpty()) {
                this.instanceTaskService.getDao().deleteByIdList(data.getDeleteInstanceTaskIdList());
            }
        }
        if (!data.getUpdateInstanceTaskStatusList().isEmpty()) {
            data.getUpdateInstanceTaskStatusList().removeIf(t -> data.getDeleteInstanceTaskIdList().contains(t.getId()));
            if (!data.getUpdateInstanceTaskStatusList().isEmpty()) {
                this.instanceTaskService.getDao().update(data.getUpdateInstanceTaskStatusList(), (String[])new String[]{"STATUS"});
            }
        }
        if (!data.getInsertInstanceTaskList().isEmpty()) {
            data.getInsertInstanceTaskList().removeIf(t -> data.getDeleteInstanceTaskIdList().contains(t.getId()));
            if (!data.getInsertInstanceTaskList().isEmpty()) {
                this.instanceTaskService.getDao().insert(data.getInsertInstanceTaskList());
            }
        }
        if (!data.getInsertInstanceTaskUserList().isEmpty()) {
            data.getInsertInstanceTaskUserList().removeIf(t -> data.getDeleteInstanceTaskUserIdList().contains(t.getId()));
            if (!data.getInsertInstanceTaskUserList().isEmpty()) {
                this.instanceTaskUserService.getDao().insert(data.getInsertInstanceTaskUserList());
            }
        }
        if (!data.getInsertInstanceTaskRoleList().isEmpty()) {
            data.getInsertInstanceTaskRoleList().removeIf(t -> data.getDeleteInstanceTaskRoleIdList().contains(t.getId()));
            if (!data.getInsertInstanceTaskRoleList().isEmpty()) {
                this.instanceTaskRoleService.getDao().insert(data.getInsertInstanceTaskRoleList());
            }
        }
        if (!data.getInsertInstanceTaskList().isEmpty()) {
            taskHisList = new ArrayList();
            for (CoreBpmnInstanceTaskBean task : data.getInsertInstanceTaskList()) {
                CoreBpmnInstanceTaskHisCandidatorDTO hisCandidator = new CoreBpmnInstanceTaskHisCandidatorDTO();
                for (CoreBpmnInstanceTaskUserBean taskUser : data.getInsertInstanceTaskUserList()) {
                    if (!task.getId().equals(taskUser.getInstTaskId())) continue;
                    hisCandidator.addUserId(taskUser.getUserId());
                }
                for (CoreBpmnInstanceTaskRoleBean taskRole : data.getInsertInstanceTaskRoleList()) {
                    if (!task.getId().equals(taskRole.getInstTaskId())) continue;
                    hisCandidator.addRoleId(taskRole.getRoleId());
                }
                CoreBpmnInstanceTaskHisBean taskHis = new CoreBpmnInstanceTaskHisBean();
                taskHis.setId(ApplicationContextHelper.getNextIdentity());
                taskHis.setInstId(task.getInstId());
                taskHis.setStatusCode(task.getStatusCode());
                taskHis.setCandidatorJson(JSON.toJSONString((Object)hisCandidator));
                taskHisList.add(taskHis);
            }
            this.taskHisService.getDao().insert(taskHisList);
        }
        if (!data.getDeleteBpmnTargetIdList().isEmpty() && !(deleteTaskHisList = data.getDeleteInstanceList().stream().filter(d -> data.getDeleteBpmnTargetIdList().contains(d.getTargetId())).map(d -> {
            CoreBpmnInstanceTaskHisBean taskHis = new CoreBpmnInstanceTaskHisBean();
            taskHis.setInstId(d.getId());
            return taskHis;
        }).collect(Collectors.toList())).isEmpty()) {
            List finalDeleteTaskHisList = deleteTaskHisList;
            ExecutorHelper.submit(() -> this.taskHisService.getDao().deleteBy((List)finalDeleteTaskHisList, new String[]{"INSTID"}));
        }
        if (!data.getInsertCommentList().isEmpty()) {
            this.commentService.getDao().insert(data.getInsertCommentList());
        }
        if (!data.getDeleteInstanceTaskUserIdList().isEmpty()) {
            this.instanceTaskUserService.getDao().deleteByIdList(data.getDeleteInstanceTaskUserIdList());
        }
        if (!data.getDeleteInstanceTaskRoleIdList().isEmpty()) {
            this.instanceTaskRoleService.getDao().deleteByIdList(data.getDeleteInstanceTaskRoleIdList());
        }
        if (data.isAsync() && data.getUpdateProcessStatusRunnable() != null) {
            data.getUpdateProcessStatusRunnable().run();
        }
    }
}

