/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.context.SinoBeanContext;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.support.auditable.service.GenericAuditableService;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import net.sinodawn.module.sys.bpmn.CoreBpmnHelper;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceCandidatorDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceNextTaskElementDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskHisBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.ProcessElementType;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.diagram.attribute.CandidatorFilterStrategy;
import net.sinodawn.module.sys.bpmn.diagram.attribute.CounterSignStrategy;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeData;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnCommentService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDiagramService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import org.dom4j.Document;
import org.dom4j.Element;

public class BpmnRuntimeCacheProvider {
    private static final ThreadLocal<List<BpmnRuntimeData>> BPMN_CACHE = new ThreadLocal();

    public static <T extends Auditable<ID>, ID extends Serializable> BpmnRuntimeData<T, ID> getRuntimeData() {
        List<BpmnRuntimeData> dataList = BPMN_CACHE.get();
        if (dataList == null) {
            dataList = new ArrayList<BpmnRuntimeData>();
            BPMN_CACHE.set(dataList);
            BpmnRuntimeData runtimeData = new BpmnRuntimeData();
            dataList.add(runtimeData);
        }
        return dataList.get(dataList.size() - 1);
    }

    public static BpmnRuntimeData.BpmnProcessData getProcessData() {
        return BpmnRuntimeCacheProvider.getRuntimeData().getProcessData();
    }

    public static <T extends Auditable<ID>, ID extends Serializable> void init(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        List<BpmnRuntimeData> dataList = BPMN_CACHE.get();
        if (dataList == null) {
            dataList = new ArrayList<BpmnRuntimeData>();
            BPMN_CACHE.set(dataList);
        }
        BpmnRuntimeData<T, ID> runtimeData = new BpmnRuntimeData<T, ID>();
        dataList.add(runtimeData);
        runtimeData.setSourceList(sourceList);
    }

    public static void remove() {
        List<BpmnRuntimeData> dataList = BPMN_CACHE.get();
        if (dataList != null && dataList.size() > 1) {
            dataList.remove(dataList.size() - 1);
        } else {
            BPMN_CACHE.remove();
        }
    }

    public static <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnRuntimeSource<T, ID>> getBpmnRuntimeSourceList() {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        return runtimeData.getSourceList();
    }

    public static <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceBean> getBpmnRuntimeInstanceList() {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        List<CoreBpmnInstanceBean> instanceList = runtimeData.getInstanceList();
        if (instanceList == null) {
            CoreBpmnInstanceService instanceService = ApplicationContextHelper.getBean(CoreBpmnInstanceService.class);
            List targetIdList = BpmnRuntimeCacheProvider.getBpmnRuntimeSourceList().stream().map(CoreBpmnRuntimeSource::getTargetId).collect(Collectors.toList());
            instanceList = instanceService.getDao().selectListByOneColumnValues(targetIdList, "TARGETID", new Order[0]);
            runtimeData.setInstanceList(instanceList);
        }
        return instanceList;
    }

    public static <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceTaskBean> getBpmnRuntimeInstanceTaskList() {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        List<CoreBpmnInstanceTaskBean> instanceTaskList = runtimeData.getInstanceTaskList();
        if (instanceTaskList == null) {
            instanceTaskList = new ArrayList<CoreBpmnInstanceTaskBean>();
            List sourceList = BpmnRuntimeCacheProvider.getBpmnRuntimeSourceList();
            List<CoreBpmnInstanceBean> instanceList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceList();
            CoreBpmnInstanceTaskService instanceTaskService = ApplicationContextHelper.getBean(CoreBpmnInstanceTaskService.class);
            List<Long> permissionRequiredBpmnInstanceIdList = instanceList.stream().filter(i -> sourceList.stream().anyMatch(s -> s.getTargetId().equals(i.getTargetId()) && s.isRuntimeCheckPermission())).map(i -> i.getId()).collect(Collectors.toList());
            List<Long> permissionIgnoredBpmnInstanceIdList = instanceList.stream().filter(i -> sourceList.stream().anyMatch(s -> s.getTargetId().equals(i.getTargetId()) && !s.isRuntimeCheckPermission())).map(i -> i.getId()).collect(Collectors.toList());
            if (LocalContextHelper.isUserLogin()) {
                if (!permissionRequiredBpmnInstanceIdList.isEmpty()) {
                    instanceTaskList.addAll(instanceTaskService.selectAuditableInstanceTaskList(LocalContextHelper.getLoginUserId(), permissionRequiredBpmnInstanceIdList));
                }
                if (!permissionIgnoredBpmnInstanceIdList.isEmpty()) {
                    instanceTaskList.addAll(instanceTaskService.selectAuditableInstanceTaskList(null, permissionIgnoredBpmnInstanceIdList));
                }
            } else if (!permissionIgnoredBpmnInstanceIdList.isEmpty()) {
                instanceTaskList.addAll(instanceTaskService.selectAuditableInstanceTaskList(null, permissionIgnoredBpmnInstanceIdList));
            }
            runtimeData.setInstanceTaskList(instanceTaskList);
        }
        return instanceTaskList;
    }

    public static <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceTaskBean> getBpmnRuntimeUnlimitedInstanceTaskList() {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        List<CoreBpmnInstanceTaskBean> unlimitedInstanceTaskList = runtimeData.getUnlimitedInstanceTaskList();
        if (unlimitedInstanceTaskList == null) {
            List<CoreBpmnInstanceBean> instanceList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceList();
            CoreBpmnInstanceTaskService instanceTaskService = ApplicationContextHelper.getBean(CoreBpmnInstanceTaskService.class);
            List<Long> unlimitedBpmnInstanceIdList = instanceList.stream().map(i -> i.getId()).collect(Collectors.toList());
            unlimitedInstanceTaskList = instanceTaskService.selectAuditableInstanceTaskList(null, unlimitedBpmnInstanceIdList);
            runtimeData.setUnlimitedInstanceTaskList(unlimitedInstanceTaskList);
        }
        return unlimitedInstanceTaskList;
    }

    public static <T extends Auditable<ID>, ID extends Serializable> List<String> getBpmnPreviousTaskAuditedByList(CoreBpmnRuntimeSource<T, ID> source) {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        List<String> previousTaskAuditedByList = runtimeData.getPreviousTaskAuditedByList();
        if (previousTaskAuditedByList == null) {
            List<Element> userTaskElementList;
            Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
            previousTaskAuditedByList = new ArrayList<String>();
            if (BpmnDiagramHelper.isFilterPreviousCandidatorsTask(taskElement) && !(userTaskElementList = BpmnDiagramHelper.getIncomingUserTaskElementList(BpmnRuntimeCacheProvider.getBpmnRuntimeDocument(source), taskElement)).isEmpty()) {
                for (Element userTaskElement : userTaskElementList) {
                    List<String> auditedByList = ApplicationContextHelper.getBean(CoreBpmnCommentService.class).selectUserTaskAuditedByList(source.getTargetId(), BpmnDiagramHelper.getUserTaskStatusCode(userTaskElement));
                    if (auditedByList != null && auditedByList.contains(LocalContextHelper.getLoginUserId())) {
                        throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.FILTER_PREVIOUS_CANDIDATORS");
                    }
                    previousTaskAuditedByList.addAll(auditedByList);
                }
            }
            runtimeData.setPreviousTaskAuditedByList(previousTaskAuditedByList);
        }
        return previousTaskAuditedByList;
    }

    public static <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceCandidatorDTO> getBpmnRuntimeInstanceCandidatorList() {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        List<CoreBpmnInstanceCandidatorDTO> instanceCandidatorList = runtimeData.getInstanceCandidatorList();
        if (instanceCandidatorList == null) {
            List<CoreBpmnInstanceBean> instanceList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceList();
            List<Long> idList = instanceList.stream().map(i -> i.getId()).collect(Collectors.toList());
            CoreBpmnInstanceService instanceService = ApplicationContextHelper.getBean(CoreBpmnInstanceService.class);
            instanceCandidatorList = instanceService.selectInstanceCandidatorList(idList);
            runtimeData.setInstanceCandidatorList(instanceCandidatorList);
        }
        return instanceCandidatorList;
    }

    public static <T extends Auditable<ID>, ID extends Serializable> CoreBpmnInstanceBean getBpmnRuntimeInstance(CoreBpmnRuntimeSource<T, ID> source) {
        List<CoreBpmnInstanceBean> instanceList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceList();
        return instanceList.stream().filter(i -> i.getTargetId().equals(source.getTargetId())).findAny().orElse(null);
    }

    public static <T extends Auditable<ID>, ID extends Serializable> CoreBpmnInstanceTaskBean getBpmnRuntimeInstanceTask(CoreBpmnRuntimeSource<T, ID> source) {
        CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
        List<CoreBpmnInstanceTaskBean> runtimeTaskList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTaskList();
        List instanceTaskList = runtimeTaskList.stream().filter(t -> {
            boolean flag = t.getInstId().equals(instance.getId());
            if (flag && !StringUtils.isEmpty(source.getCurrentStatusCode())) {
                flag = source.getCurrentStatusCode().equals(t.getStatusCode());
            }
            return flag;
        }).collect(Collectors.toList());
        if (instanceTaskList.isEmpty()) {
            throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.NOT_AUTHORIZED");
        }
        if (instanceTaskList.size() > 1) {
            throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.MULTIPLE_TASK_ASSIGNED");
        }
        return (CoreBpmnInstanceTaskBean)instanceTaskList.get(0);
    }

    public static <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceTaskBean> getBpmnRuntimeInstanceTaskList(CoreBpmnRuntimeSource<T, ID> source) {
        CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
        List<CoreBpmnInstanceTaskBean> runtimeTaskList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTaskList();
        return runtimeTaskList.stream().filter(t -> {
            boolean flag = t.getInstId().equals(instance.getId());
            if (flag && !StringUtils.isEmpty(source.getCurrentStatusCode())) {
                flag = source.getCurrentStatusCode().equals(t.getStatusCode());
            }
            return flag;
        }).collect(Collectors.toList());
    }

    public static <T extends Auditable<ID>, ID extends Serializable> CoreBpmnProcBean getBpmnProc(CoreBpmnRuntimeSource<T, ID> source) {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        CoreBpmnProcBean proc = runtimeData.getProcMap().get(source.getId());
        if (proc == null) {
            CoreBpmnProcService procService = ApplicationContextHelper.getBean(CoreBpmnProcService.class);
            if (source.getProcId() != null) {
                proc = (CoreBpmnProcBean)procService.selectById(source.getProcId());
            } else {
                CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
                proc = (CoreBpmnProcBean)procService.selectByIdIfPresent(instance.getProcId());
            }
            runtimeData.getProcMap().put(source.getId(), proc);
        }
        return proc;
    }

    public static <T extends Auditable<ID>, ID extends Serializable> Document getBpmnRuntimeDocument(CoreBpmnRuntimeSource<T, ID> source) {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        Document document = runtimeData.getDocumentMap().get(source.getId());
        if (document == null) {
            CoreBpmnProcBean proc = BpmnRuntimeCacheProvider.getBpmnProc(source);
            Objects.requireNonNull(proc, "CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_NOT_EXISTS");
            CoreBpmnDiagramService diagramService = ApplicationContextHelper.getBean(CoreBpmnDiagramService.class);
            document = diagramService.getDocument(proc.getDiagramId());
            runtimeData.getDocumentMap().put(source.getId(), document);
        }
        return document;
    }

    public static <T extends Auditable<ID>, ID extends Serializable> Element getBpmnRuntimeTaskElement(CoreBpmnRuntimeSource<T, ID> source) {
        Document diagram = BpmnRuntimeCacheProvider.getBpmnRuntimeDocument(source);
        if (BpmnRuntimeCacheProvider.isStartTask(source)) {
            return BpmnDiagramHelper.getProcessElement(diagram, ProcessElementType.START_EVENT);
        }
        CoreBpmnInstanceTaskBean instanceTask = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(source);
        return BpmnDiagramHelper.getProcessElement(diagram, instanceTask.getTaskId());
    }

    public static <T extends Auditable<ID>, ID extends Serializable> void cacheBpmnRuntimeCallback(String callback, ID id) {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        List<ID> idList = runtimeData.getCallbackMap().get(callback);
        if (idList == null) {
            idList = new ArrayList<ID>();
            runtimeData.getCallbackMap().put(callback, idList);
        }
        if (!idList.contains(id)) {
            idList.add(id);
        }
    }

    public static <T extends Auditable<ID>, ID extends Serializable> Map<String, List<ID>> getBpmnRuntimeCallback() {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        return runtimeData.getCallbackMap();
    }

    public static <T extends Auditable<ID>, ID extends Serializable> void removeBpmnRuntimeCallback(ID id) {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        Iterator<Map.Entry<String, List<ID>>> iterator = runtimeData.getCallbackMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<ID>> entry = iterator.next();
            if (!entry.getValue().contains(id)) continue;
            if (entry.getValue().size() == 1) {
                iterator.remove();
                continue;
            }
            entry.getValue().remove(id);
        }
    }

    public static <T extends Auditable<ID>, ID extends Serializable> void cacheBpmnRuntimeEndCallback(String endCallback, ID id) {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        List<ID> idList = runtimeData.getEndCallbackMap().get(endCallback);
        if (idList == null) {
            idList = new ArrayList<ID>();
            runtimeData.getEndCallbackMap().put(endCallback, idList);
        }
        if (!idList.contains(id)) {
            idList.add(id);
        }
    }

    public static <T extends Auditable<ID>, ID extends Serializable> void cacheBpmnRuntimeTaskHisMap(Map<ID, CoreBpmnInstanceTaskHisBean> taskHisMap) {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        if (!taskHisMap.isEmpty()) {
            runtimeData.setTaskHisMap(taskHisMap);
        }
    }

    public static <T extends Auditable<ID>, ID extends Serializable> Map<ID, CoreBpmnInstanceTaskHisBean> getBpmnRuntimeTaskHisMap() {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        return runtimeData.getTaskHisMap();
    }

    public static <T extends Auditable<ID>, ID extends Serializable> Map<String, List<ID>> getBpmnRuntimeEndCallback() {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        return runtimeData.getEndCallbackMap();
    }

    public static <T extends Auditable<ID>, ID extends Serializable> void cacheBpmnRuntimeValidateSql(String rawSql, String validateSql) {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        List<String> validateSqlList = runtimeData.getValidateSqlMap().get(rawSql);
        if (validateSqlList == null) {
            validateSqlList = new ArrayList<String>();
            runtimeData.getValidateSqlMap().put(rawSql, validateSqlList);
        }
        if (!validateSqlList.contains(validateSql)) {
            validateSqlList.add(validateSql);
        }
    }

    public static <T extends Auditable<ID>, ID extends Serializable> Map<String, List<String>> getBpmnRuntimeValidateSql() {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        return runtimeData.getValidateSqlMap();
    }

    public static <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceNextTaskElementDTO<ID>> getNextTaskList() {
        BpmnRuntimeData<T, ID> runtimeData = BpmnRuntimeCacheProvider.getRuntimeData();
        List<CoreBpmnInstanceNextTaskElementDTO<ID>> nextTaskElementList = runtimeData.getNextTaskElementList();
        if (nextTaskElementList == null) {
            nextTaskElementList = new ArrayList<CoreBpmnInstanceNextTaskElementDTO<ID>>();
            List<CoreBpmnRuntimeSource<T, ID>> sourceList = BpmnRuntimeCacheProvider.getBpmnRuntimeSourceList();
            List draftSourceList = sourceList.stream().filter(s -> StringUtils.startsWithIgnoreCase(s.getOldItem().getProcessStatus(), ProcessStatus.DRAFT.name())).collect(Collectors.toList());
            List approveSourceList = sourceList.stream().filter(s -> StringUtils.startsWithIgnoreCase(s.getOldItem().getProcessStatus(), ProcessStatus.APPROVE.name())).collect(Collectors.toList());
            if (!draftSourceList.isEmpty()) {
                CoreBpmnProcService procService = ApplicationContextHelper.getBean(CoreBpmnProcService.class);
                CoreBpmnDiagramService diagramService = ApplicationContextHelper.getBean(CoreBpmnDiagramService.class);
                GenericAuditableService service = (GenericAuditableService)SinoBeanContext.getServiceByTable(((CoreBpmnRuntimeSource)draftSourceList.get(0)).getTableName());
                List pairList = service.getBpmnProcIdList(draftSourceList.stream().map(s -> s.getOldItem()).collect(Collectors.toList()));
                for (CoreBpmnRuntimeSource draftSource : draftSourceList) {
                    Long procId = (Long)pairList.stream().filter(p -> ((Serializable)p.getFirst()).equals(draftSource.getOldItem().getId())).findFirst().get().getSecond();
                    CoreBpmnProcBean proc = (CoreBpmnProcBean)procService.selectById(procId);
                    if (proc == null) {
                        throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_NOT_EXISTS");
                    }
                    Document diagram = diagramService.getDocument(proc.getDiagramId());
                    Element startElement = BpmnDiagramHelper.getProcessElement(diagram, ProcessElementType.START_EVENT);
                    CoreBpmnInstanceNextTaskElementDTO nextTaskElement = new CoreBpmnInstanceNextTaskElementDTO();
                    nextTaskElement.setId(draftSource.getId());
                    nextTaskElement.setSourceElement(startElement);
                    nextTaskElement.setNextTaskElementList(BpmnRuntimeCacheProvider.getNextTaskElementList(draftSource, startElement));
                    nextTaskElementList.add(nextTaskElement);
                }
            }
            if (!approveSourceList.isEmpty()) {
                for (CoreBpmnRuntimeSource approveSource : approveSourceList) {
                    Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(approveSource);
                    CoreBpmnInstanceNextTaskElementDTO nextTaskElement = new CoreBpmnInstanceNextTaskElementDTO();
                    nextTaskElement.setId(approveSource.getId());
                    nextTaskElement.setSourceElement(taskElement);
                    nextTaskElement.setNextTaskElementList(BpmnRuntimeCacheProvider.getNextTaskElementList(approveSource, taskElement));
                    nextTaskElementList.add(nextTaskElement);
                }
            }
            runtimeData.setNextTaskElementList(nextTaskElementList);
        }
        return nextTaskElementList;
    }

    public static <T extends Auditable<ID>, ID extends Serializable> CoreBpmnInstanceNextTaskElementDTO<ID> getNextTask(CoreBpmnRuntimeSource<T, ID> source) {
        List<CoreBpmnInstanceNextTaskElementDTO<ID>> nextTaskElementList = BpmnRuntimeCacheProvider.getNextTaskList();
        return nextTaskElementList.parallelStream().filter(t -> t.getId().equals(source.getId())).findAny().orElse(null);
    }

    public static <T extends Auditable<ID>, ID extends Serializable> boolean isLastTaskCandidator(CoreBpmnRuntimeSource<T, ID> source) {
        Element currentElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
        CounterSignStrategy counterSignStrategy = BpmnDiagramHelper.getCounterSignStrategy(currentElement);
        if (CounterSignStrategy.none.equals((Object)counterSignStrategy)) {
            return true;
        }
        List<CoreBpmnInstanceCandidatorDTO> instanceCandidatorList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceCandidatorList();
        CoreBpmnInstanceTaskBean instanceTask = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(source);
        List candidatorList = instanceCandidatorList.stream().filter(c -> c.getInstTaskId().equals(instanceTask.getId())).collect(Collectors.toList());
        if (candidatorList.isEmpty()) {
            throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.CANDIDATOR_AND_ROLE_NOT_EXISTS");
        }
        if (CounterSignStrategy.all.equals((Object)counterSignStrategy)) {
            return candidatorList.stream().allMatch(c -> LocalContextHelper.getLoginUserId().equals(c.getCandidatorId()));
        }
        return candidatorList.stream().filter(c -> c.getRoleId() != null).count() == candidatorList.stream().filter(c -> c.getRoleId() != null && LocalContextHelper.getLoginUserId().equals(c.getCandidatorId())).count();
    }

    private static <T extends Auditable<ID>, ID extends Serializable> boolean isStartTask(CoreBpmnRuntimeSource<T, ID> source) {
        return StringUtils.startsWithIgnoreCase(source.getOldItem().getProcessStatus(), ProcessStatus.DRAFT.name());
    }

    private static <T extends Auditable<ID>, ID extends Serializable> List<Element> getNextTaskElementList(CoreBpmnRuntimeSource<T, ID> source, Element currentTask) {
        List<Object> reachableTaskList;
        Document diagram = BpmnRuntimeCacheProvider.getBpmnRuntimeDocument(source);
        if (!StringUtils.isBlank(source.getNextStatusCode())) {
            return Arrays.asList(BpmnDiagramHelper.getProcessElementByStatusCode(diagram, source.getNextStatusCode()));
        }
        CounterSignStrategy counterSignStrategy = BpmnDiagramHelper.getCounterSignStrategy(currentTask);
        if (!CounterSignStrategy.none.equals((Object)counterSignStrategy)) {
            String createdByOrgId;
            List<CoreBpmnInstanceCandidatorDTO> instanceCandidatorList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceCandidatorList();
            CoreBpmnInstanceTaskBean instanceTask = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(source);
            if (!instanceTask.getTaskId().equals(XmlUtils.getAttributeValue(currentTask, "id"))) {
                return CollectionUtils.emptyList();
            }
            List<String> previousTaskAuditedByList = BpmnRuntimeCacheProvider.getBpmnPreviousTaskAuditedByList(source);
            List currentInstanceCandidatorList = instanceCandidatorList.stream().filter(c -> c.getInstTaskId().equals(instanceTask.getId()) && !previousTaskAuditedByList.contains(c.getCandidatorId())).collect(Collectors.toList());
            if (CandidatorFilterStrategy.sameDept.equals((Object)BpmnDiagramHelper.getCandidatorFilterStrategy(currentTask)) && !StringUtils.isBlank(createdByOrgId = (String)CollectionUtils.getValueIgnorecase(source.getVars(), "createdByOrgId"))) {
                CoreUserService userService = ApplicationContextHelper.getBean(CoreUserService.class);
                List<Object> finalReachableTaskList = reachableTaskList = userService.selectListByIds(currentInstanceCandidatorList.stream().map(c -> c.getCandidatorId()).collect(Collectors.toList()));
                currentInstanceCandidatorList.removeIf(c -> finalReachableTaskList.stream().filter(s -> s.getId().equals(c.getCandidatorId())).noneMatch(s -> createdByOrgId.equals(s.getOrgId())));
            }
            if (CounterSignStrategy.all.equals((Object)counterSignStrategy)) {
                if (currentInstanceCandidatorList.stream().anyMatch(c -> !c.getCandidatorId().equals(LocalContextHelper.getLoginUserId()))) {
                    return CollectionUtils.emptyList();
                }
            } else if (CounterSignStrategy.role.equals((Object)counterSignStrategy)) {
                List roleIdList = currentInstanceCandidatorList.stream().filter(c -> c.getTaskRoleId() != null && c.getCandidatorId().equals(LocalContextHelper.getLoginUserId())).map(c -> c.getRoleId()).distinct().collect(Collectors.toList());
                if (currentInstanceCandidatorList.stream().anyMatch(c -> c.getTaskRoleId() != null && !roleIdList.contains(c.getRoleId()))) {
                    return CollectionUtils.emptyList();
                }
            }
        }
        ArrayList<Element> resultList = new ArrayList<Element>();
        List<Element> outgoingSequenceFlowList = BpmnDiagramHelper.getOutgoingSequenceFlowList(diagram, currentTask);
        for (Element outgoingSequenceFlow : outgoingSequenceFlowList) {
            if (!CoreBpmnHelper.evalSequenceFlowConditionExpression(outgoingSequenceFlow, source.getVars())) continue;
            Element targetElement = BpmnDiagramHelper.getTargetElement(diagram, outgoingSequenceFlow);
            ProcessElementType targetElementType = BpmnDiagramHelper.getProcessElementType(targetElement);
            if (ProcessElementType.USER_TASK.equals((Object)targetElementType)) {
                resultList.add(targetElement);
                continue;
            }
            if (ProcessElementType.END_EVENT.equals((Object)targetElementType)) {
                resultList.add(targetElement);
                continue;
            }
            if (ProcessElementType.PARALLEL_GATEWAY.equals((Object)targetElementType)) {
                reachableTaskList = BpmnDiagramHelper.getIncomingSequenceFlowList(diagram, targetElement);
                if (reachableTaskList.size() == 1) {
                    resultList.addAll(BpmnRuntimeCacheProvider.getNextTaskElementList(source, targetElement));
                    continue;
                }
                CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
                List<CoreBpmnInstanceTaskBean> instanceTaskCacheList = BpmnRuntimeCacheProvider.getBpmnRuntimeUnlimitedInstanceTaskList();
                List instanceTaskList = instanceTaskCacheList.stream().filter(i -> i.getInstId().equals(instance.getId())).collect(Collectors.toList());
                if ((long)instanceTaskList.size() != 1L || !((CoreBpmnInstanceTaskBean)instanceTaskList.get(0)).getTaskId().equals(XmlUtils.getAttributeValue(currentTask, "id"))) continue;
                resultList.addAll(BpmnRuntimeCacheProvider.getNextTaskElementList(source, targetElement));
                continue;
            }
            if (!ProcessElementType.EXCLUSIVE_GATEWAY.equals((Object)targetElementType)) continue;
            reachableTaskList = BpmnRuntimeCacheProvider.getNextTaskElementList(source, targetElement);
            if (reachableTaskList.size() > 1) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.EXCLUSIVE_GATEWAY_OUTGOING_MULTIPLE_TASK");
            }
            resultList.addAll(reachableTaskList);
        }
        return resultList;
    }
}

