/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.diagram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnTaskCandidatorsDTO;
import net.sinodawn.module.sys.bpmn.diagram.ProcessElementType;
import net.sinodawn.module.sys.bpmn.diagram.SequenceElementType;
import net.sinodawn.module.sys.bpmn.diagram.TaskElementType;
import net.sinodawn.module.sys.bpmn.diagram.attribute.AttachmentStrategy;
import net.sinodawn.module.sys.bpmn.diagram.attribute.CandidatorFilterStrategy;
import net.sinodawn.module.sys.bpmn.diagram.attribute.CounterSignStrategy;
import net.sinodawn.module.sys.bpmn.diagram.attribute.NextCandidatorOptStrategy;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import org.dom4j.Document;
import org.dom4j.Element;

public abstract class BpmnDiagramHelper {
    public static final ProcessElementType getProcessElementType(Element processElement) {
        String name = processElement.getName();
        return ProcessElementType.nameOf(name);
    }

    public static final Element getProcessElement(Document diagram, String id) {
        Element element;
        if (StringUtils.isBlank(id)) {
            return null;
        }
        Element processElement = BpmnDiagramHelper.getProcessElement(diagram);
        List elementList = processElement.elements();
        Iterator var4 = elementList.iterator();
        do {
            if (var4.hasNext()) continue;
            return null;
        } while (!id.equals(XmlUtils.getAttributeValue(element = (Element)var4.next(), "id")));
        return element;
    }

    public static final Element getProcessElement(Document diagram, ProcessElementType type) {
        Element element = BpmnDiagramHelper.getProcessElement(diagram);
        return element.element(type.getName());
    }

    public static final Element getProcessElementByStatusCode(Document diagram, String statusCode) {
        Element element;
        Element processElement = BpmnDiagramHelper.getProcessElement(diagram);
        List elementList = processElement.elements();
        Iterator var4 = elementList.iterator();
        do {
            if (var4.hasNext()) continue;
            return null;
        } while (!statusCode.equals(BpmnDiagramHelper.getUserTaskStatusCode(element = (Element)var4.next())));
        return element;
    }

    public static final List<Element> getProcessElementList(Document diagram, ProcessElementType processElementType) {
        Element element = BpmnDiagramHelper.getProcessElement(diagram);
        return element.elements(processElementType.getName());
    }

    public static final List<Element> getOutgoingSequenceFlowList(Document diagram, Element taskElement) {
        List taskSubOutgoingElementList = taskElement.elements(TaskElementType.outgoing.name());
        return taskSubOutgoingElementList.stream().map(e -> BpmnDiagramHelper.getProcessElement(diagram, e.getStringValue())).collect(Collectors.toList());
    }

    public static final List<Element> getOutgoingSequenceFlowList(Document diagram, String taskId) {
        Element taskElement = BpmnDiagramHelper.getProcessElement(diagram, taskId);
        return BpmnDiagramHelper.getOutgoingSequenceFlowList(diagram, taskElement);
    }

    public static final List<String> getOutgoingSequenceFlowIdList(Document diagram, Element taskElement) {
        List taskSubOutgoingElementList = taskElement.elements(TaskElementType.outgoing.name());
        return taskSubOutgoingElementList.stream().map(e -> e.getStringValue()).collect(Collectors.toList());
    }

    public static final List<String> getOutgoingSequenceFlowIdList(Document diagram, String taskId) {
        Element taskElement = BpmnDiagramHelper.getProcessElement(diagram, taskId);
        return BpmnDiagramHelper.getOutgoingSequenceFlowIdList(diagram, taskElement);
    }

    public static final boolean isLastUserTask(Document diagram, Element userTaskElement) {
        List<Element> outgoingSequenceFlowList = BpmnDiagramHelper.getOutgoingSequenceFlowList(diagram, userTaskElement);
        if (outgoingSequenceFlowList.isEmpty()) {
            return true;
        }
        if (outgoingSequenceFlowList.size() > 1) {
            return false;
        }
        Element sequenceFlow = outgoingSequenceFlowList.get(0);
        Element targetElement = BpmnDiagramHelper.getTargetElement(diagram, sequenceFlow);
        ProcessElementType targetType = BpmnDiagramHelper.getProcessElementType(targetElement);
        return ProcessElementType.END_EVENT.equals((Object)targetType);
    }

    public static final List<Element> getIncomingSequenceFlowList(Document diagram, String taskId) {
        Element taskElement = BpmnDiagramHelper.getProcessElement(diagram, taskId);
        return BpmnDiagramHelper.getIncomingSequenceFlowList(diagram, taskElement);
    }

    public static final List<Element> getIncomingSequenceFlowList(Document diagram, Element taskElement) {
        List taskSubIncomingElementList = taskElement.elements(TaskElementType.incoming.name());
        return taskSubIncomingElementList.stream().map(e -> BpmnDiagramHelper.getProcessElement(diagram, e.getStringValue())).collect(Collectors.toList());
    }

    public static final List<String> getIncomingSequenceFlowIdList(Document diagram, Element taskElement) {
        List taskSubIncomingElementList = taskElement.elements(TaskElementType.incoming.name());
        return taskSubIncomingElementList.stream().map(e -> e.getStringValue()).collect(Collectors.toList());
    }

    public static final List<Element> getIncomingUserTaskElementList(Document diagram, Element taskElement) {
        ArrayList<Element> userTaskElementList = new ArrayList<Element>();
        List<Element> taskSubIncomingElementList = BpmnDiagramHelper.getIncomingSequenceFlowList(diagram, taskElement);
        Iterator<Element> var4 = taskSubIncomingElementList.iterator();
        while (var4.hasNext()) {
            Element sequenceFlow = var4.next();
            Element sourceElement = BpmnDiagramHelper.getSourceElement(diagram, sequenceFlow);
            if (sourceElement == null) continue;
            ProcessElementType sourceType = BpmnDiagramHelper.getProcessElementType(sourceElement);
            if (ProcessElementType.USER_TASK.equals((Object)sourceType) || ProcessElementType.START_EVENT.equals((Object)sourceType)) {
                userTaskElementList.add(sourceElement);
                continue;
            }
            if (!ProcessElementType.PARALLEL_GATEWAY.equals((Object)sourceType) && !ProcessElementType.EXCLUSIVE_GATEWAY.equals((Object)sourceType) && !ProcessElementType.SEQUENCE_FLOW.equals((Object)sourceType)) continue;
            userTaskElementList.addAll(BpmnDiagramHelper.getIncomingUserTaskElementList(diagram, sourceElement));
        }
        return userTaskElementList;
    }

    public static final List<String> getIncomingSequenceFlowIdList(Document diagram, String taskId) {
        Element taskElement = BpmnDiagramHelper.getProcessElement(diagram, taskId);
        return BpmnDiagramHelper.getIncomingSequenceFlowIdList(diagram, taskElement);
    }

    public static final Element getTargetElement(Document diagram, String sequenceFlowId) {
        Element element = BpmnDiagramHelper.getProcessElement(diagram, sequenceFlowId);
        return BpmnDiagramHelper.getTargetElement(diagram, element);
    }

    public static final Element getTargetElement(Document diagram, Element sequenceFlowElement) {
        String targetId = XmlUtils.getAttributeValue(sequenceFlowElement, "targetRef");
        return BpmnDiagramHelper.getProcessElement(diagram, targetId);
    }

    public static final Element getSourceElement(Document diagram, String sequenceFlowId) {
        Element element = BpmnDiagramHelper.getProcessElement(diagram, sequenceFlowId);
        return BpmnDiagramHelper.getSourceElement(diagram, element);
    }

    public static final Element getSourceElement(Document diagram, Element sequenceFlowElement) {
        String targetId = XmlUtils.getAttributeValue(sequenceFlowElement, "sourceRef");
        return BpmnDiagramHelper.getProcessElement(diagram, targetId);
    }

    public static final String getConditionExpression(Document diagram, String sequenceFlowId) {
        Element sequenceFlowElement = BpmnDiagramHelper.getProcessElement(diagram, sequenceFlowId);
        return BpmnDiagramHelper.getConditionExpression(sequenceFlowElement);
    }

    public static final String getConditionExpression(Element sequenceFlowElement) {
        Element conditionExpressionElement = sequenceFlowElement.element(SequenceElementType.conditionExpression.name());
        return conditionExpressionElement == null ? null : conditionExpressionElement.getStringValue();
    }

    public static final String getUserTaskInitiatorValue(Element userTask) {
        return XmlUtils.getAttributeValue(userTask, "initiator");
    }

    public static final String getUserTaskDynamicValue(Element userTask) {
        return XmlUtils.getAttributeValue(userTask, "dynamic");
    }

    public static final Map<String, String> getUserTaskCandidatorValue(Element userTask) {
        HashMap<String, String> map = new HashMap<String, String>();
        Element candidateUsersElement = userTask.element(TaskElementType.candidateUsersElements.name());
        if (candidateUsersElement != null) {
            Element propertiesElement = candidateUsersElement.element("properties");
            propertiesElement.elements("property").forEach(e -> {
                String var10000 = map.put(XmlUtils.getAttributeValue(e, "value"), XmlUtils.getAttributeValue(e, "name"));
            });
        }
        return map;
    }

    public static final Map<Long, String> getUserTaskRoleValue(Element userTask) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        Element candidateUsersElement = userTask.element(TaskElementType.candidateRolesElements.name());
        if (candidateUsersElement != null) {
            Element propertiesElement = candidateUsersElement.element("properties");
            propertiesElement.elements("property").forEach(e -> {
                String var10000 = map.put(NumberUtils.parseLong(XmlUtils.getAttributeValue(e, "value")), XmlUtils.getAttributeValue(e, "name"));
            });
        }
        return map;
    }

    public static final String getUserTaskStatusCode(Element userTask) {
        return XmlUtils.getAttributeValue(userTask, "statusCode");
    }

    public static final boolean isAuthRequiredUserTask(Element userTask) {
        return "true".equalsIgnoreCase(XmlUtils.getAttributeValue(userTask, "authRequired"));
    }

    public static final boolean isCommentRequiredTask(Element startEventOrUserTask) {
        return "true".equalsIgnoreCase(XmlUtils.getAttributeValue(startEventOrUserTask, "commentRequired"));
    }

    public static final boolean isFilterPreviousCandidatorsTask(Element userTask) {
        return "true".equalsIgnoreCase(XmlUtils.getAttributeValue(userTask, "filterPreviousCandidators"));
    }

    public static final boolean isTransferTask(Element userTask) {
        return "true".equalsIgnoreCase(XmlUtils.getAttributeValue(userTask, "transfer"));
    }

    public static final AttachmentStrategy getAttachmentStrategy(Element startEventOrUserTask) {
        String attachmentStrategy = XmlUtils.getAttributeValue(startEventOrUserTask, "attachmentStrategy");
        return StringUtils.isBlank(attachmentStrategy) ? AttachmentStrategy.none : AttachmentStrategy.valueOf(attachmentStrategy);
    }

    public static final CounterSignStrategy getCounterSignStrategy(Element userTask) {
        String counterSignStrategy = XmlUtils.getAttributeValue(userTask, "counterSignStrategy");
        return StringUtils.isBlank(counterSignStrategy) ? CounterSignStrategy.none : CounterSignStrategy.valueOf(counterSignStrategy);
    }

    public static final NextCandidatorOptStrategy getNextCandidatorOptStrategy(Element startEventOrUserTask) {
        String nextCandidatorOptStrategy = XmlUtils.getAttributeValue(startEventOrUserTask, "nextCandidatorOptStrategy");
        return StringUtils.isBlank(nextCandidatorOptStrategy) ? NextCandidatorOptStrategy.none : NextCandidatorOptStrategy.valueOf(nextCandidatorOptStrategy);
    }

    public static final CandidatorFilterStrategy getCandidatorFilterStrategy(Element userTask) {
        String candidatorFilterStrategy = XmlUtils.getAttributeValue(userTask, "candidatorFilterStrategy");
        return StringUtils.isBlank(candidatorFilterStrategy) ? CandidatorFilterStrategy.none : CandidatorFilterStrategy.valueOf(candidatorFilterStrategy);
    }

    public static final String getPassValidatorSql(Element startEventOrUserTask) {
        return XmlUtils.getAttributeValue(startEventOrUserTask, "passValidator");
    }

    public static final String getRejectValidatorSql(Element userTask) {
        return XmlUtils.getAttributeValue(userTask, "rejectValidator");
    }

    public static final String getPassCallback(Element startEventOrUserTask) {
        return XmlUtils.getAttributeValue(startEventOrUserTask, "passCallback");
    }

    public static final String getEndCallback(Element startEventOrUserTask) {
        return XmlUtils.getAttributeValue(startEventOrUserTask, "endCallback");
    }

    public static final String getRejectCallback(Element userTask) {
        return XmlUtils.getAttributeValue(userTask, "rejectCallback");
    }

    public static List<String> getPreviousStatusCodeList(Document document, Element element) {
        ArrayList<String> statusCodeList = new ArrayList<String>();
        BpmnDiagramHelper.pickPreviousStatusCodeList(statusCodeList, document, element);
        return statusCodeList.stream().distinct().collect(Collectors.toList());
    }

    public static final <T extends Auditable<ID>, ID extends Serializable> CoreBpmnTaskCandidatorsDTO getUserTaskCandidators(CoreBpmnRuntimeSource<T, ID> source, Element userTaskElement, String initiator) {
        Map<Long, String> userTaskRoleMap;
        Map<String, String> userTaskCandidatorMap;
        String dynamic;
        ArrayList<String> candidatorIdList = new ArrayList<String>();
        ArrayList<Long> candidateRoleIdList = new ArrayList<Long>();
        if (!StringUtils.isEmpty(BpmnDiagramHelper.getUserTaskInitiatorValue(userTaskElement))) {
            candidatorIdList.add(initiator);
        }
        if (!StringUtils.isEmpty(dynamic = BpmnDiagramHelper.getUserTaskDynamicValue(userTaskElement))) {
            String[] dynamicValues;
            String[] var7 = dynamicValues = StringUtils.split(dynamic, ",");
            int var8 = dynamicValues.length;
            for (int var9 = 0; var9 < var8; ++var9) {
                String role;
                String value = var7[var9];
                if (StringUtils.startsWith(value, "u:")) {
                    role = (String)source.getVars().get(StringUtils.removeStart(value, "u:"));
                    if (role == null) {
                        throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.DYNAMIC_USER_NOT_EXISTS");
                    }
                    candidatorIdList.add(role);
                    continue;
                }
                if (!StringUtils.startsWith(value, "r:")) continue;
                role = ObjectUtils.toString(source.getVars().get(StringUtils.removeStart(value, "r:")));
                if (StringUtils.isEmpty(role)) {
                    throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.DYNAMIC_ROLE_NOT_EXISTS");
                }
                candidateRoleIdList.add(NumberUtils.parseLong(role));
            }
        }
        if (!(userTaskCandidatorMap = BpmnDiagramHelper.getUserTaskCandidatorValue(userTaskElement)).isEmpty()) {
            candidatorIdList.addAll(userTaskCandidatorMap.keySet());
        }
        if (!(userTaskRoleMap = BpmnDiagramHelper.getUserTaskRoleValue(userTaskElement)).isEmpty()) {
            candidateRoleIdList.addAll(userTaskRoleMap.keySet());
        }
        CoreBpmnTaskCandidatorsDTO candidators = new CoreBpmnTaskCandidatorsDTO();
        candidators.setCandidatorIdList(candidatorIdList.stream().distinct().collect(Collectors.toList()));
        candidators.setCandidateRoleIdList(candidateRoleIdList.stream().distinct().collect(Collectors.toList()));
        return candidators;
    }

    private static final Element getProcessElement(Document diagram) {
        return diagram.getRootElement().element("process");
    }

    private static void pickPreviousStatusCodeList(List<String> pickedStatusCodeList, Document document, Element element) {
        List<Element> sequenceFlowList = BpmnDiagramHelper.getIncomingSequenceFlowList(document, element);
        Iterator<Element> var4 = sequenceFlowList.iterator();
        while (var4.hasNext()) {
            Element sequenceFlowElement = var4.next();
            Element source = BpmnDiagramHelper.getSourceElement(document, sequenceFlowElement);
            ProcessElementType type = BpmnDiagramHelper.getProcessElementType(source);
            if (ProcessElementType.USER_TASK.equals((Object)type) || ProcessElementType.START_EVENT.equals((Object)type)) {
                String statusCode = BpmnDiagramHelper.getUserTaskStatusCode(source);
                if (pickedStatusCodeList.contains(statusCode)) continue;
                pickedStatusCodeList.add(BpmnDiagramHelper.getUserTaskStatusCode(source));
            }
            if (ProcessElementType.START_EVENT.equals((Object)type)) continue;
            BpmnDiagramHelper.pickPreviousStatusCodeList(pickedStatusCodeList, document, source);
        }
        return;
    }
}

