/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.ScriptUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Element;

public class CoreBpmnHelper {
    private static final Logger logger = LogManager.getLogger(CoreBpmnHelper.class);

    public static final <ID> String getTargetId(String table, ID id) {
        return table + "$" + ObjectUtils.toString(id);
    }

    public static final String getCorrectedDiagram(String diagram) {
        return StringUtils.replace(diagram, "camunda:=\"\"", "");
    }

    public static boolean evalSequenceFlowConditionExpression(Element sequenceFlowElement, Map<String, Object> vars) {
        String expression = BpmnDiagramHelper.getConditionExpression(sequenceFlowElement);
        return CoreBpmnHelper.evalExpression(expression, vars);
    }

    public static boolean evalExpression(String expression, Map<String, Object> vars) {
        if (StringUtils.isEmpty(expression)) {
            return true;
        }
        String copyExpression = expression;
        List<String> substringList = StringUtils.substringsBetween(expression, "${", "}");
        Iterator<String> var4 = substringList.iterator();
        while (true) {
            if (var4.hasNext()) {
                Object value;
                String substring = var4.next();
                if (!CollectionUtils.containsKeyIgnorecase(vars, substring)) {
                    // empty if block
                }
                if ((value = CollectionUtils.getValueIgnorecase(vars, substring)) != null && Number.class.isAssignableFrom(value.getClass())) {
                    copyExpression = StringUtils.replace(copyExpression, "${" + substring + "}", ObjectUtils.toString(value));
                    continue;
                }
                copyExpression = StringUtils.replace(copyExpression, "${" + substring + "}", "'" + ObjectUtils.toString(value) + "'");
                continue;
            }
            try {
                return (Boolean)ScriptUtils.evalJavaScript(copyExpression);
            }
            catch (Exception var7) {
                logger.error((Object)var7);
                continue;
            }
            break;
        }
    }
}

