/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.at.service.impl;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordDTO;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import net.sinodawn.module.sys.at.dao.CoreAuditTrailRecordDao;
import net.sinodawn.module.sys.at.service.CoreAuditTrailRecordLineService;
import net.sinodawn.module.sys.at.service.CoreAuditTrailRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreAuditTrailRecordServiceImpl
implements CoreAuditTrailRecordService {
    @Autowired
    private CoreAuditTrailRecordDao recordDao;
    @Autowired
    private CoreAuditTrailRecordLineService recordLineService;

    @Override
    public CoreAuditTrailRecordDao getDao() {
        return this.recordDao;
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public Long insert(CoreAuditTrailRecordBean record) {
        record.setId(ApplicationContextHelper.getNextIdentity());
        this.getDao().insert(record);
        return record.getId();
    }

    @Override
    public List<CoreAuditTrailRecordDTO> selectRecordList(String tableName, String id) {
        SearchFilter recordLineFilter = SearchFilter.instance().match("TARGETID", tableName + "$" + id).filter(MatchPattern.EQ);
        List recordLineList = this.recordLineService.selectListByFilter(recordLineFilter, new Order[0]);
        List recordIdList = recordLineList.stream().map(CoreAuditTrailRecordLineBean::getRecordId).distinct().collect(Collectors.toList());
        List recordList = this.getDao().selectListByIds(recordIdList, Order.desc("ID"));
        return recordList.stream().map(r -> new CoreAuditTrailRecordDTO((CoreAuditTrailRecordBean)r, recordLineList.stream().filter(l -> l.getRecordId().equals(r.getId())).sorted(Comparator.comparing(CoreAuditTrailRecordLineBean::getId)).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    @Override
    public List<CoreAuditTrailRecordBean> selectAtRecordList(String tableName, String id) {
        String targetId = tableName + "$" + id;
        List<CoreAuditTrailRecordBean> recordList = this.getDao().selectListByOneColumnValue(targetId, "TARGETID", Order.desc("ID"));
        return recordList.isEmpty() ? null : recordList;
    }

    @Override
    public List<CoreAuditTrailRecordBean> selectAtRecordList(String tableName, RestJsonWrapperBean wrapper) {
        String recordId = wrapper.getFilterValue("recordId");
        SearchFilter recordFilter = SearchFilter.instance();
        recordFilter = StringUtils.isEmpty(recordId) ? recordFilter.match("TARGETID", tableName + "$").filter(MatchPattern.SB) : recordFilter.match("TARGETID", tableName + "$" + recordId).filter(MatchPattern.EQ);
        List<CoreAuditTrailRecordBean> recordList = this.selectListByFilter(recordFilter, wrapper);
        return recordList.isEmpty() ? null : recordList;
    }

    @Override
    public List<CoreAuditTrailRecordLineBean> selectRecordLineTableNameList(Long recordId) {
        return this.recordLineService.selectRecordLineTableNameList(recordId);
    }

    @Override
    public List<CoreAuditTrailRecordLineBean> selectRecordLineList(Long recordId, String tableName) {
        return this.recordLineService.selectRecordLineList(recordId, tableName);
    }

    @Override
    public Page<CoreAuditTrailRecordLineBean> selectRecordLinePaginationList(RestJsonWrapperBean wrapper) {
        return this.recordLineService.selectPagination(wrapper);
    }

    @Override
    public CoreAuditTrailRecordLineBean selectRecordLineDetail(Long id) {
        return (CoreAuditTrailRecordLineBean)this.recordLineService.selectByIdIfPresent(id);
    }
}

