/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.at.service.impl;

import java.util.ArrayList;
import java.util.List;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import net.sinodawn.module.sys.at.dao.CoreAuditTrailRecordLineDao;
import net.sinodawn.module.sys.at.service.CoreAuditTrailRecordLineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreAuditTrailRecordLineServiceImpl
implements CoreAuditTrailRecordLineService {
    @Autowired
    private CoreAuditTrailRecordLineDao recordLineDao;

    @Override
    public CoreAuditTrailRecordLineDao getDao() {
        return this.recordLineDao;
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public void insert(List<CoreAuditTrailRecordLineBean> lineList) {
        int qty = lineList.size();
        List<Long> idList = ApplicationContextHelper.getNextIdentityList(qty);
        for (int i = 0; i < qty; ++i) {
            lineList.get(i).setId(idList.get(i));
        }
        this.getDao().insert(lineList);
    }

    @Override
    public List<CoreAuditTrailRecordLineBean> selectRecordLineTableNameList(Long recordId) {
        List<String> tableNameList = this.getDao().selectTableNameByRecordId("" + recordId);
        if (tableNameList.isEmpty()) {
            return null;
        }
        ArrayList<CoreAuditTrailRecordLineBean> recordLineList = new ArrayList<CoreAuditTrailRecordLineBean>();
        tableNameList.forEach(e -> {
            CoreAuditTrailRecordLineBean recordLine = new CoreAuditTrailRecordLineBean();
            recordLine.setTableName((String)e);
            recordLine.setRecordId(NumberUtils.parseLong(recordId));
            recordLineList.add(recordLine);
        });
        return recordLineList;
    }

    @Override
    public List<CoreAuditTrailRecordLineBean> selectRecordLineList(Long recordId, String tableName) {
        CoreAuditTrailRecordLineBean recordLine = new CoreAuditTrailRecordLineBean();
        recordLine.setRecordId(recordId);
        recordLine.setTableName(tableName);
        List<CoreAuditTrailRecordLineBean> lineList = this.getDao().selectList(recordLine, Order.asc("TARGETID"));
        return lineList.isEmpty() ? null : lineList;
    }
}

