/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.at.service.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.database.context.ColumnContext;
import net.sinodawn.framework.database.core.DatabaseManager;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.support.tree.TreeDescriptor;
import net.sinodawn.framework.support.tree.TreeHelper;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigLineBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigTreeDTO;
import net.sinodawn.module.sys.at.dao.CoreAuditTrailConfigDao;
import net.sinodawn.module.sys.at.service.CoreAuditTrailConfigLineService;
import net.sinodawn.module.sys.at.service.CoreAuditTrailConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreAuditTrailConfigServiceImpl
implements CoreAuditTrailConfigService {
    @Autowired
    private CoreAuditTrailConfigDao configDao;
    @Autowired
    private CoreAuditTrailConfigLineService configLineService;
    @Autowired
    @Lazy
    private CoreAuditTrailConfigService proxyInstance;

    @Override
    public CoreAuditTrailConfigDao getDao() {
        return this.configDao;
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public void insert(String table) {
        CoreAuditTrailConfigBean config = new CoreAuditTrailConfigBean();
        config.setId(table);
        config.setAuditTrail("0");
        this.getDao().insert(config);
        List<ColumnContext> columnList = DatabaseManager.getTableColumnContextList(table);
        this.configLineService.getDao().insert(columnList.stream().map(c -> {
            CoreAuditTrailConfigLineBean configLine = new CoreAuditTrailConfigLineBean();
            configLine.setId(ApplicationContextHelper.getNextIdentity());
            configLine.setConfigId(table);
            configLine.setColumnId(c.getColumnName());
            configLine.setAuditTrail("1");
            return configLine;
        }).collect(Collectors.toList()));
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.UPDATE)
    @Audit(value="AUDIT.SAVE")
    public void save(String id, RestJsonWrapperBean wrapper) {
        CoreAuditTrailConfigService.super.save(id, wrapper);
    }

    @Override
    public CoreAuditTrailConfigBean selectByIdIfPresent(String table) {
        CoreAuditTrailConfigBean config = (CoreAuditTrailConfigBean)this.getDao().selectByIdIfPresent(table);
        if (config == null) {
            config = new CoreAuditTrailConfigBean();
            config.setId(table);
            config.setAuditTrail("0");
        }
        return config;
    }

    @Override
    public CoreAuditTrailConfigBean selectDetail(String table) {
        Map<String, Object> map = this.getDao().selectDetail(table);
        if (map == null || map.isEmpty()) {
            this.proxyInstance.insert(table);
            map = this.getDao().selectDetail(table);
        }
        return (CoreAuditTrailConfigBean)PersistableHelper.mapToPersistable(map, this.getDao().getType());
    }

    @Override
    public Page<CoreAuditTrailConfigTreeDTO> selectAuditTrailableTreePagination(RestJsonWrapperBean wrapper) {
        List<CoreAuditTrailConfigBean> configList = this.getDao().selectAuditTrailableByCondition(wrapper.extractMapFilter());
        TreeDescriptor<CoreAuditTrailConfigBean> descriptor = new TreeDescriptor<CoreAuditTrailConfigBean>("id");
        descriptor.setParseTreeNodeParentIdFunc(t -> t.getExt$().get("parentid"));
        descriptor.setParseTreeNodeTextFunction(t -> t.getId() + ".SERVICE_NAME");
        descriptor.setOrderComparator((u1, u2) -> u1.getId().compareTo(u2.getId()));
        descriptor.addConsumer((t, n) -> n.setExpanded(true));
        List<CoreAuditTrailConfigTreeDTO> treeNodeList = TreeHelper.parseTreeNode(configList, descriptor, CoreAuditTrailConfigTreeDTO.class);
        treeNodeList.forEach(n -> n.setHref("/core/module/sys/at-configs/audit-trailable/tree-grid"));
        return new Pagination<CoreAuditTrailConfigTreeDTO>(treeNodeList);
    }

    @Override
    public Page<CoreAuditTrailConfigLineBean> selectAuditTrailConfigLineListByConfig(String id, RestJsonWrapperBean wrapper) {
        this.revisingAuditTrailConfigLine(id);
        return new Pagination<CoreAuditTrailConfigLineBean>(this.configLineService.selectListByFilter(SearchFilter.instance().match("CONFIGID", id).filter(MatchPattern.EQ), wrapper));
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.ACTIVATE)
    @Audit(value="AUDIT.ACTIVATE")
    public void auditConfigLines(String id, RestJsonWrapperBean wrapper) {
        this.processConfigLines(wrapper, true);
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.DEACTIVATE)
    @Audit(value="AUDIT.DEACTIVATE")
    public void cancelConfigLines(String id, RestJsonWrapperBean wrapper) {
        this.processConfigLines(wrapper, false);
    }

    @Override
    public List<CoreAuditTrailConfigLineBean> selectAuditTrailableLineList(String table) {
        return this.configLineService.selectListByFilter(SearchFilter.instance().match("CONFIGID", table).filter(MatchPattern.EQ).match("AUDITTRAIL", "1").filter(MatchPattern.EQ), new Order[0]);
    }

    @Override
    @Transactional
    public void revisingAuditTrailConfigLine(String id) {
        CoreAuditTrailConfigLineBean filter = new CoreAuditTrailConfigLineBean();
        filter.setConfigId(id);
        List<String> selectedColumnList = this.configLineService.getDao().selectColumnList((CoreAuditTrailConfigLineBean)filter, "COLUMNID", String.class, new Order[0]);
        List columnList = DatabaseManager.getTableColumnContextList(id).stream().map(c -> c.getColumnName()).collect(Collectors.toList());
        List deleteList = selectedColumnList.stream().filter(c -> !CollectionUtils.containsIgnoreCase(columnList, c)).map(c -> {
            CoreAuditTrailConfigLineBean configLine = new CoreAuditTrailConfigLineBean();
            configLine.setColumnId((String)c);
            return configLine;
        }).collect(Collectors.toList());
        this.configLineService.getDao().deleteBy(deleteList, new String[]{"COLUMNID"});
        List insertList = columnList.stream().filter(c -> !CollectionUtils.containsIgnoreCase(selectedColumnList, c)).map(c -> {
            CoreAuditTrailConfigLineBean configLine = new CoreAuditTrailConfigLineBean();
            configLine.setId(ApplicationContextHelper.getNextIdentity());
            configLine.setConfigId(id);
            configLine.setColumnId((String)c);
            configLine.setAuditTrail("1");
            return configLine;
        }).collect(Collectors.toList());
        this.configLineService.getDao().insert(insertList);
    }

    @Override
    public boolean auditTrailable(String table) {
        CoreAuditTrailConfigBean config = this.selectByIdIfPresent(table);
        return config != null && "1".equals(config.getAuditTrail());
    }

    private void processConfigLines(RestJsonWrapperBean wrapper, boolean audit) {
        List<CoreAuditTrailConfigLineBean> itemList = wrapper.parse(CoreAuditTrailConfigLineBean.class);
        if (!itemList.isEmpty()) {
            List proxyItemList = itemList.stream().map(i -> {
                CoreAuditTrailConfigLineBean proxy = BeanUtils.getPropertyListenerProxy(CoreAuditTrailConfigLineBean.class);
                proxy.setId(i.getId());
                proxy.setAuditTrail(audit ? "1" : "0");
                return proxy;
            }).collect(Collectors.toList());
            this.configLineService.getDao().update(proxyItemList, (String[])new String[0]);
        }
    }
}

