/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.mdm.user.service.impl;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.context.SinoAopContext;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.mybatis.page.MybatisPageHelper;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.security.authentication.AuthenticationHelper;
import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.security.sso.SsoAuthenticator;
import net.sinodawn.framework.security.sso.SsoAuthenticatorRegistry;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.module.mdm.user.bean.CoreUserPermissionBean;
import net.sinodawn.module.mdm.user.dao.CoreUserPermissionDao;
import net.sinodawn.module.mdm.user.service.CoreUserPermissionService;
import net.sinodawn.module.sys.role.service.CoreRoleUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreUserPermissionServiceImpl
implements CoreUserPermissionService {
    @Autowired
    private CoreUserPermissionDao permissionDao;
    @Autowired
    @Lazy
    private AuthenticationProvider authenticationProvider;
    @Autowired
    private CoreRoleUserService coreRoleUserService;

    @Override
    public CoreUserPermissionDao getDao() {
        return this.permissionDao;
    }

    @Override
    @Transactional
    public Long insert(RestJsonWrapperBean wrapper) {
        List<CoreUserPermissionBean> userPermissionList = wrapper.parse(CoreUserPermissionBean.class);
        if (userPermissionList.isEmpty()) {
            return null;
        }
        userPermissionList.forEach(e -> e.setId(ApplicationContextHelper.getNextIdentity()));
        this.getDao().insert(userPermissionList);
        return userPermissionList.get(0).getId();
    }

    @Override
    @Transactional
    public void insert(String userId, String permissionTypeId, RestJsonWrapperBean wrapper) {
        List<CoreUserPermissionBean> userPermissionList = wrapper.parse(CoreUserPermissionBean.class);
        userPermissionList.forEach(e -> {
            e.setId(ApplicationContextHelper.getNextIdentity());
            e.setUserId(userId);
            e.setPermissionTypeId(permissionTypeId);
        });
        this.getDao().insert(userPermissionList);
    }

    @Override
    public Page<CoreUserPermissionBean> selectPaginationByPermissionType(String permissionTypeId, RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        Page page = MybatisPageHelper.get(rowBounds, () -> {
            int var4 = -1;
            switch (permissionTypeId.hashCode()) {
                case 1079996847: {
                    if (!permissionTypeId.equals("T_CORE_ORG")) break;
                    var4 = 0;
                }
            }
            switch (var4) {
                case 0: {
                    return this.getDao().selectOrgPermision(parameter);
                }
            }
            return this.getDao().selectByCondition(parameter);
        });
        if (page.getRows().isEmpty()) {
            return new Pagination<CoreUserPermissionBean>(page, CollectionUtils.emptyList());
        }
        List itemList = page.getRows().stream().map(m -> (CoreUserPermissionBean)PersistableHelper.mapToPersistable(m, this.getDao().getType())).collect(Collectors.toList());
        return new Pagination<CoreUserPermissionBean>(page, itemList);
    }

    @Override
    public List<CoreUserPermissionBean> selectLoginPermissionList(RestJsonWrapperBean wrapper, String permissionTypeId) {
        String userId = null;
        if (LocalContextHelper.isUserLogin()) {
            userId = LocalContextHelper.getLoginUserId();
        } else {
            SinoAopContext.putCache("username", Objects.requireNonNull(wrapper.getParamValue("username")));
            SinoAopContext.putCache("password", AuthenticationHelper.getRawPassword(Objects.requireNonNull(wrapper.getParamValue("password"))));
            SsoAuthenticator authenticator = SsoAuthenticatorRegistry.INSTANCE.getAuthenticator("testLogin");
            if (authenticator == null) {
                return CollectionUtils.emptyList();
            }
            LoginUser loginUser = authenticator.authenticate();
            if (loginUser == null) {
                return CollectionUtils.emptyList();
            }
            userId = loginUser.getUsername();
        }
        MapperParameter parameter = new MapperParameter();
        parameter.put("user_assigned", userId);
        int var6 = -1;
        switch (permissionTypeId.hashCode()) {
            case -879749397: {
                if (!permissionTypeId.equals("T_CORE_ROLE")) break;
                var6 = 1;
                break;
            }
            case 1079996847: {
                if (!permissionTypeId.equals("T_CORE_ORG")) break;
                var6 = 0;
            }
        }
        switch (var6) {
            case 0: {
                return this.getDao().selectOrgPermision(parameter).stream().map(m -> (CoreUserPermissionBean)PersistableHelper.mapToPersistable(m, this.getDao().getType())).collect(Collectors.toList());
            }
            case 1: {
                return this.coreRoleUserService.selectListByFilter(SearchFilter.instance().match("USERID", userId).filter(MatchPattern.EQ), new Order[0]).stream().map(e -> {
                    CoreUserPermissionBean userPermission = new CoreUserPermissionBean();
                    userPermission.setTargetId(e.getRoleId().toString());
                    userPermission.setExt$Item("rolename", e.getExt$().get("rolename"));
                    userPermission.setDefaultFlag(e.getDefaultFlag());
                    return userPermission;
                }).collect(Collectors.toList());
            }
        }
        return CollectionUtils.emptyList();
    }
}

