/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.mdm.org.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.module.mdm.org.bean.CoreOrgUserBean;
import net.sinodawn.module.mdm.org.dao.CoreOrgUserDao;
import net.sinodawn.module.mdm.org.service.CoreOrgUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreOrgUserServiceImpl
implements CoreOrgUserService {
    @Autowired
    private CoreOrgUserDao coreOrgUserDao;

    @Override
    public CoreOrgUserDao getDao() {
        return this.coreOrgUserDao;
    }

    @Override
    public Page<CoreOrgUserBean> selectPaginationByOrg(String orgId, RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper == null ? new MapperParameter() : wrapper.extractMapFilter();
        parameter.setFilter(SearchFilter.instance().match("ORGID", orgId).filter(MatchPattern.EQ));
        PageRowBounds rowBounds = wrapper == null ? null : wrapper.extractPageRowBounds();
        return this.selectPagination(parameter, rowBounds);
    }

    @Override
    @Transactional
    public void insertByUserId(String userId, List<CoreOrgUserBean> orgUserList) {
        orgUserList.forEach(u -> {
            u.setId(ApplicationContextHelper.getNextIdentity());
            u.setUserId(userId);
        });
        this.getDao().insert(orgUserList);
    }

    @Override
    @Transactional
    public void deleteByUserId(String userId, String ... orgIds) {
        CoreOrgUserBean filter = new CoreOrgUserBean();
        filter.setUserId(userId);
        if (!ArrayUtils.hasElement(orgIds)) {
            this.getDao().deleteBy(filter, "USERID");
        } else {
            List<CoreOrgUserBean> orgUserList = this.getDao().selectList(filter, new Order[0]);
            this.getDao().deleteByIdList(orgUserList.stream().filter(r -> Arrays.stream(orgIds).anyMatch(i -> i.equals(r.getOrgId()))).map(CoreOrgUserBean::getId).collect(Collectors.toList()));
        }
    }
}

