/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.mdm.org.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.page.MybatisPageHelper;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.support.tree.TreeDescriptor;
import net.sinodawn.framework.support.tree.TreeHelper;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.module.mdm.org.bean.CoreOrgBean;
import net.sinodawn.module.mdm.org.bean.CoreOrgDTO;
import net.sinodawn.module.mdm.org.bean.CoreOrgUserBean;
import net.sinodawn.module.mdm.org.dao.CoreOrgDao;
import net.sinodawn.module.mdm.org.service.CoreOrgService;
import net.sinodawn.module.mdm.org.service.CoreOrgUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreOrgServiceImpl
implements CoreOrgService {
    @Autowired
    private CoreOrgDao orgDao;
    @Autowired
    @Lazy
    private CoreOrgUserService orgUserService;
    @Autowired
    @Lazy
    private CoreOrgService proxyInstance;

    @Override
    public CoreOrgDao getDao() {
        return this.orgDao;
    }

    @Override
    @Cacheable(value={"T_CORE_ORG"}, key="'ALL'")
    public List<CoreOrgBean> selectAll() {
        return this.getDao().selectAll();
    }

    @Override
    @Transactional
    public String insert(RestJsonWrapperBean wrapper) {
        CoreOrgBean coreOrg = wrapper.parseUnique(CoreOrgBean.class);
        coreOrg.setOrderNo(ApplicationContextHelper.getNextOrderNo());
        this.getDao().insert(coreOrg);
        return coreOrg.getId();
    }

    @Override
    @Transactional
    public void insertUser(String id, RestJsonWrapperBean wrapper) {
        List<CoreOrgUserBean> orgUserList = wrapper.parse(CoreOrgUserBean.class);
        List<Long> idList = ApplicationContextHelper.getNextIdentityList(orgUserList.size());
        for (int index = 0; index < idList.size(); ++index) {
            orgUserList.get(index).setId(idList.get(index));
        }
        this.orgUserService.getDao().insert(orgUserList);
    }

    @Override
    @Transactional
    public void deleteUser(String id, RestJsonWrapperBean wrapper) {
        this.orgUserService.delete(wrapper);
    }

    public List<CoreOrgDTO> selectTree(MapperParameter parameter) {
        List<CoreOrgBean> orgList = this.getDao().selectTreeNodeList(parameter);
        TreeDescriptor<CoreOrgBean> descriptor = new TreeDescriptor<CoreOrgBean>("id", "parentId", "orgName", "orderNo");
        descriptor.setParseTreeNodeParentIdFunc(t -> {
            String id = t.getId();
            return id.length() > 2 ? id.substring(0, id.length() - 2) : null;
        });
        return TreeHelper.parseTreeNode(orgList, descriptor, CoreOrgDTO.class);
    }

    public Page<CoreOrgBean> selectChoosablePagination(RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        parameter.setOrgAuthority();
        parameter.setChoosableQueries();
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        return this.selectPagination(parameter, rowBounds);
    }

    @Override
    public Page<CoreOrgBean> selectRoleOrgList(Long roleId, RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        parameter.put("roleId", roleId);
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        Page mapPage = MybatisPageHelper.get(rowBounds, () -> this.getDao().selectRoleOrgList(parameter));
        List itemList = mapPage.getRows().stream().map(m -> PersistableHelper.mapToPersistable(m, CoreOrgBean.class)).collect(Collectors.toList());
        return new Pagination<CoreOrgBean>(mapPage, itemList);
    }

    @Override
    public void insertOrgUser(String orgId, RestJsonWrapperBean wrapper) {
        CoreOrgBean org = (CoreOrgBean)this.getDao().selectById(orgId);
        List<CoreOrgUserBean> orgUserList = wrapper.parse(CoreOrgUserBean.class);
        List<Long> idList = ApplicationContextHelper.getNextIdentityList(orgUserList.size());
        for (int i = 0; i < idList.size(); ++i) {
            CoreOrgUserBean orgUser = orgUserList.get(i);
            orgUser.setId(idList.get(i));
            orgUser.setOrgId(orgId);
            orgUser.setOrgName(org.getOrgName());
        }
        this.orgUserService.getDao().insert(orgUserList);
    }

    @Override
    public List<CoreOrgBean> selectChildOrgList(String orgId) {
        List<CoreOrgBean> allOrgList = this.proxyInstance.selectAll();
        CoreOrgBean org = allOrgList.stream().filter(o -> o.getId().equals(orgId)).findFirst().orElse(null);
        return org == null ? CollectionUtils.emptyList() : this.selectChildOrgList(allOrgList, org);
    }

    @Override
    public List<CoreOrgBean> selectParentOrgList(String orgId) {
        List<CoreOrgBean> allOrgList = this.proxyInstance.selectAll();
        CoreOrgBean org = allOrgList.stream().filter(o -> o.getId().equals(orgId)).findFirst().orElse(null);
        return org == null ? CollectionUtils.emptyList() : this.selectParentOrgList(allOrgList, org);
    }

    private List<CoreOrgBean> selectChildOrgList(List<CoreOrgBean> allList, CoreOrgBean currOrg) {
        ArrayList<CoreOrgBean> childOrgList = new ArrayList<CoreOrgBean>();
        for (CoreOrgBean org : allList) {
            if (!ObjectUtils.equals(org.getParentId(), currOrg.getId())) continue;
            childOrgList.add(org);
            childOrgList.addAll(this.selectChildOrgList(allList, org));
        }
        return childOrgList;
    }

    private List<CoreOrgBean> selectParentOrgList(List<CoreOrgBean> allList, CoreOrgBean currOrg) {
        ArrayList<CoreOrgBean> parentOrgList = new ArrayList<CoreOrgBean>();
        for (CoreOrgBean org : allList) {
            if (!ObjectUtils.equals(org.getId(), currOrg.getParentId())) continue;
            parentOrgList.add(org);
            parentOrgList.addAll(this.selectParentOrgList(allList, org));
        }
        return parentOrgList;
    }
}

