/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.mdm.login.service.impl;

import java.time.LocalDateTime;
import java.util.List;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.security.authentication.AuthenticationHelper;
import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.security.service.DefaultUserDetailsChecker;
import net.sinodawn.framework.utils.DateTimeUtils;
import net.sinodawn.framework.utils.EncryptUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.login.service.CoreLoginService;
import net.sinodawn.module.mdm.org.bean.CoreOrgBean;
import net.sinodawn.module.mdm.org.service.CoreOrgService;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import net.sinodawn.module.sys.log.bean.CoreLoginLogBean;
import net.sinodawn.module.sys.log.service.CoreLoginLogService;
import net.sinodawn.module.sys.password.bean.CorePasswordPolicyBean;
import net.sinodawn.module.sys.password.service.CorePasswordPolicyService;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Repository;

@Repository
public class CoreLoginServiceImpl
implements CoreLoginService {
    @Autowired
    private CoreUserService userService;
    @Autowired
    private CoreRoleService roleService;
    @Autowired
    private CoreOrgService orgService;
    @Autowired
    private CoreLoginLogService loginLogService;
    @Autowired
    private CorePasswordPolicyService passwordPolicyService;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @Override
    public CoreUserBean getAccount(String userId) {
        CoreLoginLogBean loginLog;
        if (userId == null) {
            return null;
        }
        CoreUserBean user = (CoreUserBean)this.userService.selectById(userId);
        if (!StringUtils.isEmpty(LocalContextHelper.getLoginOrgId())) {
            user.setExt$Item("loginOrgId", LocalContextHelper.getLoginOrgId());
            user.setExt$Item("loginOrgName", LocalContextHelper.getLoginOrgName());
        }
        if (LocalContextHelper.getLoginRoleId() != null) {
            user.setExt$Item("loginRoleId", "" + LocalContextHelper.getLoginRoleId());
            user.setExt$Item("loginRoleName", LocalContextHelper.getLoginRoleName());
        }
        if (EncryptUtils.MD5Encrypt(user.getId()).equals(user.getPassword())) {
            user.setExt$Item("passwordValidation", "core.validator.user.passwordsamewithname");
        }
        if ((loginLog = this.loginLogService.getCurrentLoginLog(userId)) != null) {
            user.setExt$Item("loginTime", DateTimeUtils.formatLocalDateTime(loginLog.getLoginTime()));
        } else {
            user.setExt$Item("loginTime", DateTimeUtils.formatLocalDateTime(LocalDateTime.now()));
        }
        user.setExt$Item("loginToken", AuthenticationHelper.getLoginUserToken());
        String defaultPassword = this.userService.defaultPassword() ? "1" : "0";
        String modifyDefaultPassword = ApplicationContextHelper.getConstantValue("INIT-PASSWORD-MODIFY");
        if ("1".equals(defaultPassword) && "1".equals(modifyDefaultPassword)) {
            user.setExt$Item("defaultPassword", defaultPassword);
        } else {
            List<CorePasswordPolicyBean> passwordPolicyList = this.passwordPolicyService.selectEffectedList(userId);
            Long passwordExpireRemainingDays = this.passwordPolicyService.selectPasswordExpireRemainingDays(passwordPolicyList);
            if (user.getExpiredPasswordUses() != null && user.getExpiredPasswordUses() > 0) {
                Long passwordExpiredMaxUse = this.passwordPolicyService.selectPasswordExpiredMaxUse(passwordPolicyList);
                user.setExt$Item("expiredPasswordRemainingUses", passwordExpiredMaxUse == null ? null : "" + (passwordExpiredMaxUse - (long)user.getExpiredPasswordUses().intValue()));
            } else {
                user.setExt$Item("passwordExpireRemainingDays", passwordExpireRemainingDays == null ? null : "" + passwordExpireRemainingDays);
            }
        }
        user.setExt$Item("avatarUrl", this.userService.selectAvatarUrl(userId));
        user.setExt$Item("signatureUrl", this.userService.selectSignatureUrl(userId));
        return user;
    }

    @Override
    public boolean checkAccount(RestJsonWrapperBean wrapper) {
        String username = wrapper.getParamValue("username");
        String rawPassword = wrapper.getParamValue("password");
        try {
            rawPassword = AuthenticationHelper.getRawPassword(rawPassword);
            DefaultUserDetailsChecker.checkPassword(username, rawPassword);
            return true;
        }
        catch (AuthenticationException var5) {
            DefaultUserDetailsChecker.postAuthenticationFailure(username);
            return false;
        }
    }

    @Override
    public void updateLoginInfo(String orgId, @Nullable Long roleId) {
        Authentication authentication;
        String token = AuthenticationHelper.getLoginUserToken();
        if (!StringUtils.isEmpty(token) && (authentication = AuthenticationHelper.getCacheAuthentication(token)) != null) {
            LoginUser loginUser = (LoginUser)((Object)authentication.getPrincipal());
            loginUser.setOrgId(orgId);
            loginUser.setOrgName(((CoreOrgBean)this.orgService.selectById(orgId)).getOrgName());
            if (roleId != null) {
                loginUser.setRoleId(roleId);
                loginUser.setRoleName(((CoreRoleBean)this.roleService.selectById(roleId)).getRoleName());
            }
            AuthenticationHelper.updateCacheAuthentication(token, authentication);
        }
    }
}

