/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.item.file.validator;

import java.util.Arrays;
import java.util.Objects;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.utils.FileUtils;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.validator.data.DataValidator;
import org.springframework.stereotype.Repository;
import org.springframework.web.multipart.MultipartFile;

@Repository
public class CoreFileCKEditorUploadValidator
implements DataValidator {
    @Override
    public boolean doValid(Object ... args) {
        MultipartFile file = Objects.requireNonNull((MultipartFile)args[1]);
        if (file != null && !file.isEmpty()) {
            String fileExt = FileUtils.getFileExtension(file.getOriginalFilename());
            if (StringUtils.isEmpty(fileExt)) {
                this.addConstraintViolation("SINO.FILE.TIP.NOT_PERMITTED_EXTENSION");
                return false;
            }
            String validFileExtensions = ApplicationContextHelper.getConstantValue("FILE-CKEDITOR-EXTENSIONS");
            if (!Arrays.asList(StringUtils.split(validFileExtensions, ",")).contains(fileExt.toLowerCase())) {
                this.addConstraintViolation("SINO.FILE.TIP.UNSUPPORTED_EXTENSION");
                return false;
            }
            int spaceLimit = NumberUtils.parseNumber(ApplicationContextHelper.getConstantValue("FILE-SPACELIMIT"), Integer.TYPE);
            if (spaceLimit == 0) {
                spaceLimit = 100;
            }
            if (!file.isEmpty() && file.getSize() > (long)(spaceLimit * 1024 * 1024)) {
                this.addConstraintViolation("SINO.FILE.TIP.SIZE_LIMIT_EXCEEDED");
                return false;
            }
            return true;
        }
        this.addConstraintViolation("SINO.FILE.TIP.NO_FILE");
        return false;
    }
}

