/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.item.file.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.data.Pair;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.http.HttpClientManager;
import net.sinodawn.framework.io.file.FilePathDTO;
import net.sinodawn.framework.io.file.FilePathManager;
import net.sinodawn.framework.io.file.FileScope;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.utils.ArchiveUtils;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.EncryptUtils;
import net.sinodawn.framework.utils.FileUtils;
import net.sinodawn.framework.utils.PdfUtils;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.WkHtmlToPdfUtils;
import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.item.file.bean.CoreFileCkeditorUploadResultDTO;
import net.sinodawn.module.item.file.bean.CoreFileLogBean;
import net.sinodawn.module.item.file.bean.CoreFileOfficeResultDTO;
import net.sinodawn.module.item.file.constant.CoreFileOfficeStatus;
import net.sinodawn.module.item.file.constant.CoreFileOperation;
import net.sinodawn.module.item.file.consumer.CoreOfficeInvokeConsumer;
import net.sinodawn.module.item.file.dao.CoreFileDao;
import net.sinodawn.module.item.file.manager.CoreFileManager;
import net.sinodawn.module.item.file.service.CoreFileEventService;
import net.sinodawn.module.item.file.service.CoreFileLogService;
import net.sinodawn.module.item.file.service.CoreFileService;
import net.sinodawn.module.item.file.utils.CoreFileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Repository
public class CoreFileServiceImpl
implements CoreFileService {
    private static final Logger logger = LogManager.getLogger(CoreFileService.class);
    @Autowired
    private CoreFileDao fileDao;
    @Autowired
    @Lazy
    private CoreFileService proxyInstance;
    @Autowired
    private CoreFileLogService fileLogService;
    @Autowired
    private CoreFileEventService fileEventService;
    @Lazy
    @Autowired
    private CoreFileManager fileManager;

    @Override
    public CoreFileDao getDao() {
        return this.fileDao;
    }

    @Override
    @Transactional(timeout=200000)
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public Long upload(CoreFileBean coreFile, MultipartFile file) {
        Long key = ApplicationContextHelper.getNextIdentity();
        CoreFileBean insertCoreFile = new CoreFileBean();
        insertCoreFile.setId(key);
        insertCoreFile.setTargetId(this.getReplactedTargetId(coreFile.getTargetId()));
        insertCoreFile.setName(this.getOriginalFilename(file.getOriginalFilename()));
        insertCoreFile.setFileExt(FileUtils.getFileExtension(insertCoreFile.getName()));
        insertCoreFile.setMd5Name(EncryptUtils.MD5Encrypt(key + "$" + insertCoreFile.getName()));
        insertCoreFile.setScope(Objects.toString(coreFile.getScope(), FileScope.secure.name()));
        insertCoreFile.setValidTimeFrom(coreFile.getValidTimeFrom());
        insertCoreFile.setValidTimeTo(coreFile.getValidTimeTo());
        insertCoreFile.setSize(file.getSize());
        insertCoreFile.setTimes(0);
        insertCoreFile.setExt(coreFile.getExt());
        insertCoreFile.setDownloadable(Optional.ofNullable(coreFile.getDownloadable()).orElse("1"));
        insertCoreFile.setCreatedTime(LocalDateTime.now());
        insertCoreFile.setBizCategory(coreFile.getBizCategory());
        insertCoreFile.setExt$(coreFile.getExt$());
        this.getDao().insert(insertCoreFile);
        this.fileManager.upload(insertCoreFile, file);
        this.fileLogService.insert(key, CoreFileOperation.INSERT.name());
        this.fileEventService.publishFileEvent(CoreFileOperation.INSERT, insertCoreFile);
        return key;
    }

    @Override
    @Transactional(timeout=200000)
    public Long upload(CoreFileBean coreFile, File uploadFile) {
        Long key = ApplicationContextHelper.getNextIdentity();
        CoreFileBean insertCoreFile = new CoreFileBean();
        insertCoreFile.setId(key);
        insertCoreFile.setTargetId(this.getReplactedTargetId(coreFile.getTargetId()));
        insertCoreFile.setName(uploadFile.getName());
        insertCoreFile.setFileExt(FileUtils.getFileExtension(uploadFile.getName()));
        insertCoreFile.setMd5Name(EncryptUtils.MD5Encrypt(key + "$" + uploadFile.getName()));
        insertCoreFile.setScope(Objects.toString(coreFile.getScope(), FileScope.secure.name()));
        insertCoreFile.setValidTimeFrom(coreFile.getValidTimeFrom());
        insertCoreFile.setValidTimeTo(coreFile.getValidTimeTo());
        insertCoreFile.setSize(uploadFile.length());
        insertCoreFile.setTimes(0);
        insertCoreFile.setExt(coreFile.getExt());
        insertCoreFile.setDownloadable("1");
        insertCoreFile.setCreatedTime(LocalDateTime.now());
        insertCoreFile.setExt$(coreFile.getExt$());
        insertCoreFile.setBizCategory(coreFile.getBizCategory());
        this.getDao().insert(insertCoreFile);
        this.fileManager.upload(insertCoreFile, uploadFile);
        this.fileLogService.insert(key, CoreFileOperation.INSERT.name());
        this.fileEventService.publishFileEvent(CoreFileOperation.INSERT, insertCoreFile);
        return key;
    }

    @Override
    public Page<CoreFileBean> selectSearchablePagination(RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        Page<CoreFileBean> page = this.selectPagination(parameter, rowBounds);
        page.getRows().stream().filter(f -> "1".equals(f.getDownloadable())).forEach(f -> f.setDownloadUrl(this.fileManager.getDownloadUrl((CoreFileBean)f)));
        return page;
    }

    public <ID extends Serializable> List<CoreFileBean> selectFileList(String table, ID itemId) {
        CoreFileBean searchTerms = new CoreFileBean();
        searchTerms.setTargetId(CoreFileUtils.getTargetId(table, itemId));
        List<CoreFileBean> fileList = this.getDao().selectList(searchTerms, new Order[0]);
        fileList.forEach(f -> f.setDownloadUrl(this.fileManager.getDownloadUrl((CoreFileBean)f)));
        return fileList;
    }

    @Override
    public List<CoreFileBean> selectFileListByTargetIds(String ... targetIds) {
        if (targetIds != null && targetIds.length != 0) {
            List searchFileList = Arrays.asList(targetIds).stream().map(t -> {
                CoreFileBean f = new CoreFileBean();
                f.setTargetId((String)t);
                return f;
            }).collect(Collectors.toList());
            List<CoreFileBean> fileList = this.getDao().selectList(searchFileList, ArrayUtils.asList("TARGETID"), CollectionUtils.emptyList(), new Order[0]);
            fileList.forEach(f -> f.setDownloadUrl(this.fileManager.getDownloadUrl((CoreFileBean)f)));
            return fileList;
        }
        return CollectionUtils.emptyList();
    }

    @Override
    @Transactional
    public void delete(RestJsonWrapperBean jsonWrapper) {
        List<CoreFileBean> fileList = jsonWrapper.parse(CoreFileBean.class);
        if (!fileList.isEmpty()) {
            List<CoreFileBean> selectedFileList = this.selectListByIds(fileList.stream().map(e -> e.getId()).collect(Collectors.toList()));
            this.deleteList(selectedFileList);
            fileList.forEach(f -> this.fileEventService.publishFileEvent(CoreFileOperation.DELETE, (CoreFileBean)f));
        }
    }

    @Transactional
    public <ID extends Serializable> void delete(String table, ID itemId) {
        CoreFileBean filter = new CoreFileBean();
        filter.setTargetId(CoreFileUtils.getTargetId(table, itemId));
        List<CoreFileBean> fileList = this.getDao().selectList(filter, new Order[0]);
        if (!fileList.isEmpty()) {
            this.deleteList(fileList);
            fileList.forEach(f -> this.fileEventService.publishFileEvent(CoreFileOperation.DELETE, (CoreFileBean)f));
        }
    }

    @Override
    @Transactional
    public void delete(Long id) {
        this.deleteList(Arrays.asList((CoreFileBean)this.selectById(id)));
    }

    @Override
    @Transactional
    public void deleteList(List<CoreFileBean> fileList) {
        if (!fileList.isEmpty()) {
            fileList.forEach(f -> f.setTargetId("X" + f.getTargetId()));
            this.getDao().update(fileList, new String[]{"TARGETID"});
            List<Long> fileIdList = fileList.stream().map(f -> f.getId()).collect(Collectors.toList());
            this.fileLogService.insert(fileIdList, CoreFileOperation.DELETE.name());
            fileList.forEach(f -> this.fileEventService.publishFileEvent(CoreFileOperation.DELETE, (CoreFileBean)f));
        }
    }

    @Override
    @Transactional
    public void save(RestJsonWrapperBean jsonWrapper) {
        List<CoreFileBean> fileList = jsonWrapper.parse(CoreFileBean.class);
        if (!fileList.isEmpty()) {
            this.getDao().updateIfChanged(fileList);
            fileList.forEach(f -> this.fileEventService.publishFileEvent(CoreFileOperation.UPDATE, (CoreFileBean)f));
        }
    }

    @Override
    @Transactional
    public void copy(String fromTargetId, Consumer<CoreFileBean> converter) {
        CoreFileBean searchTerms = new CoreFileBean();
        searchTerms.setTargetId(fromTargetId);
        List<CoreFileBean> fromFileList = this.getDao().selectList(searchTerms, new Order[0]);
        if (!fromFileList.isEmpty()) {
            LocalDateTime now = LocalDateTime.now();
            ArrayList<Pair<CoreFileBean, CoreFileBean>> pairList = new ArrayList<Pair<CoreFileBean, CoreFileBean>>();
            ArrayList<CoreFileBean> targetFileList = new ArrayList<CoreFileBean>();
            for (CoreFileBean fromFile : fromFileList) {
                CoreFileBean toFile = new CoreFileBean();
                BeanUtils.copyProperties((Object)fromFile, (Object)toFile, new String[0]);
                converter.accept(toFile);
                toFile.setId(ApplicationContextHelper.getNextIdentity());
                toFile.setMd5Name(EncryptUtils.MD5Encrypt(toFile.getId() + "$" + toFile.getName()));
                toFile.setTimes(0);
                toFile.setCreatedTime(now);
                targetFileList.add(toFile);
                pairList.add(Pair.of(fromFile, toFile));
            }
            this.getDao().insert(targetFileList);
            pairList.forEach(p -> {
                this.fileManager.copyFile((CoreFileBean)p.getFirst(), (CoreFileBean)p.getSecond());
                this.fileEventService.publishFileEvent(CoreFileOperation.INSERT, (CoreFileBean)p.getSecond());
            });
            List<Long> fileIdList = targetFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
            this.fileLogService.insert(fileIdList, CoreFileOperation.INSERT.name());
        }
    }

    @Override
    @Transactional
    public void copy(String sourceTargetId, String destTargetId) {
        this.copy(sourceTargetId, (CoreFileBean f) -> f.setTargetId(destTargetId));
    }

    @Override
    public String pack(String table, String itemId, String func) {
        CoreFileBean searchTerms = new CoreFileBean();
        searchTerms.setTargetId(table + "$" + itemId);
        searchTerms.setDownloadable("1");
        List<CoreFileBean> fileList = this.getDao().selectList(searchTerms, new Order[0]);
        Function function = (Function)ApplicationContextHelper.getBean(func);
        if (function != null) {
            fileList.addAll((Collection)function.apply(itemId));
        }
        return this.pack(fileList);
    }

    @Override
    public String pack(String table, RestJsonWrapperBean jsonWrapper) {
        List<String> idList = jsonWrapper.parseId(String.class);
        if (idList.isEmpty()) {
            return null;
        }
        List targetIdList = idList.stream().distinct().map(i -> table + "$" + i).collect(Collectors.toList());
        List<CoreFileBean> fileList = this.getDao().selectListByOneColumnValues(targetIdList, "TARGETID", new Order[0]);
        return fileList.isEmpty() ? null : this.pack(fileList);
    }

    @Override
    public String pack(RestJsonWrapperBean jsonWrapper) {
        List<Long> idList = jsonWrapper.parseId(Long.class);
        if (idList.isEmpty()) {
            return null;
        }
        List<CoreFileBean> fileList = this.getDao().selectListByIds(idList, new Order[0]);
        return fileList.isEmpty() ? null : this.pack(fileList);
    }

    @Override
    public CoreFileBean selectDetail(Long id) {
        CoreFileBean file = (CoreFileBean)this.getDao().selectById(id);
        file.setDownloadUrl(this.fileManager.getDownloadUrl(file));
        return file;
    }

    @Override
    public CoreFileCkeditorUploadResultDTO ckeditorUpload(CoreFileBean coreFile, MultipartFile file) {
        coreFile.setScope(FileScope.open.name());
        Long id = this.proxyInstance.upload(coreFile, file);
        CoreFileBean uploadedFile = (CoreFileBean)this.getDao().selectById(id);
        CoreFileCkeditorUploadResultDTO result = new CoreFileCkeditorUploadResultDTO();
        result.setUploaded(1);
        result.setFileName(uploadedFile.getName());
        result.setUrl(this.fileManager.getDownloadUrl(uploadedFile));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(timeout=200000)
    public CoreFileOfficeResultDTO sinoOfficeInvoke(Long fileId) {
        CoreFileOfficeResultDTO result = new CoreFileOfficeResultDTO();
        CoreFileBean file = (CoreFileBean)this.getDao().selectById(fileId);
        Scanner scanner = null;
        Scanner scannerUseDelimiter = null;
        try {
            scanner = new Scanner((InputStream)ServletUtils.getCurrentRequest().getInputStream());
            scannerUseDelimiter = scanner.useDelimiter("\\A");
            String body = scannerUseDelimiter.hasNext() ? scanner.next() : "";
            JSONObject sinoOfficeJson = JSONObject.parseObject((String)body);
            int sinoOfficeFileStatus = sinoOfficeJson.getIntValue("status");
            if (CoreFileOfficeStatus.SAVE.getStatusCode() == sinoOfficeFileStatus || CoreFileOfficeStatus.EXIT_SAVE.getStatusCode() == sinoOfficeFileStatus) {
                boolean login = LocalContextHelper.isUserLogin();
                try {
                    String sinoOfficeFileUrl;
                    if (!login) {
                        sinoOfficeFileUrl = (String)sinoOfficeJson.getJSONArray("users").get(0);
                        LocalContextHelper.setUserLogin(new LoginUser(sinoOfficeFileUrl, ""));
                    }
                    sinoOfficeFileUrl = sinoOfficeJson.getString("url");
                    file.setCreatedTime(LocalDateTime.now());
                    File tempFile = FileUtils.createTempFile();
                    HttpClientManager.getInstance().download(sinoOfficeFileUrl, tempFile);
                    this.fileManager.upload(file, tempFile);
                    if (CoreFileOfficeStatus.EXIT_SAVE.getStatusCode() == sinoOfficeFileStatus) {
                        file.setVersion(file.getVersion() + 1L);
                        this.getDao().update(file, new String[]{"VERSION", "CREATEDTIME"});
                    } else {
                        this.getDao().update(file, new String[]{"CREATEDTIME"});
                    }
                    this.fileLogService.insert(fileId, CoreFileOperation.UPDATE.name());
                    String service = ServletUtils.getCurrentRequestParamMap().get("service");
                    if (null != service) {
                        CoreOfficeInvokeConsumer officeInvokeFunction = (CoreOfficeInvokeConsumer)ApplicationContextHelper.getBean(service);
                        officeInvokeFunction.accept(fileId);
                    }
                }
                finally {
                    if (!login) {
                        LocalContextHelper.removeUserLogin();
                    }
                }
            }
            result.setError(0);
        }
        catch (IOException var34) {
            result.setError(1);
            logger.warn(var34.getMessage(), (Throwable)var34);
        }
        finally {
            if (scannerUseDelimiter != null) {
                try {
                    scannerUseDelimiter.close();
                }
                catch (Exception exception) {}
            }
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    @Override
    public Page<CoreFileLogBean> selectLogSearchablePagination(Long id, RestJsonWrapperBean wrapper) {
        return this.fileLogService.selectPaginationByFilter(SearchFilter.instance().match("FILEID", id).filter(MatchPattern.EQ), wrapper);
    }

    @Override
    public String convertHtmlToPdf(RestJsonWrapperBean wrapper) {
        String htmlContent = Objects.requireNonNull(wrapper.getParamValue("content"));
        Object fileName = Objects.requireNonNull(wrapper.getParamValue("fileName"));
        if (!StringUtils.endsWithIgnoreCase((String)fileName, ".pdf")) {
            fileName = (String)fileName + ".pdf";
        }
        FilePathDTO pdfFilePath = CoreFileUtils.toFilePath(FileScope.temp, (String)fileName);
        Path pdfPath = FilePathManager.getLocalPath(pdfFilePath);
        WkHtmlToPdfUtils.createPdf(pdfPath, htmlContent);
        this.fileManager.upload(pdfFilePath, pdfPath);
        return this.fileManager.getDownloadUrl(pdfFilePath);
    }

    @Override
    public void mergePdfList(List<FilePathDTO> sourcePdfList, FilePathDTO targetPdf) {
        ArrayList pdfList = new ArrayList();
        sourcePdfList.forEach(s -> {
            Path path = FilePathManager.getLocalPath(s);
            this.fileManager.download((FilePathDTO)s, path);
            pdfList.add(path);
        });
        PdfUtils.mergePdfFiles(FilePathManager.getLocalPath(targetPdf), pdfList.toArray(new Path[0]));
    }

    protected String getReplactedTargetId(String targetId) {
        return StringUtils.contains(targetId, "[{loginUserId}]") ? StringUtils.replace(targetId, "[{loginUserId}]", LocalContextHelper.getLoginUserId()) : targetId;
    }

    private String getOriginalFilename(String filename) {
        int index = filename.lastIndexOf("\\");
        if (index >= 0) {
            return filename.substring(index + 1);
        }
        index = filename.lastIndexOf("/");
        return index > 0 ? filename.substring(index + 1) : filename;
    }

    private String pack(List<CoreFileBean> fileList) {
        FilePathDTO filePath = FilePathDTO.of(FileScope.temp.name(), LocalDateTime.now(), StringUtils.randomUUID(16), "SINO.FILE.PACK.DEFAULT_FILE_NAME.zip");
        ArrayList<Path> zipPathList = new ArrayList<Path>();
        for (CoreFileBean coreFile : fileList) {
            zipPathList.add(CoreFileUtils.getLocalPath(coreFile));
        }
        ArchiveUtils.zip(FilePathManager.getLocalPath(filePath), zipPathList.toArray(new Path[zipPathList.size()]));
        this.fileManager.upload(filePath, FilePathManager.getLocalPath(filePath));
        return this.fileManager.getDownloadUrl(filePath);
    }
}

