/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.item.file.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.item.file.bean.CoreFileLogBean;
import net.sinodawn.module.item.file.dao.CoreFileLogDao;
import net.sinodawn.module.item.file.service.CoreFileLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreFileLogServiceImpl
implements CoreFileLogService {
    @Autowired
    private CoreFileLogDao coreFileLogDao;

    @Override
    public CoreFileLogDao getDao() {
        return this.coreFileLogDao;
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    public Long insert(RestJsonWrapperBean jsonWrapper) {
        CoreFileLogBean coreFileLog = jsonWrapper.parseUnique(CoreFileLogBean.class);
        coreFileLog.setId(ApplicationContextHelper.getNextIdentity());
        this.getDao().insert(coreFileLog);
        return coreFileLog.getId();
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    public Long insert(Long fileId, String fileOperationCategory) {
        CoreFileLogBean fileLog = new CoreFileLogBean();
        fileLog.setId(ApplicationContextHelper.getNextIdentity());
        fileLog.setFileId(fileId);
        fileLog.setOperationCategory(fileOperationCategory);
        this.getDao().insert(fileLog);
        return fileLog.getId();
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    public Long insert(List<Long> fileIdList, String fileOperationCategory) {
        if (fileIdList.isEmpty()) {
            return null;
        }
        List fileLogList = fileIdList.stream().map(id -> {
            CoreFileLogBean fileLog = new CoreFileLogBean();
            fileLog.setId(ApplicationContextHelper.getNextIdentity());
            fileLog.setFileId((Long)id);
            fileLog.setOperationCategory(fileOperationCategory);
            return fileLog;
        }).collect(Collectors.toList());
        this.getDao().insert(fileLogList);
        return ((CoreFileLogBean)fileLogList.get(0)).getId();
    }
}

