/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.item.file.service;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.io.file.FilePathDTO;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.item.file.bean.CoreFileCkeditorUploadResultDTO;
import net.sinodawn.module.item.file.bean.CoreFileLogBean;
import net.sinodawn.module.item.file.bean.CoreFileOfficeResultDTO;
import org.springframework.web.multipart.MultipartFile;

public interface CoreFileService
extends GenericService<CoreFileBean, Long> {
    @Override
    public Page<CoreFileBean> selectSearchablePagination(RestJsonWrapperBean var1);

    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public Long upload(CoreFileBean var1, MultipartFile var2);

    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public Long upload(CoreFileBean var1, File var2);

    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    default public Long upload(CoreFileBean coreFile, Path uploadPath) {
        return this.upload(coreFile, uploadPath.toFile());
    }

    public <PK extends Serializable> List<CoreFileBean> selectFileList(String var1, PK var2);

    public List<CoreFileBean> selectFileListByTargetIds(String ... var1);

    @Override
    public void delete(RestJsonWrapperBean var1);

    public <PK extends Serializable> void delete(String var1, PK var2);

    public void save(RestJsonWrapperBean var1);

    public String pack(String var1, String var2, String var3);

    public String pack(String var1, RestJsonWrapperBean var2);

    public String pack(RestJsonWrapperBean var1);

    @Override
    public CoreFileBean selectDetail(Long var1);

    public void copy(String var1, String var2);

    public void copy(String var1, Consumer<CoreFileBean> var2);

    public CoreFileCkeditorUploadResultDTO ckeditorUpload(CoreFileBean var1, MultipartFile var2);

    public void deleteList(List<CoreFileBean> var1);

    public CoreFileOfficeResultDTO sinoOfficeInvoke(Long var1);

    public Page<CoreFileLogBean> selectLogSearchablePagination(Long var1, RestJsonWrapperBean var2);

    public String convertHtmlToPdf(RestJsonWrapperBean var1);

    public void mergePdfList(List<FilePathDTO> var1, FilePathDTO var2);
}

