/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.item.file.manager;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.io.file.FilePathDTO;
import net.sinodawn.framework.io.file.FilePathManager;
import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.item.file.service.CoreFileService;
import net.sinodawn.module.item.file.utils.CoreFileUtils;
import org.springframework.web.multipart.MultipartFile;

public interface CoreFileManager {
    default public String getDownloadUrl(Long id) {
        CoreFileBean coreFile = (CoreFileBean)ApplicationContextHelper.getBean(CoreFileService.class).selectByIdIfPresent(id);
        return coreFile == null ? null : this.getDownloadUrl(coreFile);
    }

    default public String getAbsoluteDownloadUrl(Long id) {
        CoreFileBean coreFile = (CoreFileBean)ApplicationContextHelper.getBean(CoreFileService.class).selectByIdIfPresent(id);
        return coreFile == null ? null : this.getAbsoluteDownloadUrl(coreFile);
    }

    default public String getDownloadUrl(CoreFileBean coreFile) {
        return this.getDownloadUrl(CoreFileUtils.toFilePath(coreFile));
    }

    default public String getAbsoluteDownloadUrl(CoreFileBean coreFile) {
        return this.getAbsoluteDownloadUrl(CoreFileUtils.toFilePath(coreFile));
    }

    public String getDownloadUrl(FilePathDTO var1);

    public String getAbsoluteDownloadUrl(FilePathDTO var1);

    default public void upload(CoreFileBean coreFile, MultipartFile multipartFile) {
        this.upload(CoreFileUtils.toFilePath(coreFile), multipartFile);
    }

    default public void upload(CoreFileBean coreFile, Path path) {
        this.upload(CoreFileUtils.toFilePath(coreFile), path);
    }

    default public void upload(CoreFileBean coreFile, File file) {
        this.upload(CoreFileUtils.toFilePath(coreFile), file);
    }

    default public void upload(CoreFileBean coreFile, InputStream is) {
        this.upload(CoreFileUtils.toFilePath(coreFile), is);
    }

    public void upload(FilePathDTO var1, MultipartFile var2);

    public void upload(FilePathDTO var1, Path var2);

    default public void upload(FilePathDTO filePath, File file) {
        this.upload(filePath, file.toPath());
    }

    public void upload(FilePathDTO var1, InputStream var2);

    public void download(FilePathDTO var1, Path var2);

    default public void download(FilePathDTO filePath) {
        this.download(filePath, FilePathManager.getLocalPath(filePath));
    }

    default public void download(CoreFileBean coreFile, Path toFile) {
        this.download(CoreFileUtils.toFilePath(coreFile), toFile);
    }

    default public void download(CoreFileBean coreFile) {
        this.download(coreFile, FilePathManager.getLocalPath(CoreFileUtils.toFilePath(coreFile)));
    }

    public void copyFile(FilePathDTO var1, FilePathDTO var2);

    default public void copyFile(CoreFileBean from, CoreFileBean to) {
        this.copyFile(CoreFileUtils.toFilePath(from), CoreFileUtils.toFilePath(to));
    }

    public void duplicateFile(CoreFileBean var1, String var2);
}

