/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.validator.permission.aspect;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.admin.request.bean.CoreRequestUrlBean;
import net.sinodawn.module.admin.request.service.CoreRequestUrlService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=100)
@ConditionalOnProperty(name={"sino.api.check-access-permission"}, havingValue="true")
public class CheckAccessPermittedAspect {
    @Autowired
    private CoreRequestUrlService requestUrlService;

    @Around(value="within(net.sinodawn..resource..*)")
    public Object check(ProceedingJoinPoint pjp) throws Throwable {
        return pjp.proceed();
    }

    private List<CoreRequestUrlBean> getRequestUrlList(Map<String, List<CoreRequestUrlBean>> map, String requestUri, String method) {
        return map.entrySet().stream().filter(e -> this.match((String)e.getKey(), requestUri)).map(e -> (List)e.getValue()).flatMap(Collection::stream).filter(e -> StringUtils.isBlank(((CoreRequestUrlBean)e).getMethod()) || ((CoreRequestUrlBean)e).getMethod().equals(method)).collect(Collectors.toList());
    }

    private boolean match(String rawUri, String requestUri) {
        int j;
        char[] rawUriChars = rawUri.toCharArray();
        char[] requestUriChars = requestUri.toCharArray();
        int i = 0;
        int ik = rawUriChars.length;
        int jk = requestUriChars.length;
        for (j = 0; i < ik && j < jk; ++i, ++j) {
            char rawUriChar = rawUriChars[i];
            char requestUriChar = requestUriChars[j];
            if (rawUriChar == '{') {
                while (rawUriChar != '}') {
                    rawUriChar = rawUriChars[++i];
                }
                while (requestUriChar != '/' && j < jk - 1) {
                    requestUriChar = requestUriChars[++j];
                }
                if (i == ik - 1) {
                    return j == jk - 1;
                }
                if (j == jk - 1) {
                    return false;
                }
                rawUriChar = rawUriChars[++i];
            }
            if (rawUriChar == requestUriChar) continue;
            return false;
        }
        return i == ik && j == jk;
    }
}

