/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.validator.data;

import com.alibaba.fastjson.JSON;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import net.sinodawn.framework.exception.core.HttpErrorMessage;
import net.sinodawn.framework.utils.ServletUtils;
import org.springframework.http.HttpStatus;

public interface DataValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean isValid(Object ... args) {
        String constraintViolation;
        boolean var2;
        boolean var9 = false;
        try {
            var9 = true;
            var2 = this.doValid(args);
            var9 = false;
        }
        finally {
            HttpServletRequest var6;
            if (var9 && (constraintViolation = (String)(var6 = ServletUtils.getCurrentRequest()).getAttribute("validator.constraintViolation")) != null) {
                ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.BAD_REQUEST, constraintViolation));
            }
        }
        HttpServletRequest request = ServletUtils.getCurrentRequest();
        constraintViolation = (String)request.getAttribute("validator.constraintViolation");
        if (constraintViolation != null) {
            ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.BAD_REQUEST, constraintViolation));
        }
        return var2;
    }

    public boolean doValid(Object ... var1);

    default public void addConstraintViolation(String message) {
        HttpServletRequest request = ServletUtils.getCurrentRequest();
        Object constraintViolation = (String)request.getAttribute("validator.constraintViolation");
        if (constraintViolation == null) {
            constraintViolation = "";
        }
        constraintViolation = (String)constraintViolation + message;
        request.setAttribute("validator.constraintViolation", constraintViolation);
    }

    default public <T> boolean test(String businessName, String table, String column, T item, Predicate<T> predicate, String message) {
        return predicate.test(item);
    }

    default public boolean testNoneNull(String businessName, String table, String column, Object value) {
        return value != null;
    }

    default public boolean testJson(String businessName, String table, String column, String value) {
        try {
            JSON.parseObject((String)value);
            return true;
        }
        catch (Exception var6) {
            return false;
        }
    }
}

