/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.utils.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class XmlUtils {
    public static final Document read(File xmlFile) {
        try {
            Document var3;
            try (FileInputStream is = new FileInputStream(xmlFile);){
                var3 = XmlUtils.read(is);
            }
            return var3;
        }
        catch (IOException var15) {
            throw new FileException(var15);
        }
    }

    public static final Document read(String xml) {
        if (StringUtils.isEmpty(xml)) {
            return null;
        }
        try {
            Document var3;
            try (ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));){
                var3 = XmlUtils.read(is);
            }
            return var3;
        }
        catch (IOException var15) {
            throw new UnexpectedException(var15);
        }
    }

    public static final Document read(InputStream xmlInputStream) {
        SAXReader saxReader = new SAXReader();
        try {
            return saxReader.read(xmlInputStream);
        }
        catch (DocumentException var3) {
            throw new UnexpectedException(var3);
        }
    }

    public static final String getAttributeValue(Element element, String attributeName) {
        Attribute attribute = element.attribute(attributeName);
        return attribute == null ? null : attribute.getValue();
    }
}

