/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.utils.FileUtils;
import net.sinodawn.framework.utils.SystemUtils;

public abstract class WkHtmlToPdfUtils {
    public static final void createPdf(Path pdfPath, String htmlContent) {
        try {
            Path path = Files.createTempFile("", ".html", new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(htmlContent);
                writer.flush();
            }
            FileUtils.makeDirs(pdfPath);
            StringBuilder sb = new StringBuilder();
            if (SystemUtils.isWindows()) {
                sb.append("wkhtmltopdf.exe");
            } else {
                sb.append("./wkhtmltopdf");
            }
            sb.append(" ").append(path.toString()).append(" ").append(pdfPath.toString());
            SystemUtils.exec(sb.toString());
        }
        catch (IOException var16) {
            throw new FileException(var16);
        }
    }
}

