/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.exception.ProcessException;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.utils.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SystemUtils {
    private static final Logger logger = LogManager.getLogger(SystemUtils.class);
    private static final boolean IS_OS_WINDOWS = StringUtils.startsWith(SystemUtils.getSystemProperty("os.name"), "Windows");
    private static final boolean IS_OS_MAC = StringUtils.startsWith(SystemUtils.getSystemProperty("os.name"), "Mac");
    private static final boolean IS_ARM = "aarch64".equals(SystemUtils.getSystemProperty("os.arch"));
    private static final List<String> SYSTEM_MAC_ADDRESS_LIST = new ArrayList<String>();

    public static final boolean isWindows() {
        return IS_OS_WINDOWS;
    }

    public static final boolean isLinux() {
        return !IS_OS_WINDOWS && !IS_OS_MAC;
    }

    public static final boolean isArm() {
        return IS_ARM;
    }

    public static final Path getWorkingPath() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    public static final String execAndReturn(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            OutputInterceptor error = new OutputInterceptor(process.getErrorStream());
            error.start();
            String output = SystemUtils.getInputStreamContent(process.getInputStream());
            process.waitFor();
            return output;
        }
        catch (IOException var4) {
            throw new FileException(var4);
        }
        catch (InterruptedException var5) {
            throw new ProcessException(var5);
        }
    }

    public static final void exec(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            OutputInterceptor error = new OutputInterceptor(process.getErrorStream());
            OutputInterceptor output = new OutputInterceptor(process.getInputStream());
            error.start();
            output.start();
            process.waitFor();
        }
        catch (IOException var4) {
            throw new FileException(var4);
        }
        catch (InterruptedException var5) {
            throw new ProcessException(var5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<String> getMacAddresses() {
        if (SYSTEM_MAC_ADDRESS_LIST.isEmpty()) {
            List<String> list = SYSTEM_MAC_ADDRESS_LIST;
            synchronized (list) {
                if (SYSTEM_MAC_ADDRESS_LIST.isEmpty()) {
                    try {
                        Enumeration<NetworkInterface> niEnum = NetworkInterface.getNetworkInterfaces();
                        ArrayList<String> macAddressList = new ArrayList<String>();
                        while (true) {
                            byte[] bytes;
                            if (!niEnum.hasMoreElements()) {
                                SYSTEM_MAC_ADDRESS_LIST.addAll(macAddressList);
                                return SYSTEM_MAC_ADDRESS_LIST;
                            }
                            NetworkInterface ni = niEnum.nextElement();
                            if (ni.isPointToPoint() || ni.isVirtual() || (bytes = ni.getHardwareAddress()) == null) continue;
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < bytes.length; ++i) {
                                String s;
                                if (i != 0) {
                                    sb.append("-");
                                }
                                sb.append((String)((s = Integer.toHexString(bytes[i] & 0xFF)).length() == 1 ? "0" + s : s));
                            }
                            macAddressList.add(sb.toString().toUpperCase());
                        }
                    }
                    catch (SocketException var9) {
                        throw new UnexpectedException(var9);
                    }
                }
            }
        }
        return SYSTEM_MAC_ADDRESS_LIST;
    }

    public static final String getOSName() {
        return SystemUtils.getSystemProperty("os.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getInputStreamContent(InputStream is) {
        String var2;
        try {
            String string;
            Throwable var33;
            BufferedReader br;
            block26: {
                block27: {
                    String var5;
                    br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                    var33 = null;
                    StringBuilder info = new StringBuilder();
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (info.length() > 0) {
                            info.append("\n");
                        }
                        info.append(line);
                    }
                    string = var5 = info.toString();
                    if (br == null) break block26;
                    if (var33 == null) break block27;
                    try {
                        br.close();
                    }
                    catch (Throwable var28) {
                        var33.addSuppressed(var28);
                    }
                    break block26;
                }
                br.close();
            }
            return string;
            catch (Throwable var29) {
                try {
                    try {
                        var33 = var29;
                        throw var29;
                    }
                    catch (Throwable throwable) {
                        if (br != null) {
                            if (var33 != null) {
                                try {
                                    br.close();
                                }
                                catch (Throwable var28) {
                                    var33.addSuppressed(var28);
                                }
                            } else {
                                br.close();
                            }
                        }
                        throw throwable;
                    }
                }
                catch (IOException var31) {
                    var2 = "";
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return var2;
    }

    private static final String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException var2) {
            throw new UnexpectedException(var2);
        }
    }

    private static class OutputInterceptor
    extends Thread {
        private InputStream is;

        public OutputInterceptor(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            String result = SystemUtils.getInputStreamContent(this.is);
            if (!StringUtils.isEmpty(result)) {
                logger.info(result);
            }
        }
    }
}

