/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.exception.UnsupportedException;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.EncodingUtils;
import net.sinodawn.framework.utils.NumberUtils;

public class StringUtils {
    public static boolean isBlank(String target) {
        return target == null || target.length() == 0 || StringUtils.trim(target).length() == 0;
    }

    public static boolean isEmpty(String target) {
        return target == null || target.length() == 0;
    }

    public static boolean contains(String str, String searchPattern) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return StringUtils.isEmpty(searchPattern) || str.contains(searchPattern);
    }

    public static boolean containsIgnoreCase(String str, String searchPattern) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return StringUtils.isEmpty(searchPattern) || str.toLowerCase().contains(searchPattern.toLowerCase());
    }

    public static String capitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, false);
    }

    public static boolean startsWith(String str, String prefix) {
        if (str != null && prefix != null) {
            return prefix.length() <= str.length() && str.startsWith(prefix);
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str != null && prefix != null) {
            return prefix.length() <= str.length() && str.substring(0, prefix.length()).equalsIgnoreCase(prefix);
        }
        return false;
    }

    public static boolean endsWith(String str, String suffix) {
        if (str != null && suffix != null) {
            return suffix.length() <= str.length() && str.endsWith(suffix);
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        if (str != null && suffix != null) {
            return suffix.length() <= str.length() && str.substring(str.length() - suffix.length()).equalsIgnoreCase(suffix);
        }
        return false;
    }

    public static String trim(String target) {
        if (target == null) {
            return null;
        }
        char[] chars = target.toCharArray();
        int start = 0;
        int end = chars.length;
        int var5 = chars.length;
        for (char c : chars) {
            if (!Character.isWhitespace(c)) break;
            ++start;
        }
        for (int i = chars.length - 1; i > 0 && Character.isWhitespace(chars[i]); --i) {
            --end;
        }
        return end > start ? String.copyValueOf(chars, start, end - start) : "";
    }

    public static <V> String replace(String target, String searchPattern, V replacement) {
        if (!StringUtils.isEmpty(target) && !StringUtils.isEmpty(searchPattern)) {
            int start = 0;
            int end = target.indexOf(searchPattern, start);
            if (end == -1) {
                return target;
            }
            StringBuilder sb = new StringBuilder(target.substring(0, start));
            int searchPatternLen = searchPattern.length();
            while (end != -1) {
                sb.append(target, start, end).append(replacement);
                start = end + searchPatternLen;
                end = target.indexOf(searchPattern, start);
            }
            sb.append(target.substring(start));
            return sb.toString();
        }
        return target;
    }

    public static <V> String replaceFirst(String target, String searchPattern, V replacement) {
        if (!StringUtils.isEmpty(target) && !StringUtils.isEmpty(searchPattern)) {
            int pos = target.indexOf(searchPattern);
            return pos == -1 ? target : target.substring(0, pos) + replacement + target.substring(pos + searchPattern.length());
        }
        return target;
    }

    public static <V> String replaceLast(String target, String searchPattern, V replacement) {
        if (!StringUtils.isEmpty(target) && !StringUtils.isEmpty(searchPattern)) {
            int pos = target.lastIndexOf(searchPattern);
            return pos == -1 ? target : target.substring(0, pos) + replacement + target.substring(pos + searchPattern.length());
        }
        return target;
    }

    public static <V> String replaceIgnoreCase(String target, String searchPattern, V replacement) {
        if (!StringUtils.isEmpty(target) && !StringUtils.isEmpty(searchPattern)) {
            int targetLength = target.length();
            int searchPatternLength = searchPattern.length();
            StringBuilder sb = new StringBuilder();
            int start = 0;
            int lastEnd = 0;
            while (start + searchPatternLength <= targetLength) {
                String next = target.substring(start, start + searchPatternLength);
                if (next.equalsIgnoreCase(searchPattern)) {
                    sb.append(target, lastEnd, start).append(replacement);
                    start = lastEnd = start + searchPatternLength;
                    continue;
                }
                ++start;
            }
            sb.append(target.substring(lastEnd));
            return sb.toString();
        }
        return target;
    }

    public static String removeStart(String target, String searchPattern) {
        if (!StringUtils.isEmpty(target) && !StringUtils.isEmpty(searchPattern)) {
            return target.startsWith(searchPattern) ? target.substring(searchPattern.length()) : target;
        }
        return target;
    }

    public static String removeStartIgnoreCase(String target, String searchPattern) {
        if (!StringUtils.isEmpty(target) && !StringUtils.isEmpty(searchPattern)) {
            return target.toLowerCase().startsWith(searchPattern.toLowerCase()) ? target.substring(searchPattern.length()) : target;
        }
        return target;
    }

    public static String removeEnd(String target, String searchPattern) {
        if (!StringUtils.isEmpty(target) && !StringUtils.isEmpty(searchPattern)) {
            return target.endsWith(searchPattern) ? target.substring(0, target.length() - searchPattern.length()) : target;
        }
        return target;
    }

    public static String removeEndIgnoreCase(String target, String searchPattern) {
        if (!StringUtils.isEmpty(target) && !StringUtils.isEmpty(searchPattern)) {
            return target.toLowerCase().endsWith(searchPattern.toLowerCase()) ? target.substring(0, target.length() - searchPattern.length()) : target;
        }
        return target;
    }

    public static String trimAllWhitespace(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isSpaceChar(c) || Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String replaceBetween(String target, String openTag, String closeTag, Map<String, ?> map) {
        if (map != null && !map.isEmpty()) {
            List<String> substrings = StringUtils.substringsBetween(target, openTag, closeTag);
            if (substrings.isEmpty()) {
                return target;
            }
            String replaceTarget = target;
            for (String substring : substrings) {
                Object replacementValue = map.get(substring);
                if (replacementValue == null) continue;
                String replacement = ConvertUtils.convert(map.get(substring), String.class);
                replaceTarget = StringUtils.replace(replaceTarget, openTag + substring + closeTag, replacement);
            }
            return replaceTarget;
        }
        return target;
    }

    public static String replaceBetweenSpan(String target, Map<String, Object> map) {
        if (map.isEmpty()) {
            return target;
        }
        String replaceTarget = target;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String regex = "<span\\s+id\\s*=\\s*(['\"])" + entry.getKey() + "(['\"])\\s*>(.|\\s)*?</span>";
            Pattern p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(replaceTarget);
            replaceTarget = m.replaceAll("<span id='" + entry.getKey() + "'>" + entry.getValue() + "</span>");
        }
        return replaceTarget;
    }

    public static String repeat(String source, int repeat) {
        if (repeat > 0 && !StringUtils.isEmpty(source)) {
            return source.repeat(repeat);
        }
        return "";
    }

    public static int countOccurrencesOf(String str, String sub) {
        if (str != null && sub != null && str.length() != 0 && sub.length() != 0) {
            int count = 0;
            int subLength = sub.length();
            int i = 0;
            while (i <= str.length() - subLength) {
                if (sub.equals(str.substring(i, i + subLength))) {
                    ++count;
                    i += subLength;
                    continue;
                }
                ++i;
            }
            return count;
        }
        return 0;
    }

    public static String[] split(String str, String delimiter) {
        int currentIndex;
        if (str == null) {
            return new String[0];
        }
        if (StringUtils.isEmpty(delimiter)) {
            return new String[]{str};
        }
        ArrayList<String> container = new ArrayList<String>();
        int lastIndex = 0;
        int delimiterLength = delimiter.length();
        while ((currentIndex = str.indexOf(delimiter, lastIndex)) > -1) {
            container.add(str.substring(lastIndex, currentIndex));
            lastIndex = currentIndex + delimiterLength;
        }
        if (lastIndex <= str.length()) {
            container.add(str.substring(lastIndex));
        }
        return container.toArray(new String[0]);
    }

    public static String[] regexSplit(String str, String regex) {
        String[] stringArray;
        if (str == null) {
            return new String[0];
        }
        if (StringUtils.isEmpty(regex)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = str;
        } else {
            stringArray = str.split(regex);
        }
        return stringArray;
    }

    public static String decode(String str, String fromCharsetName, String toCharsetName) {
        try {
            return new String(str.getBytes(fromCharsetName), toCharsetName);
        }
        catch (UnsupportedEncodingException var4) {
            throw new UnsupportedException(var4);
        }
    }

    public static String unionArithmetic(String target1, String target2, int length) {
        if (!StringUtils.isEmpty(target1) && !StringUtils.isEmpty(target2)) {
            String temp = Integer.toBinaryString(NumberUtils.toBinaryNumber(target1) | NumberUtils.toBinaryNumber(target2));
            return StringUtils.leftPad(temp, length);
        }
        return "";
    }

    public static String leftPad(String source, int length) {
        return StringUtils.pad(source, length, true);
    }

    public static String rightPad(String source, int length) {
        return StringUtils.pad(source, length, false);
    }

    public static List<String> substringsBetween(String target, String openTag, String closeTag) {
        int strLen;
        ArrayList<String> subStrings = new ArrayList<String>();
        if (!(StringUtils.isEmpty(target) || StringUtils.isEmpty(openTag) || StringUtils.isEmpty(closeTag) || (strLen = target.length()) == 0)) {
            int end;
            int start;
            int closeLen = closeTag.length();
            int openLen = openTag.length();
            int pos = 0;
            while (pos < strLen - closeLen && (start = target.indexOf(openTag, pos)) >= 0 && (end = target.indexOf(closeTag, start += openLen)) >= 0) {
                subStrings.add(target.substring(start, end));
                pos = end + closeLen;
            }
        }
        return subStrings;
    }

    public static String randomUUID(int size) {
        return StringUtils.randomUUID().substring(0, size);
    }

    public static String randomUUID() {
        UUID uuid = UUID.randomUUID();
        return StringUtils.replace(uuid.toString(), "-", "");
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str != null && str.length() != 0) {
            StringBuilder sb = new StringBuilder(str.length());
            if (capitalize) {
                sb.append(Character.toUpperCase(str.charAt(0)));
            } else {
                sb.append(Character.toLowerCase(str.charAt(0)));
            }
            sb.append(str.substring(1));
            return sb.toString();
        }
        return str;
    }

    private static String pad(String source, int length, boolean leftPosition) {
        if (StringUtils.isEmpty(source)) {
            return StringUtils.repeat("0", length);
        }
        if (length > 0 && source.length() < length) {
            return leftPosition ? StringUtils.repeat("0", length - source.length()) + source : source + StringUtils.repeat("0", length - source.length());
        }
        return source;
    }

    public static boolean equalsIgnoreCase(String v1, String v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        return v1.equalsIgnoreCase(v2);
    }

    public static boolean equals(String v1, String v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    public static String encodeURL(String url) {
        if (url.contains(" ")) {
            String[] strs = StringUtils.split(url, " ");
            StringBuilder sb = new StringBuilder();
            int var4 = strs.length;
            for (String s : strs) {
                if (sb.length() > 0) {
                    sb.append("%20");
                }
                if (StringUtils.isEmpty(s)) continue;
                sb.append(URLEncoder.encode(s, StandardCharsets.UTF_8));
            }
            return sb.toString();
        }
        return URLEncoder.encode(url, StandardCharsets.UTF_8);
    }

    public static String decodeURL(String url) {
        return URLDecoder.decode(url, StandardCharsets.UTF_8);
    }

    public static String reverse(String str) {
        return str == null ? null : new StringBuilder(str).reverse().toString();
    }

    public static String lowerCase(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static Object lowerCaseIfPossible(Object value) {
        return value instanceof String ? ((String)value).toLowerCase() : value;
    }

    public static String upperCase(String value) {
        return value != null ? value.toUpperCase() : null;
    }

    public static String join(Collection<?> itemList, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Object item : itemList) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(ConvertUtils.convert(item, String.class, ""));
        }
        return sb.toString();
    }

    public static <T> String join(T[] itemList, String separator) {
        StringBuilder sb = new StringBuilder();
        for (T item : itemList) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(ConvertUtils.convert(item, String.class, ""));
        }
        return sb.toString();
    }

    public static final String read(InputStream is) {
        try {
            int i;
            byte[] bytes = null;
            byte[] buf = new byte[2048];
            while ((i = is.read(buf)) != -1) {
                if (bytes == null) {
                    bytes = new byte[i];
                    System.arraycopy(buf, 0, bytes, 0, i);
                    continue;
                }
                byte[] temp = new byte[bytes.length + i];
                System.arraycopy(bytes, 0, temp, 0, bytes.length);
                System.arraycopy(buf, 0, temp, bytes.length, i);
                bytes = temp;
            }
            if (bytes == null) {
                return "";
            }
            return new String(bytes, EncodingUtils.detect(bytes));
        }
        catch (IOException var5) {
            throw new FileException(var5);
        }
    }

    public static String abbreviate(String text) {
        if (StringUtils.isBlank(text)) {
            return text;
        }
        int length = text.length();
        return length > 240 ? text.substring(0, 240) + "..." : text;
    }

    public static boolean containsNumber(String text) {
        return !StringUtils.isBlank(text) && text.matches(".*\\d+.*");
    }

    public static boolean containsLowercaseLetter(String text) {
        return !StringUtils.isBlank(text) && text.matches(".*[a-z]+.*");
    }

    public static boolean containsCapitalLetter(String text) {
        return !StringUtils.isBlank(text) && text.matches(".*[A-Z]+.*");
    }

    public static boolean containsSpecialCharacter(String text) {
        return !StringUtils.isBlank(text) && text.matches(".*[`~!@#$%^&*()_+\\-={}\\[\\]|:;\"'<>,.?/\\\\]+.*");
    }
}

