/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import com.blueconic.browscap.Capabilities;
import com.blueconic.browscap.ParseException;
import com.blueconic.browscap.UserAgentParser;
import com.blueconic.browscap.UserAgentService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.exception.core.HttpErrorMessage;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class ServletUtils {
    private static final UserAgentParser userAgentParser;
    private static String contextPath;

    public static Capabilities getCurrentRequestCapabilities() {
        HttpServletRequest request = ServletUtils.getCurrentRequest();
        return request == null ? null : userAgentParser.parse(request.getHeader("user-agent"));
    }

    public static String getRemoteIp(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ServletUtils.isBlankOrUnknownIp(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ServletUtils.isBlankOrUnknownIp(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ServletUtils.isBlankOrUnknownIp(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ServletUtils.isBlankOrUnknownIp(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ServletUtils.isBlankOrUnknownIp(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static HttpServletRequest getCurrentRequest() {
        HttpServletRequest request;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && (request = requestAttributes.getRequest()) != null) {
            return request;
        }
        return LocalContextHelper.getHttpServletRequest();
    }

    public static HttpServletResponse getCurrentResponse() {
        HttpServletResponse response;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && (response = requestAttributes.getResponse()) != null) {
            return response;
        }
        return LocalContextHelper.getHttpServletResponse();
    }

    public static HttpSession getCurrentSession() {
        HttpServletRequest request = ServletUtils.getCurrentRequest();
        return request == null ? null : request.getSession(false);
    }

    public static String getCurrentRawSessionId() {
        HttpSession session = ServletUtils.getCurrentSession();
        return session == null ? null : ServletUtils.getRawSessionId(session.getId());
    }

    public static ServletContext getServletContext() {
        WebApplicationContext webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
        return webApplicationContext.getServletContext();
    }

    public static String getServletRootPath() {
        return ServletUtils.getServletContext().getRealPath("/");
    }

    public static String getRawSessionId(String sessionId) {
        return sessionId.contains("!") ? sessionId.substring(0, sessionId.indexOf("!")) : sessionId;
    }

    public static Map<String, String> getCurrentRequestParamMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        HttpServletRequest request = ServletUtils.getCurrentRequest();
        if (request != null) {
            request.getParameterMap().forEach((k, v) -> {
                String var10000 = map.put((String)k, v[0]);
            });
        }
        return map;
    }

    @Deprecated
    public static void responseError(String error) {
        ServletUtils.responseError(400, error);
    }

    public static void responseError(HttpErrorMessage errorMessage) {
        ServletUtils.responseError(errorMessage.getStatus(), errorMessage.toString());
    }

    public static void responseError(int httpStatus, String error) {
        HttpServletResponse response = ServletUtils.getCurrentResponse();
        if (response != null && !response.isCommitted()) {
            response.reset();
            response.setStatus(httpStatus);
            response.setCharacterEncoding("UTF-8");
            try (PrintWriter pw = response.getWriter();){
                pw.print(error);
                pw.flush();
            }
            catch (IOException var16) {
                throw new UnexpectedException(var16);
            }
        }
    }

    public static void responseMessage(ServletResponse response, String message) {
        if (response != null && !response.isCommitted()) {
            response.reset();
            response.setCharacterEncoding("UTF-8");
            try (PrintWriter writer = response.getWriter();){
                writer.write(message);
                writer.flush();
            }
            catch (IOException var15) {
                throw new UnexpectedException(var15);
            }
        }
    }

    public static void responseMessage(ServletResponse response, int httpStatus, String message) {
        if (response != null && !response.isCommitted()) {
            response.reset();
            ((HttpServletResponse)response).setStatus(httpStatus);
            response.setCharacterEncoding("UTF-8");
            try (PrintWriter writer = response.getWriter();){
                writer.write(message);
                writer.flush();
            }
            catch (IOException var16) {
                throw new UnexpectedException(var16);
            }
        }
    }

    public static String getRequestUri() {
        return ServletUtils.getRequestUri(ServletUtils.getCurrentRequest());
    }

    public static String getContextPath() {
        if (contextPath == null) {
            contextPath = ApplicationContextHelper.getEnvironment().getProperty("server.servlet.context-path", "");
        }
        return contextPath;
    }

    public static String getRequestUri(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        return StringUtils.isBlank(ServletUtils.getContextPath()) ? request.getRequestURI() : StringUtils.removeStart(request.getRequestURI(), ServletUtils.getContextPath());
    }

    public static String getRequestUrl() {
        return ServletUtils.getRequestUrl(ServletUtils.getCurrentRequest());
    }

    public static String getRequestUrl(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        return StringUtils.isBlank(ServletUtils.getContextPath()) ? request.getRequestURL().toString() : StringUtils.removeStart(request.getRequestURL().toString(), ServletUtils.getContextPath());
    }

    public static String getUrl(String url, String replativeUrl) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty(url)) {
            sb.append(StringUtils.removeEnd(url, "/"));
        }
        return sb.append(replativeUrl).toString();
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue) {
        ServletUtils.addCookie(request, response, cookieName, cookieValue, -1);
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue, int expirySeconds) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setPath(StringUtils.isBlank(request.getContextPath()) ? "/" : request.getContextPath());
        cookie.setSecure(false);
        cookie.setHttpOnly(true);
        cookie.setMaxAge(expirySeconds);
        response.addCookie(cookie);
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] var2;
        for (Cookie cookie : var2 = request.getCookies()) {
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    private static boolean isBlankOrUnknownIp(String ip) {
        return StringUtils.isEmpty(ip) || "unknown".equalsIgnoreCase(ip) || StringUtils.split(ip, ".").length != 4;
    }

    static {
        try {
            userAgentParser = new UserAgentService().loadParser();
        }
        catch (ParseException | IOException var1) {
            throw new UnexpectedException(var1);
        }
    }
}

