/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sinodawn.framework.exception.InvalidDataException;
import net.sinodawn.framework.exception.ReflectionException;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.StringUtils;

public class ReflectionUtils {
    private static final Map<String, Annotation> CLASS_ANNOTATION_CONTAINER = new HashMap<String, Annotation>();
    private static final Map<String, Annotation> METHOD_ANNOTATION_CONTAINER = new HashMap<String, Annotation>();

    public static boolean isReadMethod(Method method) {
        String methodName = method.getName();
        return (StringUtils.startsWith(methodName, "CGLIB$get") || StringUtils.startsWith(methodName, "get") || StringUtils.startsWith(methodName, "CGLIB$is") || StringUtils.startsWith(methodName, "is")) && method.getParameterCount() == 0;
    }

    public static boolean isWriteMethod(Method method) {
        String methodName = method.getName();
        return (StringUtils.startsWith(methodName, "CGLIB$set") || StringUtils.startsWith(methodName, "set")) && method.getParameterCount() == 1;
    }

    public static Method findReadMethod(Class<?> clazz, String propertyName) {
        return ReflectionUtils.findMethod(clazz, "get" + StringUtils.capitalize(propertyName));
    }

    public static Method findWriteMethod(Class<?> clazz, String propertyName) {
        return Arrays.stream(clazz.getMethods()).filter(m -> m.getName().equals("set" + StringUtils.capitalize(propertyName)) && m.getParameterCount() == 1).findFirst().orElse(null);
    }

    public static Method findMethodByName(Class<?> clazz, String name) {
        for (Class<?> searchClazz = clazz; searchClazz != null; searchClazz = searchClazz.getSuperclass()) {
            Method method = Arrays.stream(searchClazz.getDeclaredMethods()).filter(m -> m.getName().equals(name)).findFirst().orElse(null);
            if (method == null) continue;
            return method;
        }
        Class<?>[] var8 = clazz != null ? clazz.getInterfaces() : new Class[]{};
        int var4 = var8.length;
        for (Class<?> iClazz : var8) {
            Method method = Arrays.stream(iClazz.getMethods()).filter(m -> m.getName().equals(name)).findFirst().orElse(null);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static List<Method> getMethodList(Class<?> clazz, int ... modifiers) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Class<?> searchClazz = clazz; searchClazz != null; searchClazz = searchClazz.getSuperclass()) {
            Method[] methods = searchClazz.getDeclaredMethods();
            int var6 = methods.length;
            for (Method method : methods) {
                if (!methodList.stream().noneMatch(f -> f.equals(method)) || modifiers != null && !Arrays.stream(modifiers).allMatch(m -> (method.getModifiers() & m) != 0)) continue;
                methodList.add(method);
            }
        }
        return methodList;
    }

    public static List<Method> getAnnotatedMethodList(Class<?> clazz, Class<? extends Annotation> annotationClazz) {
        Class<?> searchClazz;
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (searchClazz = clazz; searchClazz != null; searchClazz = searchClazz.getSuperclass()) {
            Method[] methods = searchClazz.getDeclaredMethods();
            int var6 = methods.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                Method method = methods[var7];
                if (!method.isAnnotationPresent(annotationClazz) || !methodList.stream().noneMatch(m -> ReflectionUtils.sameNameAndParameterTypes(m, method))) continue;
                methodList.add(method);
            }
        }
        for (searchClazz = clazz; searchClazz != null; searchClazz = searchClazz.getSuperclass()) {
            for (Class<?> iClazz : searchClazz.getInterfaces()) {
                Method[] interfaceMethods = iClazz.getMethods();
                int var10 = interfaceMethods.length;
                for (Method interfaceMethod : interfaceMethods) {
                    if (!interfaceMethod.isAnnotationPresent(annotationClazz) || !methodList.stream().noneMatch(m -> ReflectionUtils.sameNameAndParameterTypes(m, interfaceMethod))) continue;
                    methodList.add(interfaceMethod);
                }
            }
        }
        return methodList;
    }

    public static <A extends Annotation> A getMethodAnnotation(Class<?> clazz, Method method, Class<A> annotationClazz) {
        Class<?> iClazz;
        Method matchMethod;
        for (Class<?> searchClazz = clazz; searchClazz != null; searchClazz = searchClazz.getSuperclass()) {
            matchMethod = Arrays.stream(searchClazz.getDeclaredMethods()).filter(m -> ReflectionUtils.sameNameAndParameterTypes(m, method) && m.isAnnotationPresent(annotationClazz)).findFirst().orElse(null);
            if (matchMethod == null) continue;
            return matchMethod.getAnnotation(annotationClazz);
        }
        Iterator<Class<?>> var7 = ReflectionUtils.getAllInterfaces(clazz).iterator();
        do {
            if (var7.hasNext()) continue;
            return null;
        } while ((matchMethod = (Method)Arrays.stream((iClazz = var7.next()).getDeclaredMethods()).filter(m -> ReflectionUtils.sameNameAndParameterTypes(m, method) && m.isAnnotationPresent(annotationClazz)).findFirst().orElse(null)) == null);
        return matchMethod.getAnnotation(annotationClazz);
    }

    public static List<Class<?>> getAllInterfaces(Class<?> clazz) {
        if (clazz != null && !Object.class.equals(clazz)) {
            ArrayList interfaceList = new ArrayList();
            for (Class<?> searchClazz = clazz; searchClazz != null; searchClazz = searchClazz.getSuperclass()) {
                Class<?>[] var3 = searchClazz.getInterfaces();
                int var4 = var3.length;
                for (Class<?> iClass : var3) {
                    interfaceList.add(iClass);
                    interfaceList.addAll(ReflectionUtils.getAllInterfaces(iClass));
                }
            }
            return interfaceList;
        }
        return CollectionUtils.emptyList();
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, null);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        for (Class<?> searchClazz = clazz; searchClazz != null; searchClazz = searchClazz.getSuperclass()) {
            Method method = Arrays.stream(searchClazz.getDeclaredMethods()).filter(m -> m.getName().equalsIgnoreCase(name) && (parameterTypes == null || Arrays.equals(m.getParameterTypes(), parameterTypes))).findFirst().orElse(null);
            if (method == null) continue;
            return method;
        }
        Class<?>[] var9 = clazz != null ? clazz.getInterfaces() : new Class[]{};
        int var5 = var9.length;
        for (Class<?> iClazz : var9) {
            Method method = Arrays.stream(iClazz.getMethods()).filter(m -> m.getName().equalsIgnoreCase(name) && (parameterTypes == null || Arrays.equals(m.getParameterTypes(), parameterTypes))).findFirst().orElse(null);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static Method findMethodWithReturnType(Class<?> clazz, String name, Type returnType) {
        for (Class<?> searchClazz = clazz; searchClazz != null; searchClazz = searchClazz.getSuperclass()) {
            Method method = Arrays.stream(searchClazz.getDeclaredMethods()).filter(m -> m.getName().equals(name) && m.getReturnType().equals(returnType)).findFirst().orElse(null);
            if (method == null) continue;
            return method;
        }
        Class<?>[] var9 = clazz != null ? clazz.getInterfaces() : new Class[]{};
        int var5 = var9.length;
        for (Class<?> iClazz : var9) {
            Method method = Arrays.stream(iClazz.getMethods()).filter(m -> m.getName().equals(name) && m.getReturnType().equals(returnType)).findFirst().orElse(null);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        Object var4;
        boolean accessible = method.isAccessible();
        try {
            if (!accessible) {
                method.setAccessible(true);
            }
            var4 = method.invoke(target, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException var8) {
            throw new ReflectionException(var8);
        }
        finally {
            if (!accessible) {
                method.setAccessible(false);
            }
        }
        return var4;
    }

    public static void invokeWriteMethod(Object target, String propertyName, Object arg) {
        Method writeMethod = ReflectionUtils.findWriteMethod(target.getClass(), propertyName);
        if (writeMethod == null) {
            throw new InvalidDataException("No [" + propertyName + "] write method of [" + target.getClass().getName() + "].");
        }
        ReflectionUtils.invokeMethod(writeMethod, target, arg);
    }

    public static Object invokeReadMethod(Object target, String propertyName) {
        Method readMethod = ReflectionUtils.findReadMethod(target.getClass(), propertyName);
        return ReflectionUtils.invokeMethod(readMethod, target, new Object[0]);
    }

    public static List<Field> getFiledList(Class<?> clazz, int ... modifiers) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields = searchType.getDeclaredFields();
            int var6 = fields.length;
            for (Field field : fields) {
                if (!fieldList.stream().noneMatch(f -> f.getName().equals(field.getName())) || modifiers != null && !Arrays.stream(modifiers).allMatch(m -> (field.getModifiers() & m) != 0)) continue;
                fieldList.add(field);
            }
        }
        return fieldList;
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field field = Arrays.stream(searchType.getDeclaredFields()).filter(f -> f.getName().equalsIgnoreCase(name) && (type == null || f.getType().equals(type))).findFirst().orElse(null);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public static Field findFieldOfReadMethod(Method readMethod) {
        String methodName;
        if (!ReflectionUtils.isReadMethod(readMethod)) {
            throw new InvalidDataException("Method [" + readMethod.getName() + "] is not a read method.");
        }
        Class<?> clazz = readMethod.getDeclaringClass();
        if (ClassUtils.isCglibProxyClass(clazz)) {
            clazz = clazz.getSuperclass();
        }
        String propertyName = StringUtils.startsWith(methodName = readMethod.getName(), "is") ? methodName.substring(2) : methodName.substring(3);
        return ReflectionUtils.findField(clazz, StringUtils.uncapitalize(propertyName), readMethod.getReturnType());
    }

    public static Field findFieldOfWriteMethod(Method writeMethod) {
        if (!ReflectionUtils.isWriteMethod(writeMethod)) {
            throw new InvalidDataException("Method [" + writeMethod.getName() + "] is not a write method.");
        }
        Class<?> clazz = writeMethod.getDeclaringClass();
        if (ClassUtils.isCglibProxyClass(clazz)) {
            clazz = clazz.getSuperclass();
        }
        String propertyName = writeMethod.getName().substring(3);
        return ReflectionUtils.findField(clazz, StringUtils.uncapitalize(propertyName), writeMethod.getParameterTypes()[0]);
    }

    public static Object getFieldValue(Object target, String propertyName) {
        Field property = ReflectionUtils.findField(target.getClass(), propertyName);
        if (property == null) {
            return null;
        }
        try {
            Object value;
            if (property.isAccessible()) {
                value = property.get(target);
            } else {
                property.setAccessible(true);
                value = property.get(target);
                property.setAccessible(false);
            }
            return value;
        }
        catch (IllegalAccessException | IllegalArgumentException var5) {
            throw new ReflectionException(var5);
        }
    }

    public static void setFieldValue(Object target, String propertyName, Object value) {
        Field property = ReflectionUtils.findField(target.getClass(), propertyName);
        if (property != null) {
            try {
                if (property.isAccessible()) {
                    property.set(target, value);
                } else {
                    property.setAccessible(true);
                    property.set(target, value);
                    property.setAccessible(false);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException var5) {
                throw new ReflectionException(var5);
            }
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> targetClass, Class<T> annotationClass) {
        Class<?> clazz = ClassUtils.getRawType(targetClass);
        String key = clazz.getName() + "-" + annotationClass.getName();
        Annotation cacheAnnotation = CLASS_ANNOTATION_CONTAINER.get(key);
        if (cacheAnnotation == null) {
            for (Class<?> searchClazz = clazz; searchClazz != null && (cacheAnnotation = searchClazz.getAnnotation(annotationClass)) == null; searchClazz = searchClazz.getSuperclass()) {
                Class<?>[] var6 = searchClazz.getInterfaces();
                int var7 = var6.length;
                for (Class<?> iClazz : var6) {
                    T interfaceAnnotation = iClazz.getAnnotation(annotationClass);
                    if (interfaceAnnotation == null) continue;
                    return interfaceAnnotation;
                }
            }
            if (cacheAnnotation != null) {
                CLASS_ANNOTATION_CONTAINER.put(key, cacheAnnotation);
            }
        }
        return (T)cacheAnnotation;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        Class<?> clazz = ClassUtils.getRawType(method.getDeclaringClass());
        String key = method.toGenericString() + "-" + annotationClass.getName();
        Annotation cacheAnnotation = METHOD_ANNOTATION_CONTAINER.get(key);
        if (cacheAnnotation == null) {
            for (Class<?> searchClazz = clazz; searchClazz != null; searchClazz = searchClazz.getSuperclass()) {
                try {
                    Class<?> iClazz;
                    Method searchInterfaceMethod;
                    Method searchMethod = searchClazz.getMethod(method.getName(), method.getParameterTypes());
                    cacheAnnotation = searchMethod.getAnnotation(annotationClass);
                    if (cacheAnnotation != null) break;
                    Class<?>[] var7 = searchClazz.getInterfaces();
                    int var8 = var7.length;
                    Class<?>[] classArray = var7;
                    int n = classArray.length;
                    for (int i = 0; i < n && (cacheAnnotation = (searchInterfaceMethod = (iClazz = classArray[i]).getMethod(method.getName(), method.getParameterTypes())).getAnnotation(annotationClass)) == null; ++i) {
                    }
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
                if (cacheAnnotation != null) break;
            }
            if (cacheAnnotation != null) {
                METHOD_ANNOTATION_CONTAINER.put(key, cacheAnnotation);
            }
        }
        return (T)cacheAnnotation;
    }

    public static boolean isValidBeanProperty(Class<?> type, Field property) {
        return !property.getName().equalsIgnoreCase("readonly") && ReflectionUtils.findReadMethod(type, property.getName()) != null && ReflectionUtils.findWriteMethod(type, property.getName()) != null;
    }

    private static boolean sameNameAndParameterTypes(Method m1, Method m2) {
        Class<?>[] types2;
        if (m1 == null) {
            return m2 == null;
        }
        if (m2 == null) {
            return false;
        }
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        Class<?>[] types1 = m1.getParameterTypes();
        if (types1.length != (types2 = m2.getParameterTypes()).length) {
            return false;
        }
        int j = types1.length;
        for (int i = 0; i < j; ++i) {
            if (types1[i].equals(types2[i])) continue;
            return false;
        }
        return true;
    }
}

