/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.io.file.FilePathDTO;
import net.sinodawn.framework.io.file.FilePathManager;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.FileUtils;
import net.sinodawn.framework.utils.SystemUtils;

public class PdfUtils {
    public static void mergePdfFiles(Path destPath, Path ... pdfPaths) {
        if (!ArrayUtils.isEmpty(pdfPaths)) {
            String[] absolutePdfPaths = (String[])Arrays.stream(pdfPaths).map(Path::toString).toArray(String[]::new);
            PdfUtils.mergePdfFiles(destPath.toString(), absolutePdfPaths);
        }
    }

    public static void mergePdfFiles(String targetFilePath, String ... sourcePdfPaths) {
        if (!ArrayUtils.isEmpty(sourcePdfPaths)) {
            Path targetPath = Paths.get(targetFilePath, new String[0]);
            FileUtils.makeDirs(targetPath);
            com.lowagie.text.Document document = null;
            PdfCopy copy = null;
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(Files.newOutputStream(targetPath, new OpenOption[0]));
                document = new com.lowagie.text.Document(new PdfReader(sourcePdfPaths[0]).getPageSize(1));
                copy = new PdfCopy(document, (OutputStream)os);
                document.open();
                String[] var6 = sourcePdfPaths;
                int var7 = sourcePdfPaths.length;
                for (int var8 = 0; var8 < var7; ++var8) {
                    String sourceFilePath = var6[var8];
                    PdfReader reader = new PdfReader(sourceFilePath);
                    int n = reader.getNumberOfPages();
                    for (int j = 1; j <= n; ++j) {
                        document.newPage();
                        PdfImportedPage page = copy.getImportedPage(reader, j);
                        copy.addPage(page);
                    }
                }
            }
            catch (Exception var27) {
                throw new FileException(var27);
            }
            finally {
                if (copy != null) {
                    try {
                        copy.close();
                    }
                    catch (Exception exception) {}
                }
                if (document != null) {
                    try {
                        document.close();
                    }
                    catch (Exception exception) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void addStamp(File pdfFile, File picStampFile) {
        String fileName;
        PdfReader reader;
        if (FileUtils.isImage(picStampFile) && FileUtils.isExtension(pdfFile, "pdf")) {
            reader = null;
            fileName = pdfFile.getAbsolutePath();
            try {
                reader = new PdfReader(pdfFile.getAbsolutePath());
            }
            catch (IOException var12) {
                throw new FileException(var12);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        throw new UnexpectedException(I18nHelper.getMessage("SINO.EXCEPTION.FILE_FORMAT_WRONG", new String[0]));
        File temFile = PdfUtils.getAddStampFile(reader, picStampFile.getAbsolutePath());
        temFile.renameTo(new File(fileName));
    }

    public static void addText(FilePathDTO pdfFilePath, FilePathDTO destPdfFilePath, TextPhraseConfig textPhraseConfig) {
        PdfUtils.addText(FilePathManager.getLocalPath(pdfFilePath).normalize().toString(), FilePathManager.getLocalPath(destPdfFilePath).normalize().toString(), textPhraseConfig);
    }

    public static void addText(String pdfFilePath, String destPdfFilePath, final TextPhraseConfig textPhraseConfig) {
        Document document = null;
        com.itextpdf.text.pdf.PdfReader reader = null;
        PdfWriter writer = null;
        try {
            document = new Document();
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdfFilePath));
            writer.setPageEvent((PdfPageEvent)new PdfPageEventHelper(){

                public void onEndPage(PdfWriter writer, Document doc) {
                    Font font = FontFactory.getFont((String)textPhraseConfig.getFont(), (String)"Identity-H", (boolean)true, (float)textPhraseConfig.getFontSize(), (int)0, (BaseColor)textPhraseConfig.getColor());
                    Phrase textPhrase = new Phrase(textPhraseConfig.getText(), font);
                    ColumnText.showTextAligned((com.itextpdf.text.pdf.PdfContentByte)writer.getDirectContent(), (int)1, (Phrase)textPhrase, (float)textPhraseConfig.getX(), (float)textPhraseConfig.getY(), (float)0.0f);
                }
            });
            FileUtils.createFile(Paths.get(pdfFilePath, new String[0]));
            document.open();
            com.itextpdf.text.pdf.PdfContentByte pdfContent = writer.getDirectContent();
            reader = new com.itextpdf.text.pdf.PdfReader(pdfFilePath);
            int j = reader.getNumberOfPages();
            for (int i = 1; i <= j; ++i) {
                document.newPage();
                com.itextpdf.text.pdf.PdfImportedPage page = writer.getImportedPage(reader, i);
                pdfContent.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
            }
        }
        catch (Exception var23) {
            throw new FileException(var23);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (document != null) {
                try {
                    document.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void addImage(FilePathDTO pdfFilePath, FilePathDTO destPdfFilePath, ImageConfig imageConfig) {
        PdfUtils.addImage(FilePathManager.getLocalPath(pdfFilePath).normalize().toString(), FilePathManager.getLocalPath(destPdfFilePath).normalize().toString(), imageConfig);
    }

    public static void addImage(String pdfFilePath, String destPdfFilePath, final ImageConfig imageConfig) {
        Document document = null;
        com.itextpdf.text.pdf.PdfReader reader = null;
        PdfWriter writer = null;
        try {
            document = new Document();
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdfFilePath));
            writer.setPageEvent((PdfPageEvent)new PdfPageEventHelper(){

                public void onEndPage(PdfWriter writer, Document doc) {
                    PdfPTable table = new PdfPTable(1);
                    table.setTotalWidth(530.0f);
                    PdfPCell cell = new PdfPCell();
                    cell.setBorder(0);
                    try {
                        com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((String)imageConfig.getImgPath());
                        image.setWidthPercentage(20.0f);
                        cell.setPaddingTop(-20.0f);
                        cell.addElement((Element)image);
                    }
                    catch (Exception var6) {
                        throw new FileException(var6);
                    }
                    table.addCell(cell);
                    table.writeSelectedRows(0, -1, imageConfig.getX(), imageConfig.getY(), writer.getDirectContent());
                }
            });
            document.open();
            com.itextpdf.text.pdf.PdfContentByte pdfContent = writer.getDirectContent();
            FileUtils.createFile(Paths.get(destPdfFilePath, new String[0]));
            reader = new com.itextpdf.text.pdf.PdfReader(destPdfFilePath);
            int j = reader.getNumberOfPages();
            for (int i = 1; i <= j; ++i) {
                document.newPage();
                com.itextpdf.text.pdf.PdfImportedPage page = writer.getImportedPage(reader, i);
                pdfContent.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
            }
        }
        catch (Exception var23) {
            throw new FileException(var23);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (document != null) {
                try {
                    document.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void addTextWatermark(String filePath, String destFilePath, String waterMark) {
        String fontPath = SystemUtils.getWorkingPath() + File.separator + "simsun.ttc,1";
        com.itextpdf.text.pdf.PdfReader reader = null;
        FileOutputStream fos = null;
        File destFile = null;
        com.itextpdf.text.pdf.PdfStamper stamper = null;
        try {
            reader = new com.itextpdf.text.pdf.PdfReader(filePath, "PDF".getBytes());
            destFile = new File(destFilePath);
            FileUtils.createFile(destFile);
            fos = new FileOutputStream(destFile);
            stamper = new com.itextpdf.text.pdf.PdfStamper(reader, (OutputStream)fos);
            BaseFont font = BaseFont.createFont((String)fontPath, (String)"Identity-H", (boolean)true);
            int pageSize = reader.getNumberOfPages();
            for (int i = 1; i <= pageSize; ++i) {
                stamper.getUnderContent(i);
                com.itextpdf.text.pdf.PdfContentByte under = stamper.getOverContent(i);
                under.beginText();
                under.setColorFill(BaseColor.LIGHT_GRAY);
                under.setFontAndSize(font, 50.0f);
                under.setTextMatrix(550.0f, 400.0f);
                under.showTextAligned(2, waterMark, 550.0f, 400.0f, 45.0f);
                under.endText();
            }
        }
        catch (com.itextpdf.text.DocumentException | IOException var25) {
            throw new UnexpectedException(var25);
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static File getAddStampFile(PdfReader reader, String picPath) {
        File newFile = FileUtils.createTempFile("pdf");
        FileOutputStream os = null;
        PdfStamper stamp = null;
        try {
            os = new FileOutputStream(newFile);
            stamp = new PdfStamper(reader, (OutputStream)os);
            Rectangle pageSize = reader.getPageSize(1);
            float height = pageSize.getHeight();
            float width = pageSize.getWidth();
            int nums = reader.getNumberOfPages();
            Image[] nImage = PdfUtils.splitImage(picPath, nums);
            for (int n = 1; n <= nums; ++n) {
                PdfContentByte over = stamp.getOverContent(n);
                Image img = nImage[n - 1];
                img.setAbsolutePosition(width - img.getWidth(), height / 2.0f - img.getHeight() / 2.0f);
                over.addImage(img);
            }
        }
        catch (DocumentException | IOException var23) {
            throw new FileException(var23);
        }
        finally {
            if (stamp != null) {
                try {
                    stamp.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
        return newFile;
    }

    private static Image[] splitImage(String imgPath, int n) {
        Image[] images = new Image[n];
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File(imgPath));
            int h = img.getHeight();
            int w = img.getWidth();
            int sw = w / n;
            for (int i = 0; i < n; ++i) {
                BufferedImage subImg = null;
                subImg = i == n - 1 ? img.getSubimage(i * sw, 0, w - i * sw, h) : img.getSubimage(i * sw, 0, sw, h);
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    ImageIO.write((RenderedImage)subImg, imgPath.substring(imgPath.lastIndexOf(46) + 1), out);
                    images[i] = Image.getInstance((byte[])out.toByteArray());
                    continue;
                }
            }
            return images;
        }
        catch (Exception var22) {
            throw new FileException(var22);
        }
    }

    public static class ImageConfig {
        private String imgPath;
        private float x;
        private float y;

        public String getImgPath() {
            return this.imgPath;
        }

        public void setImgPath(String imgPath) {
            this.imgPath = imgPath;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
        }
    }

    public static class TextPhraseConfig {
        private String text;
        private float x;
        private float y;
        private String font = "simsun.ttc,0";
        private float fontSize;
        private BaseColor color;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
        }

        public String getFont() {
            return this.font;
        }

        public void setFont(String font) {
            this.font = font;
        }

        public BaseColor getColor() {
            return this.color;
        }

        public void setColor(BaseColor color) {
            this.color = color;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(float fontSize) {
            this.fontSize = fontSize;
        }
    }
}

