/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.regex.Pattern;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import net.sinodawn.framework.exception.OutOfRangeException;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.exception.UnsupportedException;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;

public class NumberUtils {
    private static final int NUMBER_SCALE = 8;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[-+]*(\\.\\d+|\\d+\\.?\\d*)([Ee][+-]?[\\d]+)?$");
    private static final Pattern SCIENTIFIC_NUMBER_PATTERN = Pattern.compile("^[-+]*(\\.\\d+|\\d+\\.?\\d*)[Ee][+-]?[\\d]+$");
    private static final String[] CHINESE_FRACTIONS = new String[]{"\u89d2", "\u5206"};
    private static final String[] CHINESE_DIGITS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CHINESE_UNITS = new String[]{"", "\u62fe", "\u4f70", "\u4edf", "\u5143", "\u4e07", "\u4ebf"};
    private static final Pattern DOUBLE_INCORRECT_PRECISION = Pattern.compile("\\.[0-9]+9{7}[0-9]?$");

    public static boolean isNumber(String text) {
        return !StringUtils.isEmpty(text) && NUMBER_PATTERN.matcher(text).matches();
    }

    public static boolean isScientificNumber(String text) {
        return !StringUtils.isEmpty(text) && SCIENTIFIC_NUMBER_PATTERN.matcher(text).matches();
    }

    public static <T extends Number> String formatToChinese(T number) {
        int i;
        String intStrNumber;
        char[] chars;
        String strNumber = NumberUtils.formatNumber(number, 2, true);
        StringBuilder chineseBuilder = new StringBuilder();
        boolean hasFraction = strNumber.contains(".");
        if (StringUtils.startsWith(strNumber, "-")) {
            chineseBuilder.append("\u8d1f");
            strNumber = StringUtils.removeStart(strNumber, "-");
        }
        if ((chars = (intStrNumber = hasFraction ? strNumber.substring(0, strNumber.indexOf(".")) : strNumber).toCharArray()).length > 16) {
            throw new OutOfRangeException("The number to format chinese must be less than ten million billion.");
        }
        int j = chars.length;
        for (i = 0; i < j; ++i) {
            char c = chars[i];
            chineseBuilder.append(CHINESE_DIGITS[Character.getNumericValue(c)]);
            i = (j - i) % 4;
            if (i == 0) {
                i = 4;
            }
            chineseBuilder.append(CHINESE_UNITS[--i]);
            if (j - i == 9) {
                chineseBuilder.append("\u4ebf");
                continue;
            }
            if ((j - i) % 4 != 1 || (j - i - 1) / 4 % 2 != 1) continue;
            chineseBuilder.append("\u4e07");
        }
        chineseBuilder.append("\u5143");
        StringBuilder chinese = new StringBuilder(chineseBuilder.toString());
        chinese = new StringBuilder(chinese.toString().replaceAll("\u96f6[\u4f70|\u4edf|\u62fe]", "\u96f6"));
        chinese = new StringBuilder(chinese.toString().replaceAll("\u96f6+", "\u96f6"));
        chinese = new StringBuilder(chinese.toString().replaceAll("\u96f6\u4ebf", "\u4ebf"));
        chinese = new StringBuilder(chinese.toString().replaceAll("\u96f6\u4e07", "\u4e07"));
        chinese = new StringBuilder(chinese.toString().replaceAll("\u4ebf\u4e07", "\u4ebf"));
        if (!chinese.toString().equals("\u8d1f\u96f6\u5143") && !chinese.toString().equals("\u96f6\u5143")) {
            chinese = new StringBuilder(chinese.toString().replaceAll("\u96f6\u5143", "\u5143"));
        }
        if (hasFraction) {
            String fractionStrNumber = strNumber.substring(strNumber.indexOf(".") + 1);
            char[] fractionChars = fractionStrNumber.toCharArray();
            for (i = 0; i < fractionChars.length; ++i) {
                if (i == 0) {
                    int numericValue = Character.getNumericValue(fractionChars[0]);
                    chinese.append(CHINESE_DIGITS[numericValue]);
                    if (numericValue <= 0) continue;
                    chinese.append(CHINESE_FRACTIONS[i]);
                    continue;
                }
                if (i != 1) {
                    throw new UnexpectedException("Oops, are you kidding me?");
                }
                chinese.append(CHINESE_DIGITS[Character.getNumericValue(fractionChars[1])]).append(CHINESE_FRACTIONS[i]);
            }
            return chinese.toString();
        }
        return chinese + "\u6574";
    }

    public static <T extends Number> String formatNumber(T number, int precision, boolean significantDigit) {
        number = NumberUtils.getCorrectedNumber(number);
        String numberStr = String.format("%1$." + precision + "f", number);
        if (!significantDigit) {
            return numberStr;
        }
        while (numberStr.contains(".") && StringUtils.endsWith(numberStr, "0")) {
            numberStr = StringUtils.removeEnd(numberStr, "0");
        }
        return StringUtils.endsWith(numberStr, ".") ? StringUtils.removeEnd(numberStr, ".") : numberStr;
    }

    public static <T extends Number> String formatNumber(T number) {
        if (number == null) {
            return "";
        }
        Class<?> numberClass = number.getClass();
        if (numberClass.isPrimitive()) {
            numberClass = ClassUtils.getWrapperType(numberClass);
        }
        number = NumberUtils.getCorrectedNumber(number);
        if (Float.class != numberClass && Double.class != numberClass && BigDecimal.class != numberClass) {
            if (Byte.class != numberClass && Short.class != numberClass && Integer.class != numberClass && Long.class != numberClass && BigInteger.class != numberClass) {
                throw new UnsupportedException("Print " + number + ".");
            }
            return new DecimalFormat("#").format(number);
        }
        return !(Float.class == numberClass && Float.isNaN(((Float)number).floatValue()) || Double.class == numberClass && Double.isNaN((Double)number)) ? new DecimalFormat("#.##########").format(number) : "";
    }

    public static <T extends Number> String scientificNotationFormat(T number, int precision) {
        if (number == null) {
            return "";
        }
        double d = number.doubleValue();
        if (d == 0.0) {
            return NumberUtils.formatNumber(d, precision, false) + "E+0";
        }
        StringBuilder sb = new StringBuilder();
        if (d < 0.0) {
            sb.append("-");
            d = -d;
        }
        if (d >= 1.0) {
            int qty = 0;
            while (d >= 10.0) {
                ++qty;
                d = NumberUtils.div(d, 10.0);
            }
            sb.append(NumberUtils.formatNumber(d, precision, false)).append("E+").append(qty);
        } else {
            int qty = 0;
            while (d < 1.0) {
                ++qty;
                d = NumberUtils.mul(d, 10.0);
            }
            sb.append(NumberUtils.formatNumber(d, precision, false)).append("E-").append(qty);
        }
        return sb.toString();
    }

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass) {
        if (StringUtils.isEmpty(text)) {
            return (T)(targetClass.isPrimitive() ? (Number)((Number)ClassUtils.getPrimitiveDefaultValue(targetClass)) : (Number)null);
        }
        if (ClassUtils.isPrimitiveType(targetClass)) {
            targetClass = ClassUtils.getWrapperType(targetClass);
        }
        String newText = NumberUtils.getAccurateNumber(text);
        if (Byte.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(newText) ? Byte.decode(newText) : Byte.valueOf(newText));
        }
        if (Short.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(newText) ? Short.decode(newText) : Short.valueOf(newText));
        }
        if (Integer.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(newText) ? Integer.decode(newText) : Integer.valueOf(newText));
        }
        if (Long.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(newText) ? Long.decode(newText) : Long.valueOf(newText));
        }
        if (BigInteger.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(newText) ? NumberUtils.decodeBigInteger(newText) : new BigInteger(newText));
        }
        if (Float.class == targetClass) {
            return (T)Float.valueOf(newText);
        }
        if (Double.class == targetClass) {
            return (T)Double.valueOf(newText);
        }
        if (BigDecimal.class != targetClass && Number.class != targetClass) {
            throw new ConvertFailedException(String.class, targetClass, text);
        }
        return (T)new BigDecimal(newText);
    }

    public static <T extends Number> T max(T t1, T t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return t1.doubleValue() > t2.doubleValue() ? t1 : t2;
    }

    public static <T extends Number> T min(T t1, T t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return t1.doubleValue() > t2.doubleValue() ? t2 : t1;
    }

    public static <T> long parseLong(T text) {
        return ConvertUtils.convert(text, Long.TYPE);
    }

    public static <T> long parseLong(T text, long defaultValue) {
        try {
            return ConvertUtils.convert(text, Long.TYPE);
        }
        catch (Exception var4) {
            return defaultValue;
        }
    }

    public static <T> double parseDouble(T text) {
        return ConvertUtils.convert(text, Double.TYPE);
    }

    public static <T> double parseDouble(T text, double defaultValue) {
        try {
            return ConvertUtils.convert(text, Double.TYPE);
        }
        catch (Exception var4) {
            return defaultValue;
        }
    }

    public static <T> float parseFloat(T text) {
        return ConvertUtils.convert(text, Float.TYPE).floatValue();
    }

    public static <T> float parseFloat(T text, float defaultValue) {
        try {
            return ConvertUtils.convert(text, Float.TYPE).floatValue();
        }
        catch (Exception var3) {
            return defaultValue;
        }
    }

    public static <T> int parseInt(T text) {
        return ConvertUtils.convert(text, Integer.TYPE);
    }

    public static <T> int parseInt(T text, int defaultValue) {
        try {
            return ConvertUtils.convert(text, Integer.TYPE);
        }
        catch (Exception var3) {
            return defaultValue;
        }
    }

    public static <T> short parseShort(T text) {
        return ConvertUtils.convert(text, Short.TYPE);
    }

    public static <T> short parseShort(T text, short defaultValue) {
        try {
            return ConvertUtils.convert(text, Short.TYPE);
        }
        catch (Exception var3) {
            return defaultValue;
        }
    }

    public static <T> BigInteger parseBigInteger(T text) {
        return ConvertUtils.convert(text, BigInteger.class);
    }

    public static <T> BigInteger parseBigInteger(T text, BigInteger defaultValue) {
        try {
            return ConvertUtils.convert(text, BigInteger.class, defaultValue);
        }
        catch (Exception var3) {
            return defaultValue;
        }
    }

    public static <T> BigDecimal parseBigDecimal(T text) {
        return ConvertUtils.convert(text, BigDecimal.class);
    }

    public static <T> BigDecimal parseBigDecimal(T text, BigDecimal defaultValue) {
        try {
            return ConvertUtils.convert(text, BigDecimal.class, defaultValue);
        }
        catch (Exception var3) {
            return defaultValue;
        }
    }

    public static <T> double toDouble(T number) {
        return number == null ? 0.0 : ConvertUtils.convert(number.toString(), Double.TYPE, 0.0);
    }

    public static <T> double toCurrencyDouble(T number) {
        return NumberUtils.toDouble(number, 2);
    }

    public static <T> double toUnitPriceDouble(T number) {
        return NumberUtils.toDouble(number, 6);
    }

    public static <T> double toQuantityDouble(T number) {
        return NumberUtils.toDouble(number, 4);
    }

    public static <T> double toDouble(T number, int precision) {
        if (number == null) {
            return 0.0;
        }
        double d = NumberUtils.toDouble(number);
        return precision == 0 ? d : new BigDecimal(Double.toString(d)).setScale(precision, 4).doubleValue();
    }

    public static int toBinaryNumber(String number) {
        if (number == null) {
            return 0;
        }
        try {
            return Integer.valueOf(number, 2);
        }
        catch (NumberFormatException var2) {
            return 0;
        }
    }

    public static boolean isGreater(Number n1, Number n2) {
        if (n1 == null) {
            return false;
        }
        if (n2 == null) {
            return true;
        }
        return n1.doubleValue() > n2.doubleValue();
    }

    public static boolean isLess(Number n1, Number n2) {
        if (n1 == null) {
            return n2 != null;
        }
        if (n2 == null) {
            return false;
        }
        return n1.doubleValue() < n2.doubleValue();
    }

    @Deprecated
    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    @Deprecated
    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    @Deprecated
    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    @Deprecated
    public static double div(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, 8, 4).doubleValue();
    }

    @Deprecated
    public static double round(double v1, int scale) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal("1.0");
        return b1.divide(b2, scale, 4).doubleValue();
    }

    private static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (!value.startsWith("0x", index) && !value.startsWith("0X", index)) {
            if (value.startsWith("#", index)) {
                ++index;
                radix = 16;
            } else if (value.startsWith("0", index) && value.length() > 1 + index) {
                ++index;
                radix = 8;
            }
        } else {
            index += 2;
            radix = 16;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }

    private static <T extends Number> T getCorrectedNumber(T number) {
        Class<?> numberClass = number.getClass();
        return (T)(!numberClass.equals(Double.class) && !numberClass.equals(Double.TYPE) && !numberClass.equals(Float.class) && !numberClass.equals(Float.TYPE) ? number : NumberUtils.parseNumber(NumberUtils.getAccurateNumber("" + number), numberClass));
    }

    private static String getAccurateNumber(String strNumber) {
        String noCommaStrNumber = StringUtils.trim(StringUtils.replace(strNumber, ",", ""));
        if (!DOUBLE_INCORRECT_PRECISION.matcher(noCommaStrNumber).find()) {
            return noCommaStrNumber;
        }
        int length = noCommaStrNumber.substring(noCommaStrNumber.indexOf(".")).length() - 3;
        String offset = "0." + "0".repeat(Math.max(0, length)) + "1";
        Double d = new BigDecimal(noCommaStrNumber).doubleValue() + new Double(offset);
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(6);
        df.setGroupingUsed(false);
        return df.format(d);
    }
}

