/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.support.domain.BaseData;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;

public class JsonUtils {
    public static <T> String toJsonString(T t) {
        return JSONObject.toJSONString(t);
    }

    public static <T> T parse(String json, Class<T> objectClass) {
        if (ClassUtils.isSimpleType(objectClass)) {
            return ConvertUtils.convert(json, objectClass);
        }
        T instance = ClassUtils.newInstance(objectClass);
        JsonUtils.parse(json, instance);
        return instance;
    }

    public static <T> void parse(String json, T item) {
        JSONObject jo = JSON.parseObject((String)json);
        Class<?> clazz = ClassUtils.getRawType(item.getClass());
        List<BeanPropertyDescriptor> bpdList = BeanPropertyHelper.getBeanPropertyDescriptorList(clazz);
        jo.forEach((k, v) -> {
            if (v != null) {
                String key = StringUtils.removeStart(k, "ext$.");
                BeanPropertyDescriptor bpd = bpdList.stream().filter(b -> b.getName().equalsIgnoreCase(key)).findFirst().orElse(null);
                if (bpd != null) {
                    if (bpd.isExt$BeanProperty()) {
                        if (BaseData.class.isAssignableFrom(clazz)) {
                            ((Map)v).forEach((k1, v1) -> ((BaseData)item).setExt$Item(ConvertUtils.convert(k1, String.class), ConvertUtils.convert(v1, String.class)));
                        }
                    } else if (JSONArray.class.isAssignableFrom(v.getClass()) && (List.class.isAssignableFrom(bpd.getPropertyType()) || bpd.getPropertyType().isArray())) {
                        JSONArray ja = (JSONArray)v;
                        ArrayList list = new ArrayList();
                        Class genericClazz = null;
                        Type genericType = bpd.getProperty().getGenericType();
                        if (genericType instanceof ParameterizedType) {
                            ParameterizedType pt = (ParameterizedType)genericType;
                            genericClazz = (Class)pt.getActualTypeArguments()[0];
                        } else if (bpd.getPropertyType().isArray()) {
                            genericClazz = bpd.getPropertyType().getComponentType();
                        }
                        if (genericClazz != null) {
                            for (int i = 0; i < ja.size(); ++i) {
                                list.add(JsonUtils.parse(ja.getString(i), genericClazz));
                            }
                            if (List.class.isAssignableFrom(bpd.getPropertyType())) {
                                bpd.setPropertyValue(item, list);
                            } else {
                                bpd.setPropertyValue(item, list.toArray(ArrayUtils.emptyArray(genericClazz)));
                            }
                        }
                    } else {
                        bpd.setPropertyValue(item, v);
                    }
                } else if (BaseData.class.isAssignableFrom(clazz)) {
                    ((BaseData)item).setExt$Item(key, ConvertUtils.convert(v, String.class));
                }
            }
        });
    }

    public static <T> T parse(String json, String key, Class<T> objectClass) {
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        JSONObject jsonKeyObject = (JSONObject)jsonObject.get((Object)key);
        return jsonKeyObject == null ? null : (T)JsonUtils.parse(jsonKeyObject.toJSONString(), objectClass);
    }

    public static <T> List<T> parseList(String json, String key, Class<T> objectClass) {
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        JSONArray jsonKeyObject = (JSONArray)jsonObject.get((Object)key);
        return jsonKeyObject == null ? CollectionUtils.emptyList() : JsonUtils.parseList(jsonKeyObject.toJSONString(), objectClass);
    }

    public static <T> List<T> parseList(String json, Class<T> objectClass) {
        return StringUtils.isEmpty(json) ? CollectionUtils.emptyList() : JSONObject.parseArray((String)json, String.class).stream().map(j -> JsonUtils.parse(j, objectClass)).collect(Collectors.toList());
    }
}

