/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import net.sinodawn.framework.exception.database.JdbcException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JdbcUtils {
    private static final Logger logger = LogManager.getLogger(JdbcUtils.class);

    public static Map<String, Object> mapRow(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < count; ++i) {
                String name = rsmd.getColumnName(i + 1);
                map.put(name, rs.getObject(name));
            }
            return map;
        }
        catch (SQLException var6) {
            throw new JdbcException(var6);
        }
    }

    public static void closeResultSet(ResultSet rs) {
        block3: {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable var2) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Unexpected exception on closing JDBC ResultSet", var2);
                }
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        block3: {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable var2) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Unexpected exception on closing JDBC Statement", var2);
                }
            }
        }
    }

    public static void closeConnection(Connection conn) {
        block3: {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable var2) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Unexpected exception on closing JDBC Connection", var2);
                }
            }
        }
    }
}

