/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.Date;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;

public class DateTimeUtils {
    private static final String DEFAULT_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<DateFormat> TL_DATETIME_FORMATTER = DateTimeUtils.getThreadLocalDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final ThreadLocal<DateFormat> TL_DATE_FORMATTER = DateTimeUtils.getThreadLocalDateFormat("yyyy-MM-dd");
    private static final ThreadLocal<DateFormat> TL_TIME_FORMATTER = DateTimeUtils.getThreadLocalDateFormat("HH:mm:ss");
    private static final ThreadLocal<DateTimeFormatter> TL_LOCAL_DATETIME_FORMATTER = DateTimeUtils.getThreadLocalDateTimeFormatter("yyyy-MM-dd HH:mm:ss");
    private static final ThreadLocal<DateTimeFormatter> TL_LOCAL_DATE_FORMATTER = DateTimeUtils.getThreadLocalDateTimeFormatter("yyyy-MM-dd");
    private static final ThreadLocal<DateTimeFormatter> TL_LOCAL_TIME_FORMATTER = DateTimeUtils.getThreadLocalDateTimeFormatter("HH:mm:ss");
    private static final ThreadLocal<DateTimeFormatter> TL_LOCAL_HOUR_MINUTE_FORMATTER = DateTimeUtils.getThreadLocalDateTimeFormatter("HH:mm");
    private static final ThreadLocal<DateTimeFormatter> TL_DATE_SERIAL_NUMBER_FORMATTER = DateTimeUtils.getThreadLocalDateTimeFormatter("yyyyMMdd");
    private static final ThreadLocal<DateTimeFormatter> TL_DATETIME_SERIAL_NUMBER_FORMATTER = DateTimeUtils.getThreadLocalDateTimeFormatter("yyyyMMddHHmmss");

    public static String getDateTimeSerialNumber(LocalDateTime dateTime) {
        return dateTime.format(TL_DATETIME_SERIAL_NUMBER_FORMATTER.get());
    }

    public static String getDateSerialNumber(LocalDate date) {
        return date.format(TL_DATE_SERIAL_NUMBER_FORMATTER.get());
    }

    public static String getDateSerialNumber(LocalDateTime dateTime) {
        return dateTime.format(TL_DATE_SERIAL_NUMBER_FORMATTER.get());
    }

    public static String formatLocalDateTime(LocalDateTime dateTime, String pattern) {
        if (dateTime == null) {
            return null;
        }
        return StringUtils.isEmpty(pattern) ? DateTimeUtils.formatLocalDateTime(dateTime) : dateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatLocalDateTime(LocalDateTime dateTime) {
        return dateTime == null ? null : dateTime.format(TL_LOCAL_DATETIME_FORMATTER.get());
    }

    public static String formatDateTime(Date dateTime) {
        return dateTime == null ? null : TL_DATETIME_FORMATTER.get().format(dateTime);
    }

    public static String formatTime(Date Time2) {
        return Time2 == null ? null : TL_TIME_FORMATTER.get().format(Time2);
    }

    public static String formatLocalDate(LocalDate date, String pattern) {
        if (date == null) {
            return null;
        }
        return StringUtils.isEmpty(pattern) ? DateTimeUtils.formatLocalDate(date) : date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatLocalDate(LocalDate date) {
        return date == null ? null : date.format(TL_LOCAL_DATE_FORMATTER.get());
    }

    @Deprecated
    public static String formatDate(Date date) {
        return date == null ? null : TL_DATE_FORMATTER.get().format(date);
    }

    public static String formatLocalTime(LocalTime time) {
        return time == null ? null : TL_LOCAL_TIME_FORMATTER.get().format(time);
    }

    @Deprecated
    public static Date parseDate(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        String tempSource = DateTimeUtils.getStandardDateText(source);
        try {
            return TL_DATETIME_FORMATTER.get().parse(tempSource);
        }
        catch (ParseException var5) {
            if (StringUtils.contains(tempSource, ".")) {
                try {
                    int qty = tempSource.length() - (tempSource.lastIndexOf(".") + 1);
                    if (qty > 0) {
                        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss." + StringUtils.repeat("S", qty)).parse(tempSource);
                    }
                }
                catch (ParseException qty) {
                    // empty catch block
                }
            }
            try {
                return TL_DATE_FORMATTER.get().parse(tempSource);
            }
            catch (ParseException var3) {
                throw new ConvertFailedException(String.class, Date.class, source);
            }
        }
    }

    public static LocalDate parseLocalDate(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        String tempSource = DateTimeUtils.getStandardDateText(source);
        try {
            return LocalDate.parse(tempSource, TL_LOCAL_DATE_FORMATTER.get());
        }
        catch (DateTimeParseException var7) {
            try {
                return LocalDateTime.parse(tempSource, TL_LOCAL_DATETIME_FORMATTER.get()).toLocalDate();
            }
            catch (DateTimeParseException var6) {
                if (StringUtils.contains(tempSource, ".")) {
                    try {
                        int qty = tempSource.length() - (tempSource.lastIndexOf(".") + 1);
                        if (qty > 0) {
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss." + StringUtils.repeat("S", qty));
                            return LocalDateTime.parse(tempSource, formatter).toLocalDate();
                        }
                    }
                    catch (Exception qty) {
                        // empty catch block
                    }
                }
                try {
                    return LocalDate.parse(tempSource, TL_DATE_SERIAL_NUMBER_FORMATTER.get());
                }
                catch (DateTimeParseException var4) {
                    throw new ConvertFailedException(String.class, LocalDate.class, source);
                }
            }
        }
    }

    public static LocalDateTime parseLocalDateTime(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        String tempSource = DateTimeUtils.getStandardDateText(source);
        try {
            return LocalDateTime.parse(tempSource, TL_LOCAL_DATETIME_FORMATTER.get());
        }
        catch (DateTimeParseException var6) {
            try {
                return LocalDate.parse(tempSource, TL_LOCAL_DATE_FORMATTER.get()).atStartOfDay();
            }
            catch (DateTimeParseException var5) {
                if (StringUtils.contains(tempSource, ".")) {
                    try {
                        int qty = tempSource.length() - (tempSource.lastIndexOf(".") + 1);
                        if (qty > 0) {
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss." + StringUtils.repeat("S", qty));
                            return LocalDateTime.parse(tempSource, formatter);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new ConvertFailedException(String.class, LocalDateTime.class, source);
            }
        }
    }

    public static LocalTime parseLocalTime(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        try {
            return LocalTime.parse(source, TL_LOCAL_TIME_FORMATTER.get());
        }
        catch (DateTimeParseException var6) {
            try {
                return LocalTime.parse(source, TL_LOCAL_HOUR_MINUTE_FORMATTER.get());
            }
            catch (DateTimeParseException var5) {
                try {
                    return LocalDateTime.parse(source, TL_LOCAL_DATETIME_FORMATTER.get()).toLocalTime();
                }
                catch (DateTimeParseException var4) {
                    if (StringUtils.contains(source, ".")) {
                        try {
                            int qty = source.length() - (source.lastIndexOf(".") + 1);
                            if (qty > 0) {
                                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss." + StringUtils.repeat("S", qty));
                                return LocalDateTime.parse(source, formatter).toLocalTime();
                            }
                        }
                        catch (DateTimeParseException dateTimeParseException) {
                            // empty catch block
                        }
                    }
                    throw new ConvertFailedException(String.class, LocalTime.class, source);
                }
            }
        }
    }

    public static long getDurationInMilliseconds(Temporal start, Temporal end) {
        return ConvertUtils.convert(end, Long.class) - ConvertUtils.convert(start, Long.class);
    }

    public static <T> T addDay(T time, int day) {
        return (T)ConvertUtils.convert(new Date(ConvertUtils.convert(time, Date.class).getTime() + (long)(86400000 * day)), time.getClass());
    }

    public static LocalDateTime plusYears(LocalDateTime time, Long years) {
        return null != time && null != years ? time.plusYears(years) : null;
    }

    public static LocalDateTime plusMonths(LocalDateTime time, Long months) {
        return null != time && null != months ? time.plusMonths(months) : null;
    }

    public static LocalDateTime plusWeeks(LocalDateTime time, Long weeks) {
        return null != time && null != weeks ? time.plusWeeks(weeks) : null;
    }

    public static LocalDateTime plusDays(LocalDateTime time, Long days) {
        return null != time && null != days ? time.plusDays(days) : null;
    }

    public static LocalDateTime plusHours(LocalDateTime time, Long hours) {
        return null != time && null != hours ? time.plusHours(hours) : null;
    }

    public static LocalDateTime plusMinutes(LocalDateTime time, Long minutes) {
        return null != time && null != minutes ? time.plusMinutes(minutes) : null;
    }

    public static LocalDate plusYears(LocalDate date, Long years) {
        return null != date && null != years ? date.plusYears(years) : null;
    }

    public static LocalDate plusMonths(LocalDate date, Long months) {
        return null != date && null != months ? date.plusMonths(months) : null;
    }

    public static LocalDate plusWeeks(LocalDate date, Long weeks) {
        return null != date && null != weeks ? date.plusWeeks(weeks) : null;
    }

    public static LocalDate plusDays(LocalDate date, Long days) {
        return null != date && null != days ? date.plusDays(days) : null;
    }

    public static boolean isBefore(LocalDate d1, LocalDate d2) {
        return d1 != null && d2 != null && d1.isBefore(d2);
    }

    public static boolean isAfter(LocalDate d1, LocalDate d2) {
        return d1 != null && d2 != null && d1.isAfter(d2);
    }

    public static boolean isEqual(LocalDate d1, LocalDate d2) {
        if (d1 != null && d2 != null) {
            return d1.isEqual(d2);
        }
        return d1 == null && d2 == null;
    }

    public static boolean isBefore(LocalDateTime t1, LocalDateTime t2) {
        return t1 != null && t2 != null && t1.isBefore(t2);
    }

    public static boolean isAfter(LocalDateTime t1, LocalDateTime t2) {
        return t1 != null && t2 != null && t1.isAfter(t2);
    }

    public static boolean isEqual(LocalDateTime t1, LocalDateTime t2) {
        if (t1 != null && t2 != null) {
            return t1.isEqual(t2);
        }
        return t1 == null && t2 == null;
    }

    public static LocalDateTime max(LocalDateTime t1, LocalDateTime t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return t1.isAfter(t2) ? t1 : t2;
    }

    public static LocalDateTime min(LocalDateTime t1, LocalDateTime t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return t1.isBefore(t2) ? t1 : t2;
    }

    public static boolean isLocalDate(String text) {
        try {
            DateTimeUtils.parseLocalDate(text);
            return true;
        }
        catch (ConvertFailedException var2) {
            return false;
        }
    }

    public static boolean isLocalDateTime(String text) {
        try {
            DateTimeUtils.parseLocalDateTime(text);
            return true;
        }
        catch (ConvertFailedException var2) {
            return false;
        }
    }

    private static String getStandardDateText(String dateText) {
        StringBuilder sb = new StringBuilder();
        int zoneIndex = Math.max(dateText.lastIndexOf("-"), dateText.lastIndexOf("+"));
        if (zoneIndex >= "yyyy-M-d H:m:s".length()) {
            dateText = dateText.substring(0, zoneIndex).trim();
        }
        String[] values = dateText.split("(-|/|\u5e74|\u6708|\u65e5|:|T|t|\\.|\\s)");
        int j = values.length;
        for (int i = 0; i < j; ++i) {
            String value = values[i];
            if (i == 0) {
                sb.append(value);
                continue;
            }
            if (i <= 2) {
                sb.append("-").append(StringUtils.leftPad(value, 2));
                continue;
            }
            if (i == 3) {
                sb.append(" ").append(StringUtils.leftPad(value, 2));
                continue;
            }
            if (i <= 5) {
                sb.append(":").append(StringUtils.leftPad(value, 2));
                continue;
            }
            if (i != 6) continue;
            sb.append(".").append(value);
        }
        if (sb.length() == "yyyy-MM-dd HH:mm".length()) {
            sb.append(":00");
        }
        return sb.toString();
    }

    private static ThreadLocal<DateFormat> getThreadLocalDateFormat(String pattern) {
        return ThreadLocal.withInitial(() -> new SimpleDateFormat(pattern));
    }

    private static ThreadLocal<DateTimeFormatter> getThreadLocalDateTimeFormatter(String pattern) {
        return ThreadLocal.withInitial(() -> DateTimeFormatter.ofPattern(pattern));
    }
}

