/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.ConverterFactory;
import net.sinodawn.framework.converter.IdentityConverter;
import net.sinodawn.framework.converter.array.PrimitiveByteArrayToBlobConverter;
import net.sinodawn.framework.converter.array.PrimitiveByteArrayToStringConverter;
import net.sinodawn.framework.converter.array.PrimitiveCharacterArrayToClobConverter;
import net.sinodawn.framework.converter.array.PrimitiveToWrapperArrayConverter;
import net.sinodawn.framework.converter.array.WrapperToPrimitiveArrayConverter;
import net.sinodawn.framework.converter.bool.BooleanToNumberConverterFactory;
import net.sinodawn.framework.converter.bool.BooleanToStringConverter;
import net.sinodawn.framework.converter.collection.CollectionToStringConverter;
import net.sinodawn.framework.converter.collection.MapToJSONObjectConverter;
import net.sinodawn.framework.converter.collection.MapToStringConverter;
import net.sinodawn.framework.converter.date.DateToJSR310ConverterFactory;
import net.sinodawn.framework.converter.date.DateToStringConverterFactory;
import net.sinodawn.framework.converter.date.JSR310ToDateGenericConverter;
import net.sinodawn.framework.converter.date.JSR310ToJSR310ConverterFactory;
import net.sinodawn.framework.converter.date.JSR310ToLongGenericConverter;
import net.sinodawn.framework.converter.date.JSR310ToStringGenericConverter;
import net.sinodawn.framework.converter.date.LongToJSR310ConverterFactory;
import net.sinodawn.framework.converter.exception.ConverterNotFoundException;
import net.sinodawn.framework.converter.json.JSONObjectToMapConverter;
import net.sinodawn.framework.converter.number.NumberToBooleanConverter;
import net.sinodawn.framework.converter.number.NumberToNumberConverterFactory;
import net.sinodawn.framework.converter.number.NumberToStringConverter;
import net.sinodawn.framework.converter.properties.PropertiesToStringConverter;
import net.sinodawn.framework.converter.reader.ReaderToStringConverter;
import net.sinodawn.framework.converter.sql.BlobToPrimitiveByteArrayConverter;
import net.sinodawn.framework.converter.sql.BlobToStringConverter;
import net.sinodawn.framework.converter.sql.ClobToPrimitiveCharacterArrayConverter;
import net.sinodawn.framework.converter.sql.ClobToStringConverter;
import net.sinodawn.framework.converter.string.StringToBlobConverter;
import net.sinodawn.framework.converter.string.StringToBooleanConverter;
import net.sinodawn.framework.converter.string.StringToClobConverter;
import net.sinodawn.framework.converter.string.StringToDateConverterFactory;
import net.sinodawn.framework.converter.string.StringToEnumConverterFactory;
import net.sinodawn.framework.converter.string.StringToInputStreamConverterFactory;
import net.sinodawn.framework.converter.string.StringToJSR310ConverterFactory;
import net.sinodawn.framework.converter.string.StringToNumberConverterFactory;
import net.sinodawn.framework.converter.string.StringToPropertiesConverter;
import net.sinodawn.framework.converter.string.StringToReaderConverterFactory;
import net.sinodawn.framework.utils.ClassUtils;

public class ConvertUtils {
    private static final List<Converter<?, ?>> CONVERTERS = new ArrayList();
    private static List<ConverterFactory<?, ?>> CONVERTER_FACTORY = new ArrayList();
    private static final Map<String, Converter<?, ?>> CONVERTER_CACHE;

    public static <T, S> boolean canConvert(S source, Class<T> targetType) {
        if (source == null) {
            return true;
        }
        Class<?> sourceType = source.getClass();
        Converter<?, T> converter = ConvertUtils.getConverterIfPresent(sourceType, targetType);
        if (converter == null) {
            return false;
        }
        try {
            converter.convert(source);
            return true;
        }
        catch (Exception var5) {
            return false;
        }
    }

    public static <T, S> T convert(S source, Class<T> targetType) {
        return (T)ConvertUtils.convert(source, targetType, ClassUtils.getPrimitiveDefaultValue(targetType));
    }

    public static <T, S> T convert(S source, Class<T> targetType, T defaultValue) {
        if (source == null) {
            return defaultValue;
        }
        Class<?> sourceType = source.getClass();
        Converter<?, T> converter = ConvertUtils.getConverterIfPresent(sourceType, targetType);
        if (converter != null) {
            T value = converter.convert(source);
            return value == null ? defaultValue : value;
        }
        throw new ConverterNotFoundException(sourceType, targetType);
    }

    private static <T, S> Converter<S, T> getConverterIfPresent(Class<S> sourceType, Class<T> targetType) {
        Class<?> resolvedSourceType = ClassUtils.resolvePrimitiveIfNecessary(sourceType);
        Class<?> resolvedTargetType = ClassUtils.resolvePrimitiveIfNecessary(targetType);
        String cacheKey = resolvedSourceType.getName() + "-" + resolvedTargetType.getName();
        if (!CONVERTER_CACHE.containsKey(cacheKey)) {
            ConverterFactory<?, ?> converterFactory;
            if (Object.class.equals(resolvedTargetType) || resolvedTargetType.isAssignableFrom(resolvedSourceType)) {
                return new IdentityConverter();
            }
            Converter<?, Object> converter = ConvertUtils.getConverter(resolvedSourceType, resolvedTargetType);
            if (converter == null && (converterFactory = ConvertUtils.getConverterFactory(resolvedSourceType, resolvedTargetType)) != null) {
                converter = converterFactory.getConverter(targetType);
            }
            CONVERTER_CACHE.put(cacheKey, converter);
        }
        return CONVERTER_CACHE.get(cacheKey);
    }

    private static <T, S> Converter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
        return CONVERTERS.parallelStream().filter(c -> c.canConvert(sourceType, targetType)).findFirst().orElse(null);
    }

    private static <T, S> ConverterFactory<S, T> getConverterFactory(Class<S> sourceType, Class<T> targetType) {
        return CONVERTER_FACTORY.parallelStream().filter(f -> f.canConvert(sourceType, targetType)).findFirst().orElse(null);
    }

    static {
        CONVERTERS.add(NumberToStringConverter.INSTANCE);
        CONVERTERS.add(DateToStringConverterFactory.TimeToStringConverter.INSTANCE);
        CONVERTERS.add(DateToStringConverterFactory.DateToStringConverter.INSTANCE);
        CONVERTERS.add(JSR310ToStringGenericConverter.LocalTimeToStringConverter.INSTANCE);
        CONVERTERS.add(JSR310ToStringGenericConverter.LocalDateToStringConverter.INSTANCE);
        CONVERTERS.add(JSR310ToStringGenericConverter.LocalDateTimeToStringConverter.INSTANCE);
        CONVERTERS.add(StringToBlobConverter.INSTANCE);
        CONVERTERS.add(BlobToStringConverter.INSTANCE);
        CONVERTERS.add(StringToClobConverter.INSTANCE);
        CONVERTERS.add(ClobToStringConverter.INSTANCE);
        CONVERTERS.add(StringToPropertiesConverter.INSTANCE);
        CONVERTERS.add(PropertiesToStringConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalDateTimeToSqlDateConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalDateTimeToSqlTimeConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalDateTimeToSqlTimestampConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalDateTimeToDateConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalDateToSqlDateConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalDateToSqlTimeConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalDateToSqlTimestampConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalDateToDateConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalTimeToSqlDateConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalTimeToSqlTimeConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalTimeToSqlTimestampConverter.INSTANCE);
        CONVERTERS.add(JSR310ToDateGenericConverter.LocalTimeToDateConverter.INSTANCE);
        CONVERTERS.add(JSR310ToLongGenericConverter.LocalDateTimeToLongConverter.INSTANCE);
        CONVERTERS.add(JSR310ToLongGenericConverter.LocalDateToLongConverter.INSTANCE);
        CONVERTERS.add(JSR310ToLongGenericConverter.LocalTimeToLongConverter.INSTANCE);
        CONVERTERS.add(StringToBooleanConverter.INSTANCE);
        CONVERTERS.add(BooleanToStringConverter.INSTANCE);
        CONVERTERS.add(NumberToBooleanConverter.INSTANCE);
        CONVERTERS.add(PrimitiveToWrapperArrayConverter.PrimitiveToWrapperBooleanArrayConverter.INSTANCE);
        CONVERTERS.add(WrapperToPrimitiveArrayConverter.WrapperToPrimitiveBooleanArrayConverter.INSTANCE);
        CONVERTERS.add(PrimitiveToWrapperArrayConverter.PrimitiveToWrapperByteArrayConverter.INSTANCE);
        CONVERTERS.add(WrapperToPrimitiveArrayConverter.WrapperToPrimitiveByteArrayConverter.INSTANCE);
        CONVERTERS.add(PrimitiveToWrapperArrayConverter.PrimitiveToWrapperCharacterArrayConverter.INSTANCE);
        CONVERTERS.add(WrapperToPrimitiveArrayConverter.WrapperToPrimitiveCharacterArrayConverter.INSTANCE);
        CONVERTERS.add(PrimitiveToWrapperArrayConverter.PrimitiveToWrapperDoubleArrayConverter.INSTANCE);
        CONVERTERS.add(WrapperToPrimitiveArrayConverter.WrapperToPrimitiveDoubleArrayConverter.INSTANCE);
        CONVERTERS.add(PrimitiveToWrapperArrayConverter.PrimitiveToWrapperFloatArrayConverter.INSTANCE);
        CONVERTERS.add(WrapperToPrimitiveArrayConverter.WrapperToPrimitiveFloatArrayConverter.INSTANCE);
        CONVERTERS.add(PrimitiveToWrapperArrayConverter.PrimitiveToWrapperIntegerArrayConverter.INSTANCE);
        CONVERTERS.add(WrapperToPrimitiveArrayConverter.WrapperToPrimitiveIntegerArrayConverter.INSTANCE);
        CONVERTERS.add(PrimitiveToWrapperArrayConverter.PrimitiveToWrapperLongArrayConverter.INSTANCE);
        CONVERTERS.add(WrapperToPrimitiveArrayConverter.WrapperToPrimitiveLongArrayConverter.INSTANCE);
        CONVERTERS.add(PrimitiveToWrapperArrayConverter.PrimitiveToWrapperShortArrayConverter.INSTANCE);
        CONVERTERS.add(WrapperToPrimitiveArrayConverter.WrapperToPrimitiveShortArrayConverter.INSTANCE);
        CONVERTERS.add(ReaderToStringConverter.INSTANCE);
        CONVERTERS.add(BlobToPrimitiveByteArrayConverter.INSTANCE);
        CONVERTERS.add(PrimitiveByteArrayToBlobConverter.INSTANCE);
        CONVERTERS.add(PrimitiveByteArrayToStringConverter.INSTANCE);
        CONVERTERS.add(ClobToPrimitiveCharacterArrayConverter.INSTANCE);
        CONVERTERS.add(PrimitiveCharacterArrayToClobConverter.INSTANCE);
        CONVERTERS.add(CollectionToStringConverter.INSTANCE);
        CONVERTERS.add(MapToStringConverter.INSTANCE);
        CONVERTERS.add(JSONObjectToMapConverter.INSTANCE);
        CONVERTERS.add(MapToJSONObjectConverter.INSTANCE);
        CONVERTER_FACTORY = new ArrayList();
        CONVERTER_FACTORY.add(StringToDateConverterFactory.INSTANCE);
        CONVERTER_FACTORY.add(StringToEnumConverterFactory.INSTANCE);
        CONVERTER_FACTORY.add(StringToJSR310ConverterFactory.INSTANCE);
        CONVERTER_FACTORY.add(StringToReaderConverterFactory.INSTANCE);
        CONVERTER_FACTORY.add(StringToNumberConverterFactory.INSTANCE);
        CONVERTER_FACTORY.add(NumberToNumberConverterFactory.INSTANCE);
        CONVERTER_FACTORY.add(BooleanToNumberConverterFactory.INSTANCE);
        CONVERTER_FACTORY.add(DateToJSR310ConverterFactory.INSTANCE);
        CONVERTER_FACTORY.add(LongToJSR310ConverterFactory.INSTANCE);
        CONVERTER_FACTORY.add(StringToInputStreamConverterFactory.INSTANCE);
        CONVERTER_FACTORY.add(JSR310ToJSR310ConverterFactory.INSTANCE);
        CONVERTER_CACHE = new HashMap();
    }
}

