/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;

public abstract class CollectionUtils {
    public static <T> boolean isEmpty(Collection<T> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static final <T> List<T> union(Collection<T> first, Collection<T> second) {
        ArrayList<T> unionList = new ArrayList<T>(first);
        unionList.addAll(second);
        return unionList.stream().distinct().collect(Collectors.toList());
    }

    public static final <T> List<T> intersection(Collection<T> first, Collection<T> second) {
        return first.stream().filter(f -> second.contains(f)).distinct().collect(Collectors.toList());
    }

    public static final <T> List<T> disjunction(Collection<T> first, Collection<T> second) {
        List<T> disjunctionList = CollectionUtils.subtract(first, second);
        disjunctionList.addAll(CollectionUtils.subtract(second, first));
        return disjunctionList;
    }

    public static final <T> List<T> subtract(Collection<T> first, Collection<T> second) {
        return first.stream().filter(f -> !second.contains(f)).distinct().collect(Collectors.toList());
    }

    public static final boolean containsIgnoreCase(Collection<String> collection, String value) {
        if (collection.isEmpty()) {
            return false;
        }
        for (String v : collection) {
            if (!(v == null ? value == null : v.equalsIgnoreCase(value))) continue;
            return true;
        }
        return false;
    }

    public static final Object getFirstValue(Map<?, ?> map) {
        return map != null && !map.isEmpty() ? map.values().toArray()[0] : null;
    }

    public static final Object getFirstValue(Collection<?> collection) {
        return collection != null && !collection.isEmpty() ? collection.iterator().next() : null;
    }

    public static final boolean containsKeyIgnorecase(Map<String, ?> map, String key) {
        return map != null && !map.isEmpty() ? map.keySet().stream().anyMatch(k -> k.equalsIgnoreCase(key)) : false;
    }

    public static final Object getValueIgnorecase(Map<String, ?> map, String key) {
        if (map != null && !map.isEmpty()) {
            String actualKey = map.keySet().stream().filter(k -> k.equalsIgnoreCase(key)).findFirst().orElse(null);
            return StringUtils.isEmpty(actualKey) ? null : map.get(actualKey);
        }
        return null;
    }

    public static <S, T> List<T> convert(List<S> itemList, Class<T> type) {
        if (itemList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        Class<?> sourceType = itemList.get(0).getClass();
        return type.isAssignableFrom(sourceType) ? itemList.stream().collect(Collectors.toList()) : itemList.stream().map(s -> ConvertUtils.convert(s, type)).collect(Collectors.toList());
    }

    public static <T> List<T> distinct(List<T> itemList) {
        return itemList.stream().distinct().collect(Collectors.toList());
    }

    public static void lowerCaseKey(Map<String, Object> map) {
        new HashSet<String>(map.keySet()).forEach(k -> {
            String lowerCaseKey = k.toLowerCase();
            if (!k.equals(lowerCaseKey)) {
                Object value = map.get(k);
                map.remove(k);
                map.put(lowerCaseKey, value);
            }
        });
    }

    public static void upperCaseKey(Map<String, Object> map) {
        new HashSet<String>(map.keySet()).forEach(k -> {
            String upperCaseKey = k.toUpperCase();
            if (!k.equals(upperCaseKey)) {
                Object value = map.get(k);
                map.remove(k);
                map.put(upperCaseKey, value);
            }
        });
    }

    public static final <K, V> void putIfNotBlank(Map<K, V> map, K key, V value) {
        if (value != null && !StringUtils.isBlank(value.toString())) {
            map.put(key, value);
        }
    }

    public static final <T> void sort(List<T> list, Comparator<T> comparator) {
        int size = list.size();
        if (size > 1) {
            boolean minFound;
            ArrayList<T> sortedList = new ArrayList<T>();
            block0: do {
                if (sortedList.size() >= size) {
                    list.addAll(sortedList);
                    return;
                }
                int innerSize = list.size();
                minFound = true;
                for (int i = 0; i < innerSize; ++i) {
                    T item = list.get(i);
                    minFound = true;
                    for (int j = 0; j < innerSize; ++j) {
                        T another;
                        if (i == j || comparator.compare(item, another = list.get(j)) <= 0) continue;
                        minFound = false;
                        break;
                    }
                    if (!minFound) continue;
                    sortedList.add(item);
                    list.remove(i);
                    continue block0;
                }
            } while (minFound);
            throw new UnexpectedException("SINO.EXCEPTION.ORDER_INFINITE_LOOP");
        }
    }

    public static final <T> List<T> emptyList() {
        return new ArrayList();
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return new HashMap();
    }
}

