/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.sinodawn.framework.cache.memory.MemoryCacheManager;
import net.sinodawn.framework.data.TypeValuePair;
import net.sinodawn.framework.exception.ClassInstantiationException;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;

public class ClassUtils {
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new IdentityHashMap(8);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new IdentityHashMap(8);

    public static <T> T newInstance(Class<T> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        boolean seen = false;
        Constructor<?> best = null;
        Comparator<Constructor> comparator = Comparator.comparingInt(Constructor::getParameterCount);
        for (Constructor<?> constructor1 : constructors) {
            if (seen && comparator.compare(constructor1, best) >= 0) continue;
            seen = true;
            best = constructor1;
        }
        Constructor constructor = (Constructor)(seen ? Optional.of(best) : Optional.empty()).get();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] parameterDefaultValues = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            parameterDefaultValues[i] = ClassUtils.isPrimitiveType(parameterType) ? ClassUtils.getPrimitiveDefaultValue(parameterType) : null;
        }
        try {
            return constructor.newInstance(parameterDefaultValues);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException var7) {
            throw new ClassInstantiationException(clazz, (Throwable)var7);
        }
    }

    @SafeVarargs
    public static <T> T newInstance(Class<T> clazz, TypeValuePair<?> ... typeValuePairs) {
        if (typeValuePairs != null && typeValuePairs.length != 0) {
            Class[] parameterTypes = new Class[typeValuePairs.length];
            Object[] parameterValues = new Object[typeValuePairs.length];
            for (int i = 0; i < typeValuePairs.length; ++i) {
                parameterTypes[i] = (Class)typeValuePairs[i].getFirst();
                parameterValues[i] = typeValuePairs[i].getSecond();
            }
            try {
                Constructor<T> constructor = clazz.getConstructor(parameterTypes);
                return constructor.newInstance(parameterValues);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException var5) {
                throw new ClassInstantiationException(clazz, (Throwable)var5);
            }
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException var6) {
            throw new ClassInstantiationException(clazz, (Throwable)var6);
        }
    }

    public static Object getPrimitiveDefaultValue(Class<?> primitiveType) {
        if (Boolean.TYPE == primitiveType) {
            return false;
        }
        if (Byte.TYPE == primitiveType) {
            return Character.valueOf('0');
        }
        if (Character.TYPE == primitiveType) {
            return Character.valueOf('0');
        }
        if (Short.TYPE == primitiveType) {
            return Short.parseShort("0");
        }
        if (Integer.TYPE == primitiveType) {
            return 0;
        }
        if (Float.TYPE == primitiveType) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE == primitiveType) {
            return 0.0;
        }
        return Long.TYPE == primitiveType ? Long.valueOf(0L) : null;
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> clazz) {
        return clazz.isPrimitive() && clazz != Void.TYPE ? ClassUtils.getWrapperType(clazz) : clazz;
    }

    public static Class<?> getWrapperType(Class<?> primitiveType) {
        return primitiveTypeToWrapperMap.get(primitiveType);
    }

    public static <T> Constructor<T> getConstructorIfAvailable(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException var3) {
            return null;
        }
    }

    public static Class<?> getRawType(Class<?> clazz) {
        if (clazz.getName().startsWith("com.sun.proxy.$Proxy")) {
            return clazz.getInterfaces()[0];
        }
        while (clazz.getName().contains("CGLIB$")) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static boolean isCglibProxyClass(Class<?> clazz) {
        return clazz != null && clazz.getName().contains("CGLIB$");
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        return primitiveTypeToWrapperMap.containsKey(clazz);
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return primitiveWrapperTypeMap.containsKey(clazz);
    }

    public static <T> Class<T> getClass(String className) {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = contextCL == null ? ClassLoader.getSystemClassLoader() : contextCL;
        try {
            String abbreviation = ClassUtils.getClassAbbreviation(className);
            return className.equals(abbreviation) ? Class.forName(ClassUtils.getFullyQualifiedName(className), false, loader) : Class.forName("[" + abbreviation, false, loader).getComponentType();
        }
        catch (ClassNotFoundException var4) {
            throw new UnexpectedException(var4);
        }
    }

    public static boolean isSimpleType(Class<?> type) {
        return ClassUtils.isPrimitiveType(type) || ClassUtils.isWrapperType(type) || CharSequence.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || Temporal.class.isAssignableFrom(type) || Object.class == type;
    }

    public static <T> Class<T> getSinoClass(String simpleName) {
        return ClassUtils.getAllClasses("net.sinodawn").stream().filter(c -> c.getSimpleName().equalsIgnoreCase(simpleName)).findFirst().orElse(null);
    }

    public static List<Class<?>> getPredicatedClasses(String packageName, Predicate<Class<?>> classTester) {
        String packageDirName = StringUtils.removeStart(StringUtils.removeEnd(StringUtils.replace(packageName, ".", "/"), "/"), "/");
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        try {
            Resource[] resources = resourcePatternResolver.getResources("classpath*:" + packageDirName + "/**/*.class");
            ArrayList list = new ArrayList();
            int var8 = resources.length;
            for (Resource r : resources) {
                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(r);
                Class clazz = ClassUtils.getClass(metadataReader.getClassMetadata().getClassName());
                if (!classTester.test(clazz)) continue;
                list.add(clazz);
            }
            return list;
        }
        catch (IOException var13) {
            throw new UnexpectedException(var13);
        }
    }

    public static List<Class<?>> getAllClasses(String packageName) {
        ArrayList classList = (ArrayList)MemoryCacheManager.get("classesUnderPackage:" + packageName);
        if (classList == null) {
            classList = new ArrayList();
            String packageDirName = StringUtils.removeStart(StringUtils.removeEnd(StringUtils.replace(packageName, ".", "/"), "/"), "/");
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            try {
                Resource[] resources = resourcePatternResolver.getResources("classpath*:" + packageDirName + "/**/*.class");
                int var7 = resources.length;
                for (Resource r : resources) {
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(r);
                    if ("net.sinodawn.framework.utils.EncodingUtils$BytesEncodingDetect".equals(metadataReader.getClassMetadata().getClassName())) continue;
                    Class clazz = ClassUtils.getClass(metadataReader.getClassMetadata().getClassName());
                    classList.add(clazz);
                }
            }
            catch (IOException var12) {
                throw new UnexpectedException(var12);
            }
            MemoryCacheManager.put("classesUnderPackage:" + packageName, Collections.unmodifiableList(classList));
        }
        return classList;
    }

    private static String getFullyQualifiedName(String className) {
        if (!className.endsWith("[]")) {
            return className;
        }
        StringBuilder sb = new StringBuilder();
        String name = className;
        while (name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
            sb.append("[");
        }
        String abbreviation = ClassUtils.getClassAbbreviation(name);
        if (StringUtils.isEmpty(abbreviation)) {
            sb.append("L").append(name).append(";");
        } else {
            sb.append(abbreviation);
        }
        return sb.toString();
    }

    private static String getClassAbbreviation(String className) {
        if ("int".equals(className)) {
            return "I";
        }
        if ("long".equals(className)) {
            return "J";
        }
        if ("double".equals(className)) {
            return "D";
        }
        if ("float".equals(className)) {
            return "F";
        }
        if ("char".equals(className)) {
            return "C";
        }
        if ("short".equals(className)) {
            return "S";
        }
        if ("boolean".equals(className)) {
            return "Z";
        }
        if ("byte".equals(className)) {
            return "B";
        }
        return "void".equals(className) ? "V" : className;
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        primitiveWrapperTypeMap.forEach((w, p) -> {
            Class var10000 = primitiveTypeToWrapperMap.put((Class<?>)p, (Class<?>)w);
        });
    }
}

