/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletRequest;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyEvent;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.beans.BeanPropertyListener;
import net.sinodawn.framework.support.domain.BaseData;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;

public abstract class BeanUtils {
    public static <T> T getPropertyListenerProxy(T bean) {
        return bean == null ? null : (T)BeanPropertyHelper.getPropertyListenerProxy(bean, false);
    }

    public static <T> T getPropertyListenerProxy(Class<T> clazz) {
        T instance = ClassUtils.newInstance(clazz);
        return BeanPropertyHelper.getPropertyListenerProxy(instance, true);
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtils.copyProperties(source, target, CopyConfig.DEFAULT, ignoreProperties);
    }

    public static void copyProperties(Object source, Object target, CopyConfig copyConfig, String ... ignoreProperties) {
        if (source != null && target != null) {
            if (copyConfig == null) {
                copyConfig = CopyConfig.DEFAULT;
            }
            Class<?> targetClass = ClassUtils.getRawType(target.getClass());
            Class<?> sourceClass = ClassUtils.getRawType(source.getClass());
            String resolvedSourcePrefix = Optional.ofNullable(copyConfig.getSourcePrefix()).orElse("");
            String resolvedSourceSuffix = Optional.ofNullable(copyConfig.getSourceSuffix()).orElse("");
            String resolvedTargetPrefix = Optional.ofNullable(copyConfig.getTargetPrefix()).orElse("");
            String resolvedTargetSuffix = Optional.ofNullable(copyConfig.getTargetSuffix()).orElse("");
            Stream<BeanPropertyDescriptor> stream = BeanPropertyHelper.getBeanPropertyDescriptorList(sourceClass).stream().filter(s -> (ignoreProperties == null || !ArrayUtils.containsIgnoreCase(ignoreProperties, s.getName())) && StringUtils.startsWith(s.getName(), resolvedSourcePrefix) && StringUtils.endsWith(s.getName(), resolvedSourceSuffix));
            if (BeanPropertyListener.class.isAssignableFrom(source.getClass())) {
                List<BeanPropertyEvent> propertyEventList = ((BeanPropertyListener)source).getChangedPropertyEventList();
                stream = stream.filter(p -> propertyEventList.stream().anyMatch(e -> p.getName().equalsIgnoreCase(e.getPropertyDescriptor().getName())));
            }
            stream.forEach(s -> {
                String key = StringUtils.removeEnd(StringUtils.removeStart(s.getName(), resolvedSourcePrefix), resolvedSourceSuffix);
                BeanPropertyDescriptor propertyDescriptor = BeanPropertyHelper.getBeanPropertyDescriptorList(targetClass).stream().filter(t -> StringUtils.startsWith(t.getName(), resolvedTargetPrefix) && StringUtils.endsWith(t.getName(), resolvedTargetSuffix) && key.equalsIgnoreCase(StringUtils.removeStart(StringUtils.removeEnd(t.getName(), resolvedTargetSuffix), resolvedTargetPrefix)) && t.getPropertyType().equals(s.getPropertyType())).findFirst().orElse(null);
                if (propertyDescriptor == null) {
                    if (Persistable.class.isAssignableFrom(targetClass)) {
                        Object sourceValue = ReflectionUtils.invokeMethod(s.getReadMethod(), source, new Object[0]);
                        ((Persistable)target).setExt$Item(key.toLowerCase(), ConvertUtils.convert(sourceValue, String.class));
                    }
                } else {
                    Object sourceValue = ReflectionUtils.invokeMethod(s.getReadMethod(), source, new Object[0]);
                    ReflectionUtils.invokeMethod(propertyDescriptor.getWriteMethod(), target, sourceValue);
                }
            });
            if (Persistable.class.isAssignableFrom(sourceClass)) {
                BeanUtils.copyProperties(((Persistable)source).getExt$(), target, copyConfig, ignoreProperties);
            }
        }
    }

    public static void copyProperties(ServletRequest source, Object target, String ... ignoreProperties) {
        if (source != null && target != null) {
            Stream<BeanPropertyDescriptor> stream = BeanPropertyHelper.getBeanPropertyDescriptorList(target.getClass()).stream().filter(t -> ignoreProperties == null || !ArrayUtils.containsIgnoreCase(ignoreProperties, t.getName()));
            stream.forEach(s -> {
                String propertyName = s.getName();
                String parameterValue = source.getParameter(propertyName);
                if (parameterValue != null) {
                    ReflectionUtils.invokeMethod(s.getWriteMethod(), target, ConvertUtils.convert(parameterValue, s.getPropertyType()));
                }
            });
        }
    }

    public static <V> void copyProperties(Map<String, V> source, Object target, String ... ignoreProperties) {
        BeanUtils.copyProperties(source, target, CopyConfig.DEFAULT, ignoreProperties);
    }

    public static <V> void copyProperties(Map<String, V> source, Object target, CopyConfig copyConfig, String ... ignoreProperties) {
        if (source != null && target != null && !source.isEmpty()) {
            if (copyConfig == null) {
                copyConfig = CopyConfig.DEFAULT;
            }
            String resolvedSourcePrefix = Optional.ofNullable(copyConfig.getSourcePrefix()).orElse("");
            String resolvedSourceSuffix = Optional.ofNullable(copyConfig.getSourceSuffix()).orElse("");
            String resolvedTargetPrefix = Optional.ofNullable(copyConfig.getTargetPrefix()).orElse("");
            String resolvedTargetSuffix = Optional.ofNullable(copyConfig.getTargetSuffix()).orElse("");
            List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(target.getClass());
            boolean isTargetPersistable = Persistable.class.isAssignableFrom(target.getClass());
            source.forEach((key1, value) -> {
                if (!ArrayUtils.contains(ignoreProperties, key1) && StringUtils.startsWith(key1, resolvedTargetPrefix) && StringUtils.endsWith(key1, resolvedTargetSuffix)) {
                    String key = StringUtils.removeEnd(StringUtils.removeStart(key1, resolvedSourcePrefix), resolvedSourceSuffix);
                    BeanPropertyDescriptor propertyDescriptor = propertyDescriptorList.stream().filter(p -> StringUtils.startsWith(p.getName(), resolvedTargetPrefix) && StringUtils.endsWith(p.getName(), resolvedTargetSuffix) && key.equalsIgnoreCase(StringUtils.removeStart(StringUtils.removeEnd(p.getName(), resolvedTargetSuffix), resolvedTargetPrefix))).findFirst().orElse(null);
                    if (propertyDescriptor != null) {
                        ReflectionUtils.invokeMethod(propertyDescriptor.getWriteMethod(), target, ConvertUtils.convert(value, propertyDescriptor.getPropertyType()));
                    } else if (isTargetPersistable) {
                        String resolvedKey = resolvedTargetPrefix + key + resolvedTargetSuffix;
                        ((Persistable)target).setExt$Item(resolvedKey.toLowerCase(), ConvertUtils.convert(value, String.class));
                    }
                }
            });
        }
    }

    public static <T> void emptyProperties(List<T> beans, String ... properties) {
        List<BeanPropertyDescriptor> propertyDescriptorList;
        if (!beans.isEmpty() && properties.length != 0 && !(propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(beans.get(0).getClass()).stream().filter(p -> ArrayUtils.contains(properties, p.getName())).collect(Collectors.toList())).isEmpty()) {
            for (Object bean : beans) {
                propertyDescriptorList.forEach(p -> ReflectionUtils.invokeMethod(p.getWriteMethod(), bean, new Object[]{null}));
            }
        }
    }

    public static <T> Map<String, Object> toMap(T bean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (bean == null) {
            return result;
        }
        Class<?> type = bean.getClass();
        BeanPropertyHelper.getBeanPropertyDescriptorList(type).forEach(p -> result.put(p.getName().toLowerCase(), ReflectionUtils.invokeMethod(p.getReadMethod(), bean, new Object[0])));
        return result;
    }

    public static <T> Map<String, Object> deeplyToMap(T bean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (bean == null) {
            return result;
        }
        Class<?> type = bean.getClass();
        BeanPropertyHelper.getBeanPropertyDescriptorList(type).stream().filter(p -> !Map.class.isAssignableFrom(p.getPropertyType())).forEach(p -> result.put(p.getName().toLowerCase(), ReflectionUtils.invokeMethod(p.getReadMethod(), bean, new Object[0])));
        BeanPropertyHelper.getBeanPropertyDescriptorList(type).stream().filter(p -> Map.class.isAssignableFrom(p.getPropertyType())).forEach(p -> ((Map)p.getPropertyValue(bean)).entrySet().forEach(e -> result.put(ObjectUtils.toString(((Map.Entry)e).getKey()), ((Map.Entry)e).getValue())));
        return result;
    }

    public static <T> boolean match(T item, Map<String, Object> map) {
        if (item == null) {
            return false;
        }
        if (map.isEmpty()) {
            return true;
        }
        Class<?> clazz = item.getClass();
        for (Map.Entry<String, Object> stringObjectEntry : map.entrySet()) {
            Field field = ReflectionUtils.findField(clazz, stringObjectEntry.getKey());
            Object value = ConvertUtils.convert(stringObjectEntry.getValue(), field.getType());
            if (ObjectUtils.equals(value, ReflectionUtils.getFieldValue(item, stringObjectEntry.getKey()))) continue;
            Class<?> type = item.getClass();
            if (!BaseData.class.isAssignableFrom(type)) {
                return false;
            }
            BaseData data = (BaseData)item;
            if (ObjectUtils.equals(stringObjectEntry.getValue(), data.getExt$().get(stringObjectEntry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isEmpty(T item) {
        BeanPropertyDescriptor bpd;
        if (item == null) {
            return true;
        }
        Class<?> type = item.getClass();
        if (BaseData.class.isAssignableFrom(type) && !((BaseData)item).getExt$().isEmpty()) {
            return false;
        }
        if (BeanPropertyListener.class.isAssignableFrom(type)) {
            return ((BeanPropertyListener)item).getChangedPropertyEventList().isEmpty();
        }
        List<BeanPropertyDescriptor> bpdList = BeanPropertyHelper.getBeanPropertyDescriptorList(type);
        Iterator<BeanPropertyDescriptor> var3 = bpdList.iterator();
        do {
            if (var3.hasNext()) continue;
            return true;
        } while ((bpd = var3.next()).isExt$BeanProperty() || bpd.getPropertyValue(item) == null);
        return false;
    }

    public static <T, V> V getPropertyValue(T item, String propertyName) {
        if (item == null) {
            return null;
        }
        Class<?> type = item.getClass();
        BeanPropertyDescriptor pd = BeanPropertyHelper.getBeanPropertyDescriptorList(type).stream().filter(p -> p.getName().equalsIgnoreCase(propertyName)).findAny().orElse(null);
        if (pd != null) {
            return pd.getPropertyValue(item);
        }
        return (V)(BaseData.class.isAssignableFrom(type) ? ((BaseData)item).getExt$().get(propertyName) : null);
    }

    public static <T, V> void setPropertyValue(T item, String propertyName, V value) {
        if (item != null) {
            Class<?> type = item.getClass();
            BeanPropertyHelper.getBeanPropertyDescriptorList(type).stream().filter(p -> p.getName().equalsIgnoreCase(propertyName)).findAny().ifPresent(pd -> pd.setPropertyValue(item, value));
            if (BaseData.class.isAssignableFrom(type)) {
                ((BaseData)item).getExt$().put(propertyName, ObjectUtils.toString(value));
            }
        }
    }

    public static class CopyConfig {
        private static CopyConfig DEFAULT = new CopyConfig();
        private String sourcePrefix;
        private String sourceSuffix;
        private String targetPrefix;
        private String targetSuffix;

        public String getSourcePrefix() {
            return this.sourcePrefix;
        }

        public void setSourcePrefix(String sourcePrefix) {
            this.sourcePrefix = sourcePrefix;
        }

        public String getSourceSuffix() {
            return this.sourceSuffix;
        }

        public void setSourceSuffix(String sourceSuffix) {
            this.sourceSuffix = sourceSuffix;
        }

        public String getTargetPrefix() {
            return this.targetPrefix;
        }

        public void setTargetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
        }

        public String getTargetSuffix() {
            return this.targetSuffix;
        }

        public void setTargetSuffix(String targetSuffix) {
            this.targetSuffix = targetSuffix;
        }
    }
}

