/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.exception.EmptyArrayException;
import net.sinodawn.framework.exception.OutOfRangeException;
import net.sinodawn.framework.exception.TypeMismatchException;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;

public abstract class ArrayUtils {
    public static Class<?> getArrayType(Class<?> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new TypeMismatchException("array", arrayClass);
        }
        Class<?> componentType = arrayClass.getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType;
    }

    public static boolean hasElement(Object array) {
        return array != null && array.getClass().isArray() && Array.getLength(array) > 0;
    }

    public static <T> boolean contains(T[] array, T value) {
        return array != null && array.length > 0 && Arrays.stream(array).anyMatch(t -> value == null && t == null || value != null && value.equals(t));
    }

    public static boolean containsIgnoreCase(String[] array, String value) {
        return array != null && array.length > 0 && Arrays.stream(array).anyMatch(t -> value == null && t == null || value != null && value.equalsIgnoreCase((String)t));
    }

    public static <T> T[] concat(T[] first, T[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        Object[] array = (Object[])Array.newInstance(first.getClass().getComponentType(), first.length + second.length);
        System.arraycopy(first, 0, array, 0, first.length);
        System.arraycopy(second, 0, array, first.length, second.length);
        return array;
    }

    public static <T> T[] append(T[] array, T target) {
        if (target == null) {
            return array;
        }
        int length = array == null ? 0 : array.length;
        Object[] newArray = (Object[])Array.newInstance(target.getClass(), length + 1);
        if (length > 0) {
            System.arraycopy(array, 0, newArray, 0, length);
        }
        newArray[length] = target;
        return newArray;
    }

    public static <T> String arrayToDelimitedString(T[] array, String delimit) {
        if (!ArrayUtils.hasElement(array)) {
            return "";
        }
        if (array.length == 1) {
            return ConvertUtils.convert(array[0], String.class, "");
        }
        StringBuilder sb = new StringBuilder();
        Arrays.stream(array).forEach(v -> sb.append(ConvertUtils.convert(v, String.class, "")).append(delimit));
        return sb.substring(0, sb.length() - delimit.length());
    }

    public static <T> T[] requireNotEmpty(T[] array) {
        if (!ArrayUtils.hasElement(array)) {
            throw new EmptyArrayException();
        }
        return array;
    }

    public static <T> T[] emptyArray(Class<T> componentType) {
        return ArrayUtils.newInstance(componentType, 0);
    }

    public static <T> T[] newInstance(Class<T> componentType, int size) {
        return (Object[])Array.newInstance(componentType, size);
    }

    public static <T> T[] instanceToArray(T instance) {
        Object[] array = (Object[])Array.newInstance(instance.getClass(), 1);
        array[0] = instance;
        return array;
    }

    public static <A, T> T getUniqueTypeValue(A[] array, Class<T> type) {
        if (array != null && array.length != 0) {
            List list = Arrays.stream(array).filter(a -> a != null && a.getClass().equals(type)).map(m -> m).collect(Collectors.toList());
            if (list.size() > 1) {
                throw new OutOfRangeException(JSON.toJSONString(array) + " contains more than one instance of type " + type + ".");
            }
            return list.isEmpty() ? null : (T)list.get(0);
        }
        return null;
    }

    public static <T> Class<? extends T> getUniqueAssignableType(Class<?>[] array, Class<T> type) {
        if (array != null && array.length != 0) {
            List list = Arrays.stream(array).filter(a -> a != null && type.isAssignableFrom((Class<?>)a)).collect(Collectors.toList());
            if (list.size() > 1) {
                throw new OutOfRangeException(JSON.toJSONString(array) + " contains more than one class assignable type " + type + ".");
            }
            return list.isEmpty() ? null : (Class)list.get(0);
        }
        return null;
    }

    public static <T> boolean isEquals(T[] left, T[] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null || left != null && right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        int j = left.length;
        for (int i = 0; i < j; ++i) {
            T leftValue = left[i];
            T rightValue = right[i];
            if (!(leftValue == null ? rightValue != null : !leftValue.equals(rightValue))) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> asList(T ... items) {
        return items == null ? CollectionUtils.emptyList() : Arrays.asList(items);
    }

    public static <T> boolean isEmpty(T ... items) {
        return items == null || items.length == 0;
    }

    public static <T> T[] subarray(T[] array, int start, int length) {
        if (array != null && array.length != 0) {
            Class<?> type = array[0].getClass();
            if (array.length < start + length) {
                return ArrayUtils.emptyArray(type);
            }
            ?[] subArray = ArrayUtils.newInstance(type, length);
            System.arraycopy(array, start, subArray, 0, length);
            return subArray;
        }
        return array;
    }
}

