/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.utils.DateTimeUtils;
import net.sinodawn.framework.utils.FileUtils;
import net.sinodawn.framework.utils.StringUtils;

public abstract class ArchiveUtils {
    private static final int MAX_BUFFER_SIZE = 1024;

    public static final void extractResourceIfNotPresent(String resourceName, Path destPath) {
        File f = destPath.toFile();
        if (f.isDirectory()) {
            throw new FileException("core.zip.dest-not-be-directory");
        }
        if (!f.exists()) {
            try (InputStream exeIs = ArchiveUtils.class.getResourceAsStream(resourceName);){
                if (exeIs != null) {
                    Files.copy(exeIs, destPath, new CopyOption[0]);
                }
            }
            catch (IOException var16) {
                throw new FileException(var16);
            }
        }
    }

    public static void zip(Path dest, Path ... sources) {
        if (sources == null) {
            ArchiveUtils.zip(dest.toFile(), new File[0]);
        } else {
            ArchiveUtils.zip(dest.toFile(), (File[])Arrays.stream(sources).map(s -> s.toFile()).toArray(File[]::new));
        }
    }

    public static void zip(File dest, File ... sources) {
        if (dest.isDirectory()) {
            throw new FileException("SINO.FILE.ZIP.DEST-MUST-BE-A-FILE");
        }
        if (dest.exists()) {
            dest.delete();
            try {
                dest.createNewFile();
            }
            catch (IOException var35) {
                throw new FileException(var35);
            }
        } else {
            FileUtils.createFile(dest);
        }
        if (sources != null && sources.length != 0) {
            try (FileOutputStream fos = new FileOutputStream(dest);
                 ZipOutputStream out = new ZipOutputStream(fos);){
                File[] var6 = sources;
                int var7 = sources.length;
                for (int var8 = 0; var8 < var7; ++var8) {
                    File source = var6[var8];
                    ArchiveUtils.putFile(out, source, null);
                }
            }
            catch (IOException var40) {
                throw new net.sinodawn.framework.exception.ZipException(var40);
            }
        }
    }

    private static final void putFile(ZipOutputStream out, File file, String dir) {
        if (file.isDirectory()) {
            String dirPath = StringUtils.isEmpty(dir) ? file.getName() : dir + File.separator + file.getName();
            File[] subFiles = file.listFiles();
            if (subFiles.length == 0) {
                try {
                    out.putNextEntry(new ZipEntry(dirPath));
                    out.closeEntry();
                }
                catch (IOException var19) {
                    throw new net.sinodawn.framework.exception.ZipException(var19);
                }
            } else {
                File[] var26 = subFiles;
                int len = subFiles.length;
                for (int var28 = 0; var28 < len; ++var28) {
                    File subFile = var26[var28];
                    ArchiveUtils.putFile(out, subFile, dirPath);
                }
            }
        } else if (file.isFile()) {
            try (FileInputStream is = new FileInputStream(file);){
                int len;
                Object zipEntryName = StringUtils.isEmpty(dir) ? file.getName() : dir + File.separator + file.getName();
                try {
                    out.putNextEntry(new ZipEntry((String)zipEntryName));
                }
                catch (ZipException var20) {
                    if (!StringUtils.contains(var20.getMessage(), "duplicate entry")) {
                        throw var20;
                    }
                    zipEntryName = FileUtils.getFileBaseName((String)zipEntryName) + DateTimeUtils.getDateTimeSerialNumber(LocalDateTime.now()) + "." + FileUtils.getFileExtension(file.getName());
                    out.putNextEntry(new ZipEntry((String)zipEntryName));
                }
                byte[] buffer = new byte[1024];
                while ((len = ((InputStream)is).read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                out.closeEntry();
            }
            catch (IOException var23) {
                throw new net.sinodawn.framework.exception.ZipException(var23);
            }
        }
    }
}

