/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.support.tree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.sinodawn.framework.support.tree.TreeDescriptor;
import net.sinodawn.framework.support.tree.bean.AbstractTreeNode;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.StringUtils;

public abstract class TreeHelper {
    public static <T, R extends AbstractTreeNode> List<R> parseTreeNode(List<T> treeItemList, TreeDescriptor<T> descriptor, Class<R> treeNodeClass) {
        if (treeItemList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        ArrayList<T> cloneTreeItemList = new ArrayList<T>();
        cloneTreeItemList.addAll(treeItemList);
        cloneTreeItemList.sort((b1, b2) -> descriptor.getOrderComparator().compare(b1, b2));
        List sortedNodeList = cloneTreeItemList.stream().map(t -> {
            AbstractTreeNode node;
            if (descriptor.getParseTreeNodeFunction() != null) {
                node = descriptor.getParseTreeNodeFunction().apply(t);
            } else {
                node = (AbstractTreeNode)ClassUtils.newInstance(treeNodeClass);
                BeanUtils.copyProperties(t, (Object)node, new String[0]);
            }
            String id = descriptor.getParseTreeNodeIdFunc().apply(t);
            node.setId(id);
            if (descriptor.getParseTreeNodeParentIdFunc() != null) {
                node.setParentId(descriptor.getParseTreeNodeParentIdFunc().apply(t));
            }
            node.setText(descriptor.getParseTreeNodeTextFunction().apply(t));
            for (BiConsumer<Object, AbstractTreeNode> biConsumer : descriptor.getConsumerList()) {
                biConsumer.accept(t, node);
            }
            return node;
        }).collect(Collectors.toList());
        ArrayList<AbstractTreeNode> sortedRootNodeList = new ArrayList<AbstractTreeNode>();
        if (descriptor.getParseTreeNodeParentIdFunc() != null) {
            CollectionUtils.sort(sortedNodeList, new Comparator<R>(){

                @Override
                public int compare(R r1, R r2) {
                    if (((AbstractTreeNode)r1).getId().equals(((AbstractTreeNode)r2).getParentId())) {
                        return -1;
                    }
                    return ((AbstractTreeNode)r2).getId().equals(((AbstractTreeNode)r1).getParentId()) ? 1 : 0;
                }
            });
            for (AbstractTreeNode node : sortedNodeList) {
                boolean hasParent = false;
                for (AbstractTreeNode r : sortedNodeList) {
                    AbstractTreeNode innerLoopNode = r;
                    if (!innerLoopNode.getId().equals(node.getParentId())) continue;
                    if (innerLoopNode.getLvl() == null) {
                        innerLoopNode.setLvl(1);
                    }
                    innerLoopNode.addChild(node);
                    node.setLvl(innerLoopNode.getLvl() + 1);
                    hasParent = true;
                    break;
                }
                if (hasParent) continue;
                if (node.getLvl() == null) {
                    node.setLvl(1);
                }
                sortedRootNodeList.add(node);
            }
        } else {
            block2: for (AbstractTreeNode node : sortedNodeList) {
                int nodeLength = node.getId().length();
                AbstractTreeNode parentNode = null;
                Iterator var15 = sortedNodeList.iterator();
                while (true) {
                    if (!var15.hasNext()) {
                        if (parentNode == null) {
                            if (node.getLvl() == null) {
                                node.setLvl(1);
                            }
                            sortedRootNodeList.add(node);
                            continue block2;
                        }
                        if (parentNode.getLvl() == null) {
                            parentNode.setLvl(1);
                        }
                        parentNode.addChild(node);
                        node.setLvl(parentNode.getLvl() + 1);
                        node.setParentId(parentNode.getId());
                        continue block2;
                    }
                    AbstractTreeNode innerLoopNode = (AbstractTreeNode)var15.next();
                    int innerLoopNodeLength = innerLoopNode.getId().length();
                    if (nodeLength <= innerLoopNodeLength || !StringUtils.startsWith(node.getId(), innerLoopNode.getId()) || parentNode != null && innerLoopNodeLength <= parentNode.getId().length()) continue;
                    parentNode = innerLoopNode;
                }
            }
        }
        return sortedRootNodeList;
    }

    public static <R extends AbstractTreeNode> void updateChildQty(List<R> treeItemList) {
        for (AbstractTreeNode item : treeItemList) {
            if (item.getChildren() != null && !item.getChildren().isEmpty()) {
                item.setChildQty(item.getChildren().size());
                TreeHelper.updateChildQty(item.getChildren());
                continue;
            }
            item.setChildQty(0);
        }
    }
}

