/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.support.tree;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.sinodawn.framework.support.tree.GroupingTreeDescriptor;
import net.sinodawn.framework.support.tree.bean.AbstractTreeNode;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.StringUtils;

public abstract class GroupingTreeHelper {
    public static <T, R extends AbstractTreeNode> List<R> parseTreeNode(List<T> treeItemList, GroupingTreeDescriptor<T> descriptor, Class<R> treeNodeClass) {
        if (treeItemList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        HashMap<CallSite, AbstractTreeNode> map = new HashMap<CallSite, AbstractTreeNode>();
        for (T item : treeItemList) {
            String parentId = null;
            int lvl = 1;
            for (GroupingTreeDescriptor.NodeMaker<T> nodeMaker : descriptor.getNodeMakerList()) {
                String id = nodeMaker.getId(item);
                String key = id + "$" + lvl;
                if (!map.containsKey(key)) {
                    AbstractTreeNode node = (AbstractTreeNode)ClassUtils.newInstance(treeNodeClass);
                    node.setId(id);
                    node.setText(nodeMaker.getText(item));
                    node.setParentId(parentId);
                    node.setLvl(lvl);
                    nodeMaker.copy(item, node);
                    map.put((CallSite)((Object)key), node);
                }
                parentId = id;
                ++lvl;
            }
        }
        ArrayList treeNodeList = new ArrayList(map.values());
        for (AbstractTreeNode r : treeNodeList) {
            AbstractTreeNode treeNode = r;
            if (StringUtils.isEmpty(treeNode.getParentId())) continue;
            AbstractTreeNode parentTreeNode = treeNodeList.stream().filter(n -> Objects.toString(n.getId(), "").equals(Objects.toString(treeNode.getParentId(), ""))).findFirst().get();
            parentTreeNode.addChild(treeNode);
        }
        treeNodeList.removeIf(t -> !StringUtils.isEmpty(t.getParentId()));
        GroupingTreeHelper.sortTreeNodeList(treeNodeList, descriptor);
        return treeNodeList;
    }

    public static <R extends AbstractTreeNode> void updateChildQty(List<R> treeItemList) {
        for (AbstractTreeNode item : treeItemList) {
            if (item.getChildren() != null && !item.getChildren().isEmpty()) {
                item.setChildQty(item.getChildren().size());
                GroupingTreeHelper.updateChildQty(item.getChildren());
                continue;
            }
            item.setChildQty(0);
        }
    }

    private static <T, R extends AbstractTreeNode> void sortTreeNodeList(List<R> treeNodeList, GroupingTreeDescriptor<T> descriptor) {
        if (treeNodeList != null && !treeNodeList.isEmpty()) {
            int lvl = ((AbstractTreeNode)treeNodeList.get(0)).getLvl();
            GroupingTreeDescriptor.NodeMaker<T> nodeMarker = descriptor.getNodeMakerList().get(lvl - 1);
            treeNodeList.sort(nodeMarker.getNodeComparator());
            Iterator<R> iterator = treeNodeList.iterator();
            while (iterator.hasNext()) {
                AbstractTreeNode r;
                AbstractTreeNode treeNode = r = (AbstractTreeNode)iterator.next();
                GroupingTreeHelper.sortTreeNodeList(treeNode.getChildren(), descriptor);
            }
        }
    }
}

