/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.support.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sinodawn.framework.support.domain.AbstractBaseData;
import net.sinodawn.framework.support.table.TableCellDescriptor;
import net.sinodawn.framework.support.table.bean.TableCellBean;
import net.sinodawn.framework.support.table.bean.TableRowBean;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;

public abstract class TableHelper {
    public static final <T extends AbstractBaseData> List<TableRowBean> parseTableRowList(List<T> tableCellList, TableCellDescriptor<T> descriptor) {
        if (tableCellList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        List<String> pivotList = descriptor.getPivotList();
        List<String> extList = descriptor.getExtList();
        if (pivotList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        ArrayList<TableRowBean> rowList = new ArrayList<TableRowBean>();
        for (AbstractBaseData c : tableCellList) {
            TableCellBean cell = new TableCellBean();
            cell.setKey(descriptor.getParseCellKeyFunc().apply(c));
            cell.setValue(descriptor.getParseCellValueFunc().apply(c));
            cell.setExt$Item("$field", descriptor.getCellFieldName());
            cell.setExt$Item("id", descriptor.getParseIdFunc().apply(c));
            for (String ext : extList) {
                String extValue = ConvertUtils.convert(BeanUtils.getPropertyValue(c, ext), String.class);
                cell.setExt$Item(ext, extValue);
            }
            StringBuilder pivotText = new StringBuilder();
            HashMap<String, Object> pivotValueMap = new HashMap<String, Object>();
            for (String p : pivotList) {
                String pValue = ConvertUtils.convert(BeanUtils.getPropertyValue(c, p), String.class);
                pivotText.append(p).append(":").append(pValue).append(";");
                pivotValueMap.put("pivot_" + p, pValue);
            }
            TableRowBean row = rowList.stream().filter(r -> r.getPivotText().equals(pivotText.toString())).findFirst().orElse(null);
            if (null == row) {
                TableRowBean nextRow = new TableRowBean();
                nextRow.setPivotText(pivotText.toString());
                nextRow.put(cell.getKey(), cell.getValue());
                nextRow.setExt$Item(cell.getKey() + "_ext$", cell.getExt$());
                nextRow.setExt$(pivotValueMap);
                rowList.add(nextRow);
                continue;
            }
            row.put(cell.getKey(), cell.getValue());
            row.setExt$Item(cell.getKey() + "_ext$", cell.getExt$());
            row.setExt$(pivotValueMap);
        }
        return rowList;
    }
}

