/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.support.base.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.data.CaseInsensitiveLinkedMap;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.PageRequest;
import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.UnsupportedException;
import net.sinodawn.framework.mybatis.MybatisHelper;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.mybatis.page.MybatisPageHelper;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.restful.data.RestValidationResultBean;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.support.PersistableMetadataHelper;
import net.sinodawn.framework.support.auditable.service.GenericAuditableService;
import net.sinodawn.framework.support.base.bean.CoreServiceStatusDTO;
import net.sinodawn.framework.support.base.dao.GenericDao;
import net.sinodawn.framework.support.base.mapper.GenericMapper;
import net.sinodawn.framework.support.domain.Activatable;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.support.domain.Suspendable;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeService;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import net.sinodawn.module.sys.metadata.service.CoreTableService;
import org.springframework.transaction.annotation.Transactional;

public interface GenericService<T extends Persistable<ID>, ID extends Serializable> {
    public <D extends GenericDao<T, ID>> D getDao();

    default public List<T> selectAll() {
        return this.getDao().selectAll();
    }

    default public List<T> selectListByIds(List<ID> idList) {
        return this.getDao().selectListByIds(idList, new Order[0]);
    }

    default public List<T> selectList(T item, Order ... orders) {
        return this.getDao().selectList(item, orders);
    }

    default public T selectDetail(ID id) {
        Map<String, Object> map = this.getDao().selectDetail(id);
        return (T)(map != null && !map.isEmpty() ? (Persistable)PersistableHelper.mapToPersistable(map, this.getDao().getType()) : null);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.DELETE)
    @Audit(value="AUDIT.DELETE")
    default public void delete(RestJsonWrapperBean wrapper) {
        List deleteList = wrapper.parse(this.getDao().getType());
        if (!deleteList.isEmpty()) {
            Class itemType = this.getDao().getType();
            CoreTableService tableService = ApplicationContextHelper.getBean(CoreTableService.class);
            deleteList.stream().forEach(t -> tableService.deleteCascade(PersistableMetadataHelper.getTableName(itemType), (Serializable)t.getId()));
        }
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.DELETE)
    @Audit(value="AUDIT.DELETE")
    default public void delete(ID id) {
        this.getDao().delete(id);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.DELETE)
    @Audit(value="AUDIT.DELETE")
    default public void deleteCascadeById(ID id) {
        CoreTableService tableService = ApplicationContextHelper.getBean(CoreTableService.class);
        tableService.deleteCascade(PersistableMetadataHelper.getTableName(this.getDao().getType()), id);
    }

    default public T selectById(ID id) {
        return this.getDao().selectById(id);
    }

    default public T selectByIdIfPresent(ID id) {
        return this.getDao().selectByIdIfPresent(id);
    }

    default public String selectColumnById(ID id, String column) {
        return this.getDao().selectColumnById(id, column, String.class);
    }

    default public <V> V selectColumnById(ID id, String column, Class<V> columnType) {
        return this.getDao().selectColumnById(id, column, columnType);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    default public ID insert(RestJsonWrapperBean wrapper) {
        List<Persistable> beans = wrapper.parse(this.getDao().getType());
        beans.forEach(c -> {
            if (ObjectUtils.isEmpty(c.getId())) {
                c.setId(ApplicationContextHelper.getNextIdentity());
            }
        });
        this.getDao().insert(beans);
        return (ID)(beans.isEmpty() ? "0" : (Serializable)((Persistable)beans.get(0)).getId());
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.UPDATE)
    @Audit(value="AUDIT.INSTANT_SAVE")
    default public void instantSave(RestJsonWrapperBean wrapper) {
        List<GenericService<?, ?>> serviceList = wrapper.getBodyServiceList();
        int size = serviceList.size();
        for (int i = 0; i < size; ++i) {
            GenericService<?, ?> service = serviceList.get(i);
            if (service == null) continue;
            service.updateIfChanged(wrapper.parse(service.getDao().getType(), i));
        }
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.UPDATE)
    @Audit(value="AUDIT.SAVE")
    default public void save(ID id, RestJsonWrapperBean wrapper) {
        List<GenericService<?, ?>> serviceList = wrapper.getBodyServiceList();
        int size = serviceList.size();
        for (int i = 0; i < size; ++i) {
            GenericService<?, ?> service = serviceList.get(i);
            if (service == null) {
                this.updateIfChanged(wrapper.parse(this.getDao().getType(), i));
                continue;
            }
            service.updateIfChanged(wrapper.parse(service.getDao().getType(), i));
        }
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.UPDATE)
    @Audit(value="AUDIT.SAVE")
    default public void updateIfChanged(T item) {
        this.getDao().updateIfChanged(item);
    }

    @AuditTrailEntry(value=AuditTrailType.UPDATE)
    @Audit(value="AUDIT.SAVE")
    default public void update(T proxy) {
        this.getDao().update(proxy, (String[])new String[0]);
    }

    @AuditTrailEntry(value=AuditTrailType.UPDATE)
    @Audit(value="AUDIT.SAVE")
    default public void updateIfChanged(List<T> itemList) {
        this.getDao().updateIfChanged(itemList);
    }

    @AuditTrailEntry(value=AuditTrailType.UPDATE)
    @Audit(value="AUDIT.SAVE")
    default public void updateCreatedBy(T item) {
        this.getDao().updateCreatedBy(item);
    }

    @AuditTrailEntry(value=AuditTrailType.UPDATE)
    @Audit(value="AUDIT.SAVE")
    default public void updateCreatedBy(List<T> itemList) {
        this.getDao().updateCreatedBy(itemList);
    }

    default public Page<T> selectPagination(MapperParameter parameter, PageRowBounds rowBounds) {
        return this.selectPagination(() -> this.getDao().selectByCondition(parameter), rowBounds);
    }

    default public <V> Page<T> selectPagination(Supplier<List<V>> mapOrItemSupplier, PageRowBounds rowBounds) {
        Page page = MybatisPageHelper.get(rowBounds, mapOrItemSupplier);
        if (page.getRows().isEmpty()) {
            return new Pagination(page, CollectionUtils.emptyList());
        }
        Class<?> clazz = ClassUtils.getRawType(page.getRows().get(0).getClass());
        if (Map.class.isAssignableFrom(clazz)) {
            List itemList = page.getRows().parallelStream().map(m -> (Persistable)PersistableHelper.mapToPersistable((Map)m, this.getDao().getType())).collect(Collectors.toList());
            return new Pagination(page, itemList);
        }
        if (this.getDao().getType().isAssignableFrom(clazz)) {
            return page;
        }
        throw new UnsupportedException();
    }

    default public Page<T> selectPagination(MapperParameter parameter) {
        return this.selectPagination(parameter, null);
    }

    default public Page<T> selectPagination(RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        return this.selectPagination(parameter, rowBounds);
    }

    default public Page<T> selectPaginationByFilter(SearchFilter filter, RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        parameter.setFilter(filter);
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        return this.selectPagination(parameter, rowBounds);
    }

    default public Page<T> selectRawPagination(RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        Class type = this.getDao().getType();
        if (Auditable.class.isAssignableFrom(type)) {
            parameter.setProcessStatus("PROCESSSTATUS", ProcessStatus.DRAFT);
        }
        parameter.setRawQueries();
        BeanPropertyDescriptor createdByOrgIdPropertyDescriptor = PersistableMetadataHelper.getCreatedByOrgIdPropertyDescriptor(type);
        if (createdByOrgIdPropertyDescriptor != null) {
            parameter.setOrgAuthority();
        }
        if (!wrapper.getAuthorityList().isEmpty()) {
            wrapper.getAuthorityList().forEach(a -> parameter.setAuthorityParameter((String)a));
        }
        return this.selectPagination(parameter, rowBounds);
    }

    default public Page<T> selectByRole(Long roleId, RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        parameter.setSelectByRoleIdParam(roleId);
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        return this.selectPagination(parameter, rowBounds);
    }

    default public Page<T> selectSearchablePagination(RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        Class type = this.getDao().getType();
        if (Auditable.class.isAssignableFrom(type)) {
            parameter.setProcessStatus("PROCESSSTATUS", ProcessStatus.APPROVE_OR_DONE);
        }
        parameter.setSearchableQueries();
        BeanPropertyDescriptor createdByOrgIdPropertyDescriptor = PersistableMetadataHelper.getCreatedByOrgIdPropertyDescriptor(type);
        if (createdByOrgIdPropertyDescriptor != null) {
            parameter.setOrgAuthority();
        }
        if (!wrapper.getAuthorityList().isEmpty()) {
            wrapper.getAuthorityList().forEach(a -> parameter.setAuthorityParameter((String)a));
        }
        return this.selectPagination(parameter, rowBounds);
    }

    default public RestValidationResultBean validate(ID id, RestJsonWrapperBean jsonWrapper) {
        return new RestValidationResultBean(true);
    }

    default public RestValidationResultBean validateUnique(RestJsonWrapperBean wrapper) {
        String validateUniqueFieldJson = wrapper.getParamValue("vu");
        if (null == validateUniqueFieldJson) {
            return new RestValidationResultBean(true);
        }
        Map validateUniqueFieldMap = (Map)JSONObject.parseObject((String)validateUniqueFieldJson, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        CaseInsensitiveLinkedMap<Object> columnMap = new CaseInsensitiveLinkedMap<Object>(validateUniqueFieldMap);
        Serializable id = (Serializable)ConvertUtils.convert(columnMap.get("id"), this.getDao().getEntityContext().getIdContext().getType());
        columnMap.remove("id");
        return this.validateUnique(id, columnMap);
    }

    default public RestValidationResultBean validateUnique(ID id, String columnName, String columnValue) {
        CaseInsensitiveLinkedMap<Object> columnMap = new CaseInsensitiveLinkedMap<Object>();
        columnMap.put(columnName, (Object)columnValue);
        return this.validateUnique(id, columnMap);
    }

    default public RestValidationResultBean validateUnique(ID id, Map<String, Object> columnMap) {
        Class type = this.getDao().getType();
        if (columnMap == null || columnMap.isEmpty() || columnMap.size() == 1 && columnMap.containsKey("ID") || columnMap.size() == 1 && columnMap.containsKey(null)) {
            Object searchTerms = this.getDao().selectByIdIfPresent(id);
            return searchTerms == null ? new RestValidationResultBean(true) : new RestValidationResultBean(false, "core.validator.column.not-unique");
        }
        Persistable searchTerms = (Persistable)ClassUtils.newInstance(type);
        columnMap.forEach((k, v) -> {
            BeanPropertyDescriptor propertyDescriptor = BeanPropertyHelper.getBeanPropertyDescriptor(type, k);
            if (propertyDescriptor == null) {
                searchTerms.setExt$Item((String)k, v == null ? null : v.toString());
            } else {
                ReflectionUtils.invokeMethod(propertyDescriptor.getWriteMethod(), searchTerms, ConvertUtils.convert(v, propertyDescriptor.getPropertyType()));
            }
        });
        List<?> idList = this.getDao().selectColumnList((Persistable)searchTerms, "ID", this.getDao().getEntityContext().getIdContext().getType(), new Order[0]);
        if (idList.isEmpty()) {
            return new RestValidationResultBean(true);
        }
        if (idList.size() > 1) {
            return new RestValidationResultBean(false, "core.validator.column.not-unique");
        }
        return !((Persistable)idList.get(0)).equals(id) ? new RestValidationResultBean(false, "core.validator.column.not-unique") : new RestValidationResultBean(true);
    }

    default public boolean isAvailableByCurrentUser(ID id) {
        HashMap<String, ID> map = new HashMap<String, ID>();
        map.put("id_SEQ", id);
        RestJsonWrapperBean wrapper = new RestJsonWrapperBean(JSONObject.toJSONString(map));
        wrapper.removePageParams();
        Page<T> rawPage = this.selectRawPagination(wrapper);
        if (rawPage.getNumberOfElements() > 0) {
            return true;
        }
        Page<T> searchPage = this.selectSearchablePagination(wrapper);
        return searchPage.getNumberOfElements() > 0;
    }

    default public boolean isUpdatedByCurrentUser(ID id) {
        HashMap<String, ID> map = new HashMap<String, ID>();
        map.put("id_SEQ", id);
        RestJsonWrapperBean wrapper = new RestJsonWrapperBean(JSONObject.toJSONString(map));
        wrapper.removePageParams();
        Page<T> page = this.selectRawPagination(wrapper);
        return page.getNumberOfElements() > 0;
    }

    default public CoreServiceStatusDTO selectStatus(ID id, String currentStatusCode) {
        Object item;
        CoreServiceStatusDTO status = new CoreServiceStatusDTO();
        Object v0 = item = id == null ? null : this.getDao().selectByIdIfPresent(id);
        if (Activatable.class.isAssignableFrom(this.getDao().getType())) {
            CoreServiceStatusDTO.ActiveStatus activeStatus = new CoreServiceStatusDTO.ActiveStatus();
            if (item != null) {
                activeStatus.setActivatedFlag(((Activatable)item).getActivatedFlag());
            } else {
                activeStatus.setActivatedFlag("0");
            }
            status.setActiveStatus(activeStatus);
        }
        if (Suspendable.class.isAssignableFrom(this.getDao().getType())) {
            CoreServiceStatusDTO.SuspendStatus suspendStatus = new CoreServiceStatusDTO.SuspendStatus();
            if (item != null) {
                suspendStatus.setLastSuspendedFlag(((Suspendable)item).getLastSuspendedFlag());
            } else {
                suspendStatus.setLastSuspendedFlag("0");
            }
            status.setSuspendStatus(suspendStatus);
        }
        if (Auditable.class.isAssignableFrom(this.getDao().getType())) {
            CoreServiceStatusDTO.AuditStatus auditStatus = new CoreServiceStatusDTO.AuditStatus();
            if (item != null) {
                auditStatus.setProcessStatus(((Auditable)item).getProcessStatus());
                if (!StringUtils.isEmpty(currentStatusCode)) {
                    auditStatus.setStatusCode(currentStatusCode);
                } else {
                    CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
                    List<CoreBpmnInstanceTaskBean> instanceTaskList = runtimeService.selectAuditableInstanceTaskList(this.getDao().getTable(), id, LocalContextHelper.getLoginUserId());
                    if (instanceTaskList.size() > 1) {
                        throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.MULTIPLE_TASK_ASSIGNED");
                    }
                    if (instanceTaskList.size() > 0) {
                        auditStatus.setStatusCode(instanceTaskList.get(0).getStatusCode());
                    } else {
                        auditStatus.setStatusCode(ProcessStatus.DRAFT.name().toLowerCase());
                    }
                }
            } else {
                auditStatus.setProcessStatus(ProcessStatus.DRAFT.name().toLowerCase());
                auditStatus.setStatusCode(ProcessStatus.DRAFT.name().toLowerCase());
            }
            status.setAuditStatus(auditStatus);
        }
        return status;
    }

    default public void postUpdate(List<String> updatedColumnNameList, List<ID> idList) {
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.SWAP)
    @Audit(value="AUDIT.SWAP")
    default public void swap(String column, ID firstId, ID secondId) {
        Object first = this.getDao().selectById(firstId);
        Object second = this.getDao().selectById(secondId);
        Field field = ReflectionUtils.findField(this.getDao().getType(), column);
        if (field == null) {
            String key = column.toLowerCase();
            String firstValue = first.getExt$().get(key);
            first.setExt$Item(key, second.getExt$().get(key));
            second.setExt$Item(key, firstValue);
        } else {
            Object firstValue = ReflectionUtils.invokeReadMethod(first, field.getName());
            Object secondValue = ReflectionUtils.invokeReadMethod(second, field.getName());
            ReflectionUtils.invokeWriteMethod(first, field.getName(), secondValue);
            ReflectionUtils.invokeWriteMethod(second, field.getName(), firstValue);
        }
        this.getDao().update(Arrays.asList(first, second), (String[])new String[]{column});
    }

    default public List<T> selectListByFilter(SearchFilter filter, Order ... orders) {
        MapperParameter parameter = new MapperParameter();
        parameter.setFilter(filter);
        Order[] var4 = orders;
        int var5 = orders.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Order order = var4[var6];
            parameter.setOrderParam(order.getColumn(), order.getDirection());
        }
        return this.selectList(parameter);
    }

    default public List<T> selectListByFilter(SearchFilter filter, RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper == null ? new MapperParameter() : wrapper.extractMapFilter();
        parameter.setFilter(filter);
        return this.selectList(parameter);
    }

    default public List<T> selectList(MapperParameter parameter) {
        List<Map<String, Object>> mapList = this.getDao().selectByCondition(parameter);
        return mapList.isEmpty() ? CollectionUtils.emptyList() : mapList.parallelStream().map(m -> (Persistable)PersistableHelper.mapToPersistable(m, this.getDao().getType())).collect(Collectors.toList());
    }

    default public T selectFirst(MapperParameter parameter) {
        PageRequest page = new PageRequest();
        page.setPageSize(1);
        PageRowBounds rowBounds = new PageRowBounds(page);
        Page mapList = MybatisPageHelper.get(rowBounds, () -> this.getDao().selectByCondition(parameter));
        return (T)(mapList.getRows().isEmpty() ? null : (Persistable)PersistableHelper.mapToPersistable((Map)mapList.getRows().get(0), this.getDao().getType()));
    }

    default public T selectFirstByFilter(SearchFilter filter, RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper == null ? new MapperParameter() : wrapper.extractMapFilter();
        parameter.setFilter(filter);
        return this.selectFirst(parameter);
    }

    default public T selectFirstByFilter(SearchFilter filter, Order ... orders) {
        MapperParameter parameter = new MapperParameter();
        parameter.setFilter(filter);
        Order[] var4 = orders;
        int var5 = orders.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Order order = var4[var6];
            parameter.setOrderParam(order.getColumn(), order.getDirection());
        }
        return this.selectFirst(parameter);
    }

    default public String getSinoAttrsMybatisMapper() {
        GenericMapper mapper = this.getDao().getMapper();
        Class<?> mapperClazz = ClassUtils.getRawType(mapper.getClass());
        return MybatisHelper.getMapperContent(mapperClazz);
    }

    default public JSONObject print(ID id) {
        throw new UnsupportedException("You should implements this method if required.");
    }

    default public Long selectProcId(ID id) {
        if (GenericAuditableService.class.isAssignableFrom(this.getClass())) {
            GenericAuditableService auditableService = (GenericAuditableService)this;
            Object item = this.getDao().selectById(id);
            List pairList = auditableService.getBpmnProcIdList(Arrays.asList(item));
            return pairList.isEmpty() ? null : pairList.get(0).getSecond();
        }
        return null;
    }

    default public <V> void updateColumn(ID id, String columnName, V value) {
        Persistable item = (Persistable)ClassUtils.newInstance(this.getDao().getType());
        item.setId(id);
        BeanPropertyDescriptor propertyDescriptor = BeanPropertyHelper.getBeanPropertyDescriptor(this.getDao().getType(), columnName);
        if (propertyDescriptor == null) {
            item.setExt$Item(columnName, ConvertUtils.convert(value, String.class));
        } else {
            propertyDescriptor.setPropertyValue(item, value);
        }
        this.getDao().update((String[])item, (String[])new String[]{columnName});
    }
}

