/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.support.base.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sinodawn.framework.aspect.annotation.IgnoreAop;
import net.sinodawn.framework.context.SinoAopContext;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pageable;
import net.sinodawn.framework.database.context.EntityColumnContext;
import net.sinodawn.framework.database.context.EntityContext;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.UnsupportedException;
import net.sinodawn.framework.exception.database.NotUniqueResultJdbcException;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.support.PersistableMetadataHelper;
import net.sinodawn.framework.support.base.mapper.GenericMapper;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ReflectionUtils;

public interface GenericDao<T extends Persistable<ID>, ID extends Serializable> {
    public static final int STATEMENT_MAX_BATCH_BIND_VALUES = 400;

    @IgnoreAop
    default public String getTable() {
        return PersistableMetadataHelper.getTableName(this.getType());
    }

    public Class<T> getType();

    public EntityContext getEntityContext();

    default public GenericMapper<ID> getMapper() {
        throw new UnsupportedException();
    }

    public void insert(T var1);

    public void insert(List<T> var1);

    public void delete(ID var1);

    public void deleteByIdList(List<ID> var1);

    public void deleteBy(List<T> var1, String ... var2);

    default public void deleteBy(T item, String ... searchColNames) {
        this.deleteBy((T)Arrays.asList(item), searchColNames);
    }

    public void update(T var1, List<String> var2, String ... var3);

    default public void update(T item, String ... updateColNames) {
        this.update(item, ArrayUtils.asList(updateColNames), new String[0]);
    }

    public void updateByIds(T var1, List<ID> var2, String ... var3);

    default public void update(List<T> itemList, List<String> updateColNames, String ... searchColNames) {
        if (ArrayUtils.isEmpty(searchColNames)) {
            this.update((T)itemList, (T)updateColNames.toArray(new String[0]));
        } else {
            for (Persistable item : itemList) {
                this.update(item, updateColNames, searchColNames);
            }
        }
    }

    public void update(List<T> var1, String ... var2);

    default public void update(T updateItem, T searchItem) {
        List<ID> idList = this.selectIdList(searchItem, new Order[0]);
        if (!idList.isEmpty()) {
            this.updateByIds(updateItem, idList, new String[0]);
        }
    }

    public List<T> updateIfChanged(List<T> var1);

    default public T updateIfChanged(T rawOrProxyItem) {
        List<Persistable> itemList = this.updateIfChanged((T)Arrays.asList(rawOrProxyItem));
        return (T)(itemList.isEmpty() ? null : itemList.get(0));
    }

    default public void updateCreatedBy(T item) {
        this.updateCreatedBy(Arrays.asList(item));
    }

    public void updateCreatedBy(List<T> var1);

    public T selectByIdIfPresent(ID var1);

    default public T selectById(ID id) {
        GenericDao dao = (GenericDao)SinoAopContext.currentProxy();
        return (T)((Persistable)Objects.requireNonNull(dao.selectByIdIfPresent(id), "SINO.EXCEPTION.NO_VALUE_EXISTS"));
    }

    public T selectOneIfPresent(T var1, String ... var2);

    default public T selectOne(T item, String ... selectColNames) {
        return (T)((Persistable)Objects.requireNonNull(this.selectOneIfPresent(item, selectColNames), "SINO.EXCEPTION.NO_VALUE_EXISTS"));
    }

    public <V> V selectColumnById(ID var1, String var2, Class<V> var3);

    public <V> List<V> selectColumnList(T var1, List<String> var2, String var3, Class<V> var4, Order ... var5);

    default public <V> List<V> selectColumnList(T item, String colName, Class<V> colType, Order ... orders) {
        return this.selectColumnList(item, CollectionUtils.emptyList(), colName, colType, orders);
    }

    default public <V> V selectColumnIfPresent(T item, String colName, Class<V> colType) {
        List<V> columnList = this.selectColumnList(item, colName, colType, new Order[0]);
        if (columnList.size() > 1) {
            throw new NotUniqueResultJdbcException();
        }
        return columnList.isEmpty() ? null : (V)columnList.get(0);
    }

    default public <V> V selectColumn(T item, String colName, Class<V> colType) {
        return Objects.requireNonNull(this.selectColumnIfPresent(item, colName, colType), "SINO.EXCEPTION.NO_VALUE_EXISTS");
    }

    default public List<ID> selectIdList(T item, Order ... orders) {
        EntityColumnContext idContext = this.getEntityContext().getIdContext();
        return this.selectColumnList(item, idContext.getColumnName(), idContext.getType(), orders);
    }

    default public List<ID> selectIdList(T item, List<String> searchColNames, Order ... orders) {
        EntityColumnContext idContext = this.getEntityContext().getIdContext();
        return this.selectColumnList(item, searchColNames, idContext.getColumnName(), idContext.getType(), orders);
    }

    default public ID selectIdIfPresent(T item) {
        EntityColumnContext idContext = this.getEntityContext().getIdContext();
        return (ID)((Serializable)this.selectColumnIfPresent(item, idContext.getColumnName(), idContext.getType()));
    }

    default public ID selectId(T item) {
        return (ID)((Serializable)Objects.requireNonNull(this.selectIdIfPresent(item), "SINO.EXCEPTION.NO_VALUE_EXISTS"));
    }

    public List<T> selectAll(List<Order> var1, String ... var2);

    default public List<T> selectAll(Order ... orders) {
        return this.selectAll(Arrays.asList(orders), new String[0]);
    }

    default public List<T> selectAll(String ... selectColNames) {
        return this.selectAll(CollectionUtils.emptyList(), selectColNames);
    }

    default public List<T> selectAll() {
        return this.selectAll(CollectionUtils.emptyList(), new String[0]);
    }

    public List<T> selectListByIds(List<ID> var1, List<String> var2, Order ... var3);

    default public List<T> selectListByIds(List<ID> idList, Order ... orders) {
        return this.selectListByIds(idList, CollectionUtils.emptyList(), orders);
    }

    public <V> List<V> selectColumnsByIds(List<ID> var1, String var2, Class<V> var3, Order ... var4);

    public List<T> selectList(T var1, List<String> var2, List<String> var3, Order ... var4);

    default public List<T> selectList(T item, List<String> selectColNames, Order ... orders) {
        return this.selectList(item, CollectionUtils.emptyList(), selectColNames, orders);
    }

    default public List<T> selectList(T item, Order ... orders) {
        return this.selectList(item, CollectionUtils.emptyList(), orders);
    }

    public List<T> selectList(List<T> var1, List<String> var2, List<String> var3, Order ... var4);

    public <V> List<V> selectList(List<T> var1, List<String> var2, String var3, Class<V> var4, Order ... var5);

    default public <V> List<V> selectList(List<T> itemList, String colName, Class<V> colType, Order ... orders) {
        return this.selectList(itemList, CollectionUtils.emptyList(), colName, colType, orders);
    }

    default public <V> List<T> selectListByOneColumnValues(List<V> valueList, String colName, List<String> selectColNames, Order ... orders) {
        List itemList = valueList.stream().map(v -> {
            Persistable item = (Persistable)ClassUtils.newInstance(this.getType());
            this.getEntityContext().getColumnContextList().stream().filter(c -> c.getColumnName().equalsIgnoreCase(colName)).forEach(p -> ReflectionUtils.invokeMethod(p.getPropertyDescriptor().getWriteMethod(), item, ConvertUtils.convert(v, p.getType())));
            return item;
        }).collect(Collectors.toList());
        return this.selectList(itemList, Arrays.asList(colName), selectColNames, orders);
    }

    default public <V> List<T> selectListByOneColumnValues(List<V> valueList, String colName, Order ... orders) {
        return this.selectListByOneColumnValues(valueList, colName, CollectionUtils.emptyList(), orders);
    }

    default public <V> List<T> selectListByOneColumnValue(V value, String colName, List<String> selectColNames, Order ... orders) {
        return this.selectListByOneColumnValues(Arrays.asList(value), colName, selectColNames, orders);
    }

    default public <V> List<T> selectListByOneColumnValue(V value, String colName, Order ... orders) {
        return this.selectListByOneColumnValues(Arrays.asList(value), colName, CollectionUtils.emptyList(), orders);
    }

    default public List<ID> selectIdList(List<T> itemList, List<String> searchColNames, Order ... orders) {
        EntityColumnContext idContext = this.getEntityContext().getIdContext();
        return this.selectList(itemList, searchColNames, idContext.getColumnName(), idContext.getType(), orders);
    }

    default public List<ID> selectIdList(List<T> item, Order ... orders) {
        EntityColumnContext idContext = this.getEntityContext().getIdContext();
        return this.selectList(item, CollectionUtils.emptyList(), idContext.getColumnName(), idContext.getType(), orders);
    }

    public T selectFirstIfPresent(T var1, List<String> var2, List<String> var3, Order ... var4);

    default public T selectFirst(T item, List<String> searchColNames, List<String> selectColNames, Order ... orders) {
        return (T)((Persistable)Objects.requireNonNull(this.selectFirstIfPresent(item, searchColNames, selectColNames, orders), "SINO.EXCEPTION.NO_VALUE_EXISTS"));
    }

    default public T selectFirstIfPresent(T item, List<String> selectColNames, Order ... orders) {
        return this.selectFirstIfPresent(item, CollectionUtils.emptyList(), selectColNames, orders);
    }

    default public T selectFirst(T item, List<String> selectColNames, Order ... orders) {
        return (T)((Persistable)Objects.requireNonNull(this.selectFirstIfPresent(item, selectColNames, orders), "SINO.EXCEPTION.NO_VALUE_EXISTS"));
    }

    default public T selectFirstIfPresent(T item, Order ... orders) {
        return this.selectFirstIfPresent(item, CollectionUtils.emptyList(), CollectionUtils.emptyList(), orders);
    }

    default public T selectFirst(T item, Order ... orders) {
        return (T)((Persistable)Objects.requireNonNull(this.selectFirstIfPresent(item, orders), "SINO.EXCEPTION.NO_VALUE_EXISTS"));
    }

    public List<T> selectUnionList(T var1, List<String> var2, List<String> var3, Order ... var4);

    default public List<T> selectUnionList(T item, List<String> selectColNames, Order ... orders) {
        return this.selectUnionList(item, CollectionUtils.emptyList(), selectColNames, orders);
    }

    default public List<T> selectUnionList(T item, Order ... orders) {
        return this.selectUnionList(item, CollectionUtils.emptyList(), CollectionUtils.emptyList(), orders);
    }

    default public T selectOneUnionIfPresent(T item, List<String> searchColNames, List<String> selectColNames, Order ... orders) {
        List<T> resultList = this.selectUnionList(item, searchColNames, selectColNames, orders);
        if (resultList.isEmpty()) {
            return null;
        }
        if (resultList.size() > 1) {
            throw new NotUniqueResultJdbcException();
        }
        return (T)((Persistable)resultList.get(0));
    }

    default public T selectOneUnion(T item, List<String> searchColNames, List<String> selectColNames, Order ... orders) {
        return (T)((Persistable)Objects.requireNonNull(this.selectOneUnionIfPresent(item, searchColNames, selectColNames, orders), "SINO.EXCEPTION.NO_VALUE_EXISTS"));
    }

    default public T selectOneUnionIfPresent(T item, List<String> selectColNames, Order ... orders) {
        return this.selectOneUnionIfPresent(item, CollectionUtils.emptyList(), selectColNames, orders);
    }

    default public T selectOneUnion(T item, List<String> selectColNames, Order ... orders) {
        return (T)((Persistable)Objects.requireNonNull(this.selectOneUnionIfPresent(item, selectColNames, orders)));
    }

    default public T selectOneUnionIfPresent(T item, Order ... orders) {
        return this.selectOneUnionIfPresent(item, CollectionUtils.emptyList(), CollectionUtils.emptyList(), orders);
    }

    default public T selectOneUnion(T item, Order ... orders) {
        return (T)((Persistable)Objects.requireNonNull(this.selectOneUnionIfPresent(item, orders)));
    }

    public int countBy(T var1, String ... var2);

    default public int count() {
        return this.countBy((Persistable)ClassUtils.newInstance(this.getType()), new String[0]);
    }

    public int countBy(List<T> var1, String ... var2);

    public Page<T> selectPaginationByMybatis(String var1, Pageable var2);

    default public Map<String, Object> selectDetail(ID id) {
        MapperParameter parameter = new MapperParameter();
        parameter.setFilter(SearchFilter.instance().match("ID", id).filter(MatchPattern.EQ));
        List<Map<String, Object>> mapList = this.getMapper().selectByCondition(parameter);
        return mapList.isEmpty() ? CollectionUtils.emptyMap() : mapList.get(0);
    }

    default public List<Map<String, Object>> selectByCondition(MapperParameter parameter) {
        parameter.setTableName(PersistableMetadataHelper.getTableName(this.getType()));
        return this.getMapper().selectByCondition(parameter);
    }

    default public void cacheEvict(T oldItem, T newItem) {
    }
}

