/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.support.auditable.service;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.data.Pair;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.context.EntityColumnContext;
import net.sinodawn.framework.database.core.DatabaseManager;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.core.ApplicationWarningException;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.support.auditable.bean.CoreBpmnParameterDTO;
import net.sinodawn.framework.support.auditable.bean.CoreBpmnTaskStatusDTO;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.support.domain.Suspendable;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceNextTaskElementDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnTaskCandidatorsDTO;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.diagram.attribute.CandidatorFilterStrategy;
import net.sinodawn.module.sys.bpmn.diagram.attribute.NextCandidatorOptStrategy;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeService;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import net.sinodawn.module.sys.role.service.CoreRoleUserService;
import org.dom4j.Element;
import org.springframework.transaction.annotation.Transactional;

public interface GenericAuditableService<T extends Auditable<ID>, ID extends Serializable>
extends GenericService<T, ID> {
    default public Page<T> selectAuditablePagination(RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        if (Auditable.class.isAssignableFrom(this.getDao().getType())) {
            parameter.setProcessStatus("PROCESSSTATUS", ProcessStatus.APPROVE);
        }
        parameter.setAuditAuthority();
        parameter.setOrgAuthority();
        parameter.setAuditableQueries();
        if (!wrapper.getAuthorityList().isEmpty()) {
            wrapper.getAuthorityList().forEach(a -> parameter.setAuthorityParameter((String)a));
        }
        return this.selectPagination(parameter, rowBounds);
    }

    default public Page<T> selectWithdrawablePagination(RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        if (Auditable.class.isAssignableFrom(this.getDao().getType())) {
            parameter.setProcessStatus("PROCESSSTATUS", ProcessStatus.APPROVE);
        }
        parameter.setOrgAuthority();
        parameter.setWithdrawableQueries();
        if (!wrapper.getAuthorityList().isEmpty()) {
            wrapper.getAuthorityList().forEach(a -> parameter.setAuthorityParameter((String)a));
        }
        return this.selectPagination(parameter, rowBounds);
    }

    default public Page<T> selectUndoablePagination(RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        Class type = this.getDao().getType();
        if (Auditable.class.isAssignableFrom(this.getDao().getType())) {
            parameter.setProcessStatus("PROCESSSTATUS", ProcessStatus.DONE);
        }
        if (Suspendable.class.isAssignableFrom(type)) {
            parameter.setSuspendedFlag("0");
        }
        parameter.setOrgAuthority();
        parameter.setUndoableQueries();
        if (!wrapper.getAuthorityList().isEmpty()) {
            wrapper.getAuthorityList().forEach(a -> parameter.setAuthorityParameter((String)a));
        }
        return this.selectPagination(parameter, rowBounds);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_START)
    @Audit(value="AUDIT.PROCESS_START")
    default public List<CoreBpmnInstanceStatusDTO<ID>> startProcess(RestJsonWrapperBean wrapper) {
        List itemList = wrapper.parse(this.getDao().getType());
        if (itemList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        this.checkAndUpdateVersion(itemList);
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List itemIdList = itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
        List<T> selectItemList = this.getBpmnVarsItemList(itemIdList);
        List runtimeSourceList = this.parseSubmittableRuntimeSource(itemIdList, CoreBpmnParameterDTO.of(wrapper), this.getBpmnVars(wrapper, selectItemList));
        return runtimeService.startProcess(runtimeSourceList);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_START)
    @Audit(value="AUDIT.PROCESS_START")
    default public List<CoreBpmnInstanceStatusDTO<ID>> startProcess(List<ID> itemIdList, CoreBpmnParameterDTO parameter) {
        if (itemIdList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List<T> itemList = this.getBpmnVarsItemList(itemIdList);
        List<CoreBpmnRuntimeSource<T, ID>> runtimeSourceList = this.parseSubmittableRuntimeSource(itemIdList, parameter, this.getBpmnVars(null, itemList));
        return runtimeService.startProcess(runtimeSourceList);
    }

    @Deprecated
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_START)
    @Audit(value="AUDIT.PROCESS_START")
    default public List<CoreBpmnInstanceStatusDTO<ID>> startProcess(List<ID> itemIdList, String comment) {
        CoreBpmnParameterDTO parameter = new CoreBpmnParameterDTO();
        parameter.setComment(comment);
        return this.startProcess(itemIdList, parameter);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_WITHDRAW)
    @Audit(value="AUDIT.PROCESS_WITHDRAW")
    default public List<CoreBpmnInstanceStatusDTO<ID>> withdrawProcess(RestJsonWrapperBean wrapper) {
        List itemList = wrapper.parse(this.getDao().getType());
        if (itemList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        this.checkAndUpdateVersion(itemList);
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List itemIdList = itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
        List<T> selectItemList = this.getBpmnVarsItemList(itemIdList);
        List runtimeSourceList = this.parseWithdrawableRuntimeSource(itemIdList, CoreBpmnParameterDTO.of(wrapper), this.getBpmnVars(wrapper, selectItemList));
        return runtimeService.withdrawProcess(runtimeSourceList);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_WITHDRAW)
    @Audit(value="AUDIT.PROCESS_WITHDRAW")
    default public List<CoreBpmnInstanceStatusDTO<ID>> withdrawProcess(List<ID> itemIdList, CoreBpmnParameterDTO parameter) {
        if (itemIdList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List<T> itemList = this.getBpmnVarsItemList(itemIdList);
        List<CoreBpmnRuntimeSource<T, ID>> runtimeSourceList = this.parseWithdrawableRuntimeSource(itemIdList, parameter, this.getBpmnVars(null, itemList));
        return runtimeService.withdrawProcess(runtimeSourceList);
    }

    @Deprecated
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_WITHDRAW)
    @Audit(value="AUDIT.PROCESS_WITHDRAW")
    default public List<CoreBpmnInstanceStatusDTO<ID>> withdrawProcess(List<ID> itemIdList, String comment) {
        CoreBpmnParameterDTO parameter = new CoreBpmnParameterDTO();
        parameter.setComment(comment);
        return this.withdrawProcess(itemIdList, parameter);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_COMPLETE)
    @Audit(value="AUDIT.PROCESS_COMPLETE")
    default public List<CoreBpmnInstanceStatusDTO<ID>> completeTask(RestJsonWrapperBean wrapper) {
        List itemList = wrapper.parse(this.getDao().getType());
        if (itemList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        this.checkAndUpdateVersion(itemList);
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List itemIdList = itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
        List<T> selectItemList = this.getBpmnVarsItemList(itemIdList);
        List runtimeSourceList = this.parseAuditableRuntimeSource(itemIdList, CoreBpmnParameterDTO.of(wrapper), this.getBpmnVars(wrapper, selectItemList));
        return runtimeService.completeTask(runtimeSourceList);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_COMPLETE)
    @Audit(value="AUDIT.PROCESS_COMPLETE")
    default public List<CoreBpmnInstanceStatusDTO<ID>> completeTask(List<ID> itemIdList, CoreBpmnParameterDTO parameter) {
        if (itemIdList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List<T> itemList = this.getBpmnVarsItemList(itemIdList);
        List<CoreBpmnRuntimeSource<T, ID>> runtimeSourceList = this.parseAuditableRuntimeSource(itemIdList, parameter, this.getBpmnVars(null, itemList));
        return runtimeService.completeTask(runtimeSourceList);
    }

    @Deprecated
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_COMPLETE)
    @Audit(value="AUDIT.PROCESS_COMPLETE")
    default public List<CoreBpmnInstanceStatusDTO<ID>> completeTask(List<ID> itemIdList, String comment) {
        CoreBpmnParameterDTO parameter = new CoreBpmnParameterDTO();
        parameter.setComment(comment);
        return this.completeTask(itemIdList, parameter);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_TRANSFER)
    @Audit(value="AUDIT.PROCESS_TRANSFER")
    default public void transferTask(RestJsonWrapperBean wrapper) {
        List itemList = wrapper.parse(this.getDao().getType());
        if (!itemList.isEmpty()) {
            this.checkAndUpdateVersion(itemList);
            CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
            List itemIdList = itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
            List runtimeSourceList = this.parseAuditableRuntimeSource(itemIdList, CoreBpmnParameterDTO.of(wrapper), CollectionUtils.emptyMap());
            runtimeService.transferTask(runtimeSourceList);
        }
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_END)
    @Audit(value="AUDIT.PROCESS_END")
    default public List<CoreBpmnInstanceStatusDTO<ID>> endTask(RestJsonWrapperBean wrapper) {
        List itemList = wrapper.parse(this.getDao().getType());
        if (itemList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        this.checkAndUpdateVersion(itemList);
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List itemIdList = itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
        List<T> selectItemList = this.getBpmnVarsItemList(itemIdList);
        List runtimeSourceList = this.parseAuditableRuntimeSource(itemIdList, CoreBpmnParameterDTO.of(wrapper), this.getBpmnVars(wrapper, selectItemList));
        return runtimeService.endTask(runtimeSourceList);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_END)
    @Audit(value="AUDIT.PROCESS_END")
    default public List<CoreBpmnInstanceStatusDTO<ID>> endTask(List<ID> itemIdList, CoreBpmnParameterDTO parameter) {
        if (itemIdList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List<T> itemList = this.getBpmnVarsItemList(itemIdList);
        List<CoreBpmnRuntimeSource<T, ID>> runtimeSourceList = this.parseAuditableRuntimeSource(itemIdList, parameter, this.getBpmnVars(null, itemList));
        return runtimeService.endTask(runtimeSourceList);
    }

    @Deprecated
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_COMPLETE)
    @Audit(value="AUDIT.PROCESS_COMPLETE")
    default public List<CoreBpmnInstanceStatusDTO<ID>> endTask(List<ID> itemIdList, String comment) {
        CoreBpmnParameterDTO parameter = new CoreBpmnParameterDTO();
        parameter.setComment(comment);
        return this.endTask(itemIdList, parameter);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_REJECT)
    @Audit(value="AUDIT.PROCESS_REJECT")
    default public List<CoreBpmnInstanceStatusDTO<ID>> rejectTask(RestJsonWrapperBean wrapper) {
        List itemList = wrapper.parse(this.getDao().getType());
        if (itemList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        this.checkAndUpdateVersion(itemList);
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List itemIdList = itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
        List<T> selectItemList = this.getBpmnVarsItemList(itemIdList);
        List runtimeSourceList = this.parseAuditableRuntimeSource(itemIdList, CoreBpmnParameterDTO.of(wrapper), this.getBpmnVars(wrapper, selectItemList));
        return runtimeService.rejectTask(runtimeSourceList);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_REJECT)
    @Audit(value="AUDIT.PROCESS_REJECT")
    default public List<CoreBpmnInstanceStatusDTO<ID>> rejectTask(List<ID> itemIdList, CoreBpmnParameterDTO parameter) {
        if (itemIdList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        List<T> itemList = this.getBpmnVarsItemList(itemIdList);
        List<CoreBpmnRuntimeSource<T, ID>> runtimeSourceList = this.parseAuditableRuntimeSource(itemIdList, parameter, this.getBpmnVars(null, itemList));
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        return runtimeService.rejectTask(runtimeSourceList);
    }

    @Deprecated
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_COMPLETE)
    @Audit(value="AUDIT.PROCESS_COMPLETE")
    default public List<CoreBpmnInstanceStatusDTO<ID>> rejectTask(List<ID> itemIdList, String comment) {
        CoreBpmnParameterDTO parameter = new CoreBpmnParameterDTO();
        parameter.setComment(comment);
        return this.rejectTask(itemIdList, parameter);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_REJECT)
    @Audit(value="AUDIT.PROCESS_ODD_REJECT")
    default public List<CoreBpmnInstanceStatusDTO<ID>> oddRejectTask(RestJsonWrapperBean wrapper) {
        List itemList = wrapper.parse(this.getDao().getType());
        if (itemList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        this.checkAndUpdateVersion(itemList);
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List itemIdList = itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
        List<T> selectItemList = this.getBpmnVarsItemList(itemIdList);
        List runtimeSourceList = this.parseAuditableRuntimeSource(itemIdList, CoreBpmnParameterDTO.of(wrapper), this.getBpmnVars(wrapper, selectItemList));
        return runtimeService.oddRejectTask(runtimeSourceList);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_REJECT)
    @Audit(value="AUDIT.PROCESS_ODD_REJECT")
    default public List<CoreBpmnInstanceStatusDTO<ID>> oddRejectTask(List<ID> itemIdList, CoreBpmnParameterDTO parameter) {
        if (itemIdList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        List<T> itemList = this.getBpmnVarsItemList(itemIdList);
        List<CoreBpmnRuntimeSource<T, ID>> runtimeSourceList = this.parseAuditableRuntimeSource(itemIdList, parameter, this.getBpmnVars(null, itemList));
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        return runtimeService.oddRejectTask(runtimeSourceList);
    }

    @Deprecated
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_COMPLETE)
    @Audit(value="AUDIT.PROCESS_COMPLETE")
    default public List<CoreBpmnInstanceStatusDTO<ID>> oddRejectTask(List<ID> itemIdList, String comment) {
        CoreBpmnParameterDTO parameter = new CoreBpmnParameterDTO();
        parameter.setComment(comment);
        return this.oddRejectTask(itemIdList, parameter);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_UNDO)
    @Audit(value="AUDIT.PROCESS_UNDO")
    default public List<CoreBpmnInstanceStatusDTO<ID>> undo(RestJsonWrapperBean wrapper) {
        List itemList = wrapper.parse(this.getDao().getType());
        if (itemList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        this.checkAndUpdateVersion(itemList);
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        List itemIdList = itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
        List<T> selectItemList = this.getBpmnVarsItemList(itemIdList);
        List runtimeSourceList = this.parseUndoableRuntimeSource(itemIdList, CoreBpmnParameterDTO.of(wrapper), this.getBpmnVars(wrapper, selectItemList));
        return runtimeService.undo(runtimeSourceList);
    }

    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_UNDO)
    @Audit(value="AUDIT.PROCESS_UNDO")
    default public List<CoreBpmnInstanceStatusDTO<ID>> undo(List<ID> itemIdList, CoreBpmnParameterDTO parameter) {
        if (itemIdList.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        List<T> itemList = this.getBpmnVarsItemList(itemIdList);
        List<CoreBpmnRuntimeSource<T, ID>> runtimeSourceList = this.parseUndoableRuntimeSource(itemIdList, parameter, this.getBpmnVars(null, itemList));
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        return runtimeService.undo(runtimeSourceList);
    }

    @Deprecated
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.PROCESS_COMPLETE)
    @Audit(value="AUDIT.PROCESS_COMPLETE")
    default public List<CoreBpmnInstanceStatusDTO<ID>> undo(List<ID> itemIdList, String comment) {
        CoreBpmnParameterDTO parameter = new CoreBpmnParameterDTO();
        parameter.setComment(comment);
        return this.undo(itemIdList, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public CoreBpmnTaskStatusDTO selectBpmnTaskStatus(RestJsonWrapperBean wrapper) {
        List<?> idList = wrapper.parseId(this.getDao().getEntityContext().getIdContext().getType());
        if (idList.isEmpty()) {
            return new CoreBpmnTaskStatusDTO();
        }
        String pass = wrapper.getParamValue("bpmn_pass");
        if ("-1".equals(pass)) {
            return new CoreBpmnTaskStatusDTO();
        }
        List sourceList = this.parseRuntimeSource(idList, wrapper);
        if (sourceList.stream().anyMatch(s -> ProcessStatus.DONE.name().equalsIgnoreCase(s.getOldItem().getProcessStatus()))) {
            return new CoreBpmnTaskStatusDTO();
        }
        CoreBpmnTaskStatusDTO taskStatus = null;
        try {
            BpmnRuntimeCacheProvider.init(sourceList);
            for (CoreBpmnRuntimeSource source : sourceList) {
                CoreBpmnTaskStatusDTO sourceStatus = new CoreBpmnTaskStatusDTO();
                Element currentElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
                sourceStatus.setAttachmentStrategy(BpmnDiagramHelper.getAttachmentStrategy(currentElement));
                sourceStatus.setCommentRequired(BpmnDiagramHelper.isCommentRequiredTask(currentElement));
                sourceStatus.setAuthRequired(BpmnDiagramHelper.isAuthRequiredUserTask(currentElement));
                sourceStatus.setTransfer(BpmnDiagramHelper.isTransferTask(currentElement));
                if ("1".equals(pass) && BpmnRuntimeCacheProvider.isLastTaskCandidator(source)) {
                    sourceStatus.setNextCandidatorOptStrategy(BpmnDiagramHelper.getNextCandidatorOptStrategy(currentElement));
                    if (NextCandidatorOptStrategy.assigned.equals((Object)sourceStatus.getNextCandidatorOptStrategy()) || NextCandidatorOptStrategy.assignedRole.equals((Object)sourceStatus.getNextCandidatorOptStrategy())) {
                        ArrayList<Object> candidatorIdList;
                        List<Element> nextTaskElementList;
                        CoreBpmnInstanceNextTaskElementDTO nextTaskElement = BpmnRuntimeCacheProvider.getNextTask(source);
                        if (NextCandidatorOptStrategy.assigned.equals((Object)sourceStatus.getNextCandidatorOptStrategy())) {
                            nextTaskElementList = nextTaskElement.getNextTaskElementList();
                            candidatorIdList = new ArrayList<Object>();
                            ArrayList<Long> candidateRoleIdList = new ArrayList<Long>();
                            CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
                            String initiator = instance == null ? LocalContextHelper.getLoginUserId() : instance.getInitiator();
                            for (Element taskElement : nextTaskElementList) {
                                CoreBpmnTaskCandidatorsDTO candidators = BpmnDiagramHelper.getUserTaskCandidators(source, taskElement, initiator);
                                if (candidators.getCandidatorIdList() != null) {
                                    candidatorIdList.addAll(candidators.getCandidatorIdList());
                                }
                                if (candidators.getCandidateRoleIdList() == null) continue;
                                candidateRoleIdList.addAll(candidators.getCandidateRoleIdList());
                            }
                            if (!candidateRoleIdList.isEmpty()) {
                                CoreRoleUserService roleUserService = ApplicationContextHelper.getBean(CoreRoleUserService.class);
                                List<CoreRoleUserBean> candidatorList = roleUserService.getDao().selectListByOneColumnValues(candidateRoleIdList.stream().distinct().collect(Collectors.toList()), "ROLEID", new Order[0]);
                                candidatorList.forEach(r -> candidatorIdList.add(r.getUserId()));
                            }
                            if (!candidatorIdList.isEmpty()) {
                                String createdByOrgId;
                                CoreUserService userService = ApplicationContextHelper.getBean(CoreUserService.class);
                                List<CoreUserBean> candidatorList1 = userService.selectListByIds(candidatorIdList.stream().distinct().collect(Collectors.toList()));
                                if (CandidatorFilterStrategy.sameDept.equals((Object)BpmnDiagramHelper.getCandidatorFilterStrategy(currentElement)) && !StringUtils.isBlank(createdByOrgId = (String)PersistableHelper.getPropertyValue(source.getOldItem(), "createdByOrgId"))) {
                                    candidatorList1.removeIf(c -> !c.getOrgId().equals(createdByOrgId));
                                }
                                sourceStatus.setCandidatorList(candidatorList1);
                            }
                        } else if (NextCandidatorOptStrategy.assignedRole.equals((Object)sourceStatus.getNextCandidatorOptStrategy())) {
                            nextTaskElementList = nextTaskElement.getNextTaskElementList();
                            candidatorIdList = new ArrayList();
                            CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
                            String initiator = instance == null ? LocalContextHelper.getLoginUserId() : instance.getInitiator();
                            for (Element taskElement : nextTaskElementList) {
                                CoreBpmnTaskCandidatorsDTO candidators = BpmnDiagramHelper.getUserTaskCandidators(source, taskElement, initiator);
                                if (candidators.getCandidateRoleIdList() == null) continue;
                                candidatorIdList.addAll(candidators.getCandidateRoleIdList());
                            }
                            if (!candidatorIdList.isEmpty()) {
                                CoreRoleService roleService = ApplicationContextHelper.getBean(CoreRoleService.class);
                                sourceStatus.setCandidateRoleList(roleService.selectListByIds(candidatorIdList.stream().distinct().collect(Collectors.toList())));
                            }
                        }
                    }
                }
                if (taskStatus == null) {
                    taskStatus = sourceStatus;
                    continue;
                }
                this.checkAndMerge(taskStatus, sourceStatus);
            }
        }
        finally {
            BpmnRuntimeCacheProvider.remove();
        }
        if (NextCandidatorOptStrategy.assigned.equals((Object)taskStatus.getNextCandidatorOptStrategy()) && CollectionUtils.isEmpty(taskStatus.getCandidatorList())) {
            throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.TIP.ASSIGNED_STRATEGY_REQUIRES_CANDIDATORS");
        }
        if (NextCandidatorOptStrategy.assignedRole.equals((Object)taskStatus.getNextCandidatorOptStrategy()) && CollectionUtils.isEmpty(taskStatus.getCandidateRoleList())) {
            throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.TIP.ASSIGNED_ROLE_STRATEGY_REQUIRES_CANDIDATEROLES");
        }
        return taskStatus;
    }

    default public List<T> getBpmnVarsItemList(List<ID> idList) {
        return this.getDao().selectListByIds(idList, new Order[0]);
    }

    default public Map<ID, Map<String, Object>> getBpmnVars(RestJsonWrapperBean wrapper, List<T> itemList) {
        HashMap map = new HashMap();
        List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(this.getDao().getType());
        Iterator<T> iterator = itemList.iterator();
        while (iterator.hasNext()) {
            Auditable t;
            Auditable item = t = (Auditable)iterator.next();
            HashMap vars = new HashMap();
            propertyDescriptorList.forEach(pd -> {
                if (String.class.equals(pd.getPropertyType()) || Date.class.isAssignableFrom(pd.getPropertyType()) || Temporal.class.isAssignableFrom(pd.getPropertyType()) || Number.class.isAssignableFrom(pd.getPropertyType())) {
                    if (Temporal.class.isAssignableFrom(pd.getPropertyType())) {
                        vars.put(pd.getName().toLowerCase(), ConvertUtils.convert(pd.getPropertyValue(item), Date.class));
                    } else {
                        vars.put(pd.getName().toLowerCase(), pd.getPropertyValue(item));
                    }
                }
            });
            item.getExt$().forEach((k, v) -> vars.put(k.toLowerCase(), v));
            map.put((Serializable)item.getId(), vars);
        }
        return map;
    }

    default public Supplier<String> getDescSupplier(CoreBpmnRuntimeSource<T, ID> source) {
        return () -> ObjectUtils.toString(source.getId());
    }

    default public List<String> getChosenAuditorList(RestJsonWrapperBean wrapper) {
        return JSON.parseArray((String)wrapper.getParamValue("auditor"), String.class);
    }

    default public List<CoreBpmnRuntimeSource<T, ID>> parseRuntimeSource(List<ID> itemIdList, RestJsonWrapperBean wrapper) {
        List<T> selectedItemList = this.getBpmnVarsItemList(itemIdList);
        Map<ID, Map<String, Object>> map = this.getBpmnVars(wrapper, selectedItemList);
        CoreBpmnParameterDTO parameter = CoreBpmnParameterDTO.of(wrapper);
        ArrayList<CoreBpmnRuntimeSource<CoreBpmnRuntimeSource, ID>> sourceList = new ArrayList<CoreBpmnRuntimeSource<CoreBpmnRuntimeSource, ID>>();
        Iterator<T> iterator = selectedItemList.iterator();
        while (iterator.hasNext()) {
            Auditable t;
            Auditable item = t = (Auditable)iterator.next();
            CoreBpmnRuntimeSource source = CoreBpmnRuntimeSource.of(this.getDao().getTable(), item, parameter.getComment(), map.get(item.getId()));
            source.setDescSupplier(this.getDescSupplier(source));
            sourceList.add(source);
        }
        boolean draft = selectedItemList.stream().anyMatch(i -> StringUtils.startsWithIgnoreCase(i.getProcessStatus(), ProcessStatus.DRAFT.name()));
        if (draft) {
            List procIdList = this.getBpmnProcIdList(selectedItemList);
            sourceList.forEach(s -> s.setProcId((Long)procIdList.stream().filter(p -> s.getId().equals(p.getFirst())).findAny().get().getSecond()));
        }
        return sourceList;
    }

    default public List<CoreBpmnRuntimeSource<T, ID>> parseSubmittableRuntimeSource(List<ID> itemIdList, CoreBpmnParameterDTO parameter, Map<ID, Map<String, Object>> replacementMap) {
        List<T> selectedItemList = this.getBpmnVarsItemList(itemIdList);
        List<Pair<ID, Long>> procIdList = this.getBpmnProcIdList(selectedItemList);
        ArrayList<CoreBpmnRuntimeSource<T, ID>> sourceList = new ArrayList<CoreBpmnRuntimeSource<T, ID>>();
        Iterator<T> iterator = selectedItemList.iterator();
        while (iterator.hasNext()) {
            Auditable t;
            Auditable item = t = (Auditable)iterator.next();
            CoreBpmnRuntimeSource source = CoreBpmnRuntimeSource.of(this.getDao().getTable(), item, parameter.getComment(), replacementMap.get(item.getId()));
            source.setProcId((Long)procIdList.stream().filter(p -> ((Serializable)item.getId()).equals(p.getFirst())).findAny().get().getSecond());
            source.setDescSupplier(this.getDescSupplier(source));
            String attachment = parameter.getAttachment();
            if (!StringUtils.isBlank(attachment)) {
                source.setAttachmentId(NumberUtils.parseLong(attachment));
            }
            for (String nextCandidateRole : parameter.getNextCandidators()) {
                source.addNextCandidator(nextCandidateRole);
            }
            for (String nextCandidateRole : parameter.getNextCandidateRoles()) {
                source.addNextCandidatorRole(NumberUtils.parseLong(nextCandidateRole));
            }
            sourceList.add(source);
        }
        return sourceList;
    }

    default public List<CoreBpmnRuntimeSource<T, ID>> parseAuditableRuntimeSource(List<ID> itemIdList, CoreBpmnParameterDTO parameter, Map<ID, Map<String, Object>> replacementMap) {
        List<T> selectedItemList = this.getBpmnVarsItemList(itemIdList);
        ArrayList<CoreBpmnRuntimeSource<T, ID>> sourceList = new ArrayList<CoreBpmnRuntimeSource<T, ID>>();
        for (Auditable item : selectedItemList) {
            CoreBpmnRuntimeSource source = CoreBpmnRuntimeSource.of(this.getDao().getTable(), item, parameter.getComment(), replacementMap.get(item.getId()));
            source.setCurrentStatusCode(parameter.getCurrentStatusCode());
            source.setTargetStatusCode(parameter.getTargetStatusCode());
            String attachment = parameter.getAttachment();
            if (!StringUtils.isBlank(attachment)) {
                source.setAttachmentId(NumberUtils.parseLong(attachment));
            }
            for (String nextCandidateRole : parameter.getNextCandidators()) {
                source.addNextCandidator(nextCandidateRole);
            }
            for (String nextCandidateRole : parameter.getNextCandidateRoles()) {
                source.addNextCandidatorRole(NumberUtils.parseLong(nextCandidateRole));
            }
            if (!StringUtils.isBlank(parameter.getTransferCandidator())) {
                source.setTransferCandidator(parameter.getTransferCandidator());
            }
            source.setDescSupplier(this.getDescSupplier(source));
            sourceList.add(source);
        }
        return sourceList;
    }

    default public List<CoreBpmnRuntimeSource<T, ID>> parseUndoableRuntimeSource(List<ID> itemIdList, CoreBpmnParameterDTO parameter, Map<ID, Map<String, Object>> replacementMap) {
        List<T> selectedItemList = this.getBpmnVarsItemList(itemIdList);
        ArrayList<CoreBpmnRuntimeSource<T, ID>> sourceList = new ArrayList<CoreBpmnRuntimeSource<T, ID>>();
        for (Auditable item : selectedItemList) {
            CoreBpmnRuntimeSource source = CoreBpmnRuntimeSource.of(this.getDao().getTable(), item, parameter.getComment(), replacementMap.get(item.getId()));
            source.setDescSupplier(this.getDescSupplier(source));
            sourceList.add(source);
        }
        return sourceList;
    }

    default public List<CoreBpmnRuntimeSource<T, ID>> parseWithdrawableRuntimeSource(List<ID> itemIdList, CoreBpmnParameterDTO parameter, Map<ID, Map<String, Object>> replacementMap) {
        List<T> selectedItemList = this.getBpmnVarsItemList(itemIdList);
        ArrayList<CoreBpmnRuntimeSource<T, ID>> sourceList = new ArrayList<CoreBpmnRuntimeSource<T, ID>>();
        for (Auditable item : selectedItemList) {
            CoreBpmnRuntimeSource source = CoreBpmnRuntimeSource.of(this.getDao().getTable(), item, parameter.getComment(), replacementMap.get(item.getId()));
            source.setDescSupplier(this.getDescSupplier(source));
            sourceList.add(source);
        }
        return sourceList;
    }

    default public List<Pair<ID, Long>> getBpmnProcIdList(List<T> itemList) {
        CoreBpmnRuntimeService runtimeService = ApplicationContextHelper.getBean(CoreBpmnRuntimeService.class);
        Map map = runtimeService.selectRuntimeBpmnProcList(itemList);
        return map.entrySet().stream().map(e -> Pair.of((Serializable)e.getKey(), ((CoreBpmnProcBean)e.getValue()).getId())).collect(Collectors.toList());
    }

    default public void checkAndMerge(CoreBpmnTaskStatusDTO taskStatus, CoreBpmnTaskStatusDTO newTaskStatus) {
        if (taskStatus != null) {
            if (taskStatus.getAuthRequired() != newTaskStatus.getAuthRequired()) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.TIP.AUTH_REQUIRED_DIFFER");
            }
            if (!ObjectUtils.equals((Object)taskStatus.getAttachmentStrategy(), (Object)newTaskStatus.getAttachmentStrategy())) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.TIP.ATTACHMENT_STRATEGY_DIFFER");
            }
            if (!ObjectUtils.equals((Object)taskStatus.getNextCandidatorOptStrategy(), (Object)newTaskStatus.getNextCandidatorOptStrategy())) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.TIP.NEXT_CANDIDATOR_OPT_STRATEGY_DIFFER");
            }
            if (taskStatus.isTransfer() != newTaskStatus.isTransfer()) {
                taskStatus.setTransfer(false);
            }
            if (NextCandidatorOptStrategy.assigned.equals((Object)taskStatus.getNextCandidatorOptStrategy()) && taskStatus.getCandidatorList() != null) {
                if (newTaskStatus.getCandidatorList() == null) {
                    taskStatus.setCandidatorList(null);
                } else {
                    taskStatus.getCandidatorList().removeIf(c -> newTaskStatus.getCandidatorList().stream().noneMatch(n -> n.getId().equals(c.getId())));
                }
            }
            if (NextCandidatorOptStrategy.assignedRole.equals((Object)taskStatus.getNextCandidatorOptStrategy()) && taskStatus.getCandidateRoleList() != null) {
                if (newTaskStatus.getCandidateRoleList() == null) {
                    taskStatus.setCandidateRoleList(null);
                } else {
                    taskStatus.getCandidateRoleList().removeIf(c -> newTaskStatus.getCandidateRoleList().stream().noneMatch(n -> n.getId().equals(c.getId())));
                }
            }
        }
    }

    default public void checkAndUpdateVersion(List<T> itemList) {
        EntityColumnContext versionContext = DatabaseManager.getEntityContext(this.getDao().getType()).getVersionContext();
        if (versionContext != null) {
            List idList = itemList.stream().filter(i -> i.getVersion() != null).map(i -> (Serializable)i.getId()).collect(Collectors.toList());
            if (!idList.isEmpty()) {
                List selectedVersionItemList = this.getDao().selectListByIds(idList, Arrays.asList("ID", "VERSION"), new Order[0]);
                for (Auditable selectedVersionItem : selectedVersionItemList) {
                    if (!itemList.stream().noneMatch(i -> ((Serializable)i.getId()).equals(selectedVersionItem.getId()) && i.getVersion().equals(selectedVersionItem.getVersion()))) continue;
                    throw new ApplicationWarningException("SINO.EXCEPTION.CONRRENT_MODIFICATION", new String[0]);
                }
            }
            itemList.forEach(i -> i.setVersion(Optional.ofNullable(i.getVersion()).orElse(1L) + 1L));
            this.getDao().update(itemList, (String[])new String[]{"VERSION"});
        }
    }
}

