/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.support;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.support.PersistableMetadataHelper;
import net.sinodawn.framework.support.domain.Activatable;
import net.sinodawn.framework.support.domain.BaseData;
import net.sinodawn.framework.support.domain.Modified;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.support.domain.Suspendable;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.DateTimeUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;

public abstract class PersistableHelper {
    private static final String[] BEAN_BASIC_PROPERTIES = new String[]{"createdById", "createdByName", "createdByOrgId", "createdByOrgName", "createdTime", "activatedFlag", "activatedById", "activatedByName", "activatedTime", "lastSuspendedFlag", "lastSuspendedById", "lastSuspendedByName", "lastSuspendedTime", "lastRejectedFlag", "lastRejectedById", "lastRejectedByName", "lastRejectedTime", "activatedFlag", "activatedById", "activatedByName", "activatedTime"};

    public static <P extends BaseData> P mapToPersistable(Map<String, Object> map, Class<P> persistableClass) {
        if (map != null && !map.isEmpty()) {
            BaseData instance = (BaseData)ClassUtils.newInstance(persistableClass);
            map.forEach((k, v) -> {
                BeanPropertyDescriptor propertyDescriptor = BeanPropertyHelper.getBeanPropertyDescriptor(persistableClass, k);
                if (propertyDescriptor == null) {
                    String text = ConvertUtils.convert(v, String.class);
                    if (text != null) {
                        if (StringUtils.endsWithIgnoreCase(k, "date")) {
                            try {
                                text = DateTimeUtils.formatLocalDate(DateTimeUtils.parseLocalDate(text));
                            }
                            catch (Exception exception) {}
                        } else if (StringUtils.endsWithIgnoreCase(k, "time")) {
                            try {
                                text = DateTimeUtils.formatLocalDateTime(DateTimeUtils.parseLocalDateTime(text));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    instance.setExt$Item(k.toLowerCase(), text);
                } else {
                    ReflectionUtils.invokeMethod(propertyDescriptor.getWriteMethod(), instance, ConvertUtils.convert(v, propertyDescriptor.getPropertyType()));
                }
            });
            return (P)instance;
        }
        return null;
    }

    public static <M extends Persistable<?>, P extends Persistable<?>> M mapToModified(P item, Class<M> modifiedClass) {
        Persistable m = (Persistable)ClassUtils.newInstance(modifiedClass);
        if (Modified.class.isAssignableFrom(modifiedClass)) {
            BeanUtils.CopyConfig config = new BeanUtils.CopyConfig();
            config.setTargetPrefix("old");
            BeanUtils.copyProperties(item, (Object)m, config, new String[0]);
        }
        BeanUtils.copyProperties(item, (Object)m, BEAN_BASIC_PROPERTIES);
        m.setId(null);
        BeanPropertyHelper.getBeanPropertyDescriptorList(modifiedClass).forEach(p -> {
            String var10000 = m.getExt$().remove(p.getName().toLowerCase());
        });
        return (M)m;
    }

    public static <M extends Persistable<ID>, P extends Persistable<ID>, ID extends Serializable> void remap(M item, P orig) {
        BeanUtils.copyProperties(item, orig, BEAN_BASIC_PROPERTIES);
        if (Modified.class.isAssignableFrom(item.getClass())) {
            orig.setId(((Modified)item).getOldId());
        }
    }

    public static <P extends Persistable<?>> Object getPropertyValue(P item, String propertyName) {
        if (item == null) {
            return null;
        }
        Field field = ReflectionUtils.findField(item.getClass(), propertyName);
        return field == null ? item.getExt$().get(propertyName.toLowerCase()) : ReflectionUtils.invokeReadMethod(item, propertyName);
    }

    public static <P extends Persistable<?>> void setPropertyValue(P item, String propertyName, Object value) {
        if (item != null) {
            ReflectionUtils.invokeWriteMethod(item, propertyName, value);
        }
    }

    public static <T> void resetBasicProperties(T item) {
        List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass());
        for (BeanPropertyDescriptor propertyDescriptor : propertyDescriptorList) {
            if (!ArrayUtils.containsIgnoreCase(BEAN_BASIC_PROPERTIES, propertyDescriptor.getName())) continue;
            ReflectionUtils.invokeMethod(propertyDescriptor.getWriteMethod(), item, new Object[]{null});
        }
    }

    public static void assignDefaultData(Object item) {
        BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass()).forEach(p -> {
            NotNull notNull;
            Object value = ReflectionUtils.invokeMethod(p.getReadMethod(), item, new Object[0]);
            if (value == null && (notNull = p.getProperty().getAnnotation(NotNull.class)) != null) {
                ReflectionUtils.invokeMethod(p.getWriteMethod(), item, ConvertUtils.convert(notNull.defaultValue(), p.getPropertyType()));
            }
        });
    }

    public static void assignCreatedUserData(Object item) {
        BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass()).forEach(p -> {
            if (PersistableMetadataHelper.isCreatedByIdPropertyDescriptor(p)) {
                if (ReflectionUtils.invokeMethod(p.getReadMethod(), item, new Object[0]) == null) {
                    ReflectionUtils.invokeMethod(p.getWriteMethod(), item, LocalContextHelper.getLoginUserId());
                }
            } else if (PersistableMetadataHelper.isCreatedByNamePropertyDescriptor(p)) {
                if (ReflectionUtils.invokeMethod(p.getReadMethod(), item, new Object[0]) == null) {
                    ReflectionUtils.invokeMethod(p.getWriteMethod(), item, LocalContextHelper.getLoginUserName());
                }
            } else if (PersistableMetadataHelper.isCreatedByOrgIdPropertyDescriptor(p)) {
                if (ReflectionUtils.invokeMethod(p.getReadMethod(), item, new Object[0]) == null) {
                    ReflectionUtils.invokeMethod(p.getWriteMethod(), item, LocalContextHelper.getLoginOrgId());
                }
            } else if (PersistableMetadataHelper.isCreatedByOrgNamePropertyDescriptor(p)) {
                if (ReflectionUtils.invokeMethod(p.getReadMethod(), item, new Object[0]) == null) {
                    ReflectionUtils.invokeMethod(p.getWriteMethod(), item, LocalContextHelper.getLoginOrgName());
                }
            } else if (PersistableMetadataHelper.isCreatedTimePropertyDescriptor(p) && ReflectionUtils.invokeMethod(p.getReadMethod(), item, new Object[0]) == null) {
                ReflectionUtils.invokeMethod(p.getWriteMethod(), item, LocalDateTime.now());
            }
        });
    }

    public static void removeCreatedUserData(Object item) {
        BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass()).forEach(p -> {
            if (PersistableMetadataHelper.isCreatedByIdPropertyDescriptor(p)) {
                ReflectionUtils.invokeMethod(p.getWriteMethod(), item, new Object[]{null});
            } else if (PersistableMetadataHelper.isCreatedByNamePropertyDescriptor(p)) {
                ReflectionUtils.invokeMethod(p.getWriteMethod(), item, new Object[]{null});
            } else if (PersistableMetadataHelper.isCreatedByOrgIdPropertyDescriptor(p)) {
                ReflectionUtils.invokeMethod(p.getWriteMethod(), item, new Object[]{null});
            } else if (PersistableMetadataHelper.isCreatedByOrgNamePropertyDescriptor(p)) {
                ReflectionUtils.invokeMethod(p.getWriteMethod(), item, new Object[]{null});
            } else if (PersistableMetadataHelper.isCreatedTimePropertyDescriptor(p)) {
                ReflectionUtils.invokeMethod(p.getWriteMethod(), item, new Object[]{null});
            }
        });
    }

    public static void assignActivatedUserData(Object item) {
        if (item instanceof Activatable) {
            Activatable activatable = (Activatable)item;
            activatable.setActivatedById(LocalContextHelper.getLoginUserId());
            activatable.setActivatedByName(LocalContextHelper.getLoginUserName());
            activatable.setActivatedTime(LocalDateTime.now());
        }
    }

    public static void removeActivatedUserData(Object item) {
        if (item instanceof Activatable) {
            Activatable activatable = (Activatable)item;
            activatable.setActivatedById(null);
            activatable.setActivatedByName(null);
            activatable.setActivatedTime(null);
        }
    }

    public static void assignSuspendedUserData(Object item) {
        if (item instanceof Suspendable) {
            Suspendable suspendable = (Suspendable)item;
            suspendable.setLastSuspendedById(LocalContextHelper.getLoginUserId());
            suspendable.setLastSuspendedByName(LocalContextHelper.getLoginUserName());
            suspendable.setLastSuspendedTime(LocalDateTime.now());
        }
    }

    public static void removeSuspendedUserData(Object item) {
        if (item instanceof Suspendable) {
            Suspendable suspendable = (Suspendable)item;
            suspendable.setLastSuspendedById(null);
            suspendable.setLastSuspendedByName(null);
            suspendable.setLastSuspendedTime(null);
        }
    }
}

