/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.security.support;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sinodawn.framework.security.exception.AccountOfflineException;
import net.sinodawn.framework.utils.ServletUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
@Primary
public class Http401UnauthorizedEntryPoint
implements AuthenticationEntryPoint {
    private static final Logger logger = LogManager.getLogger(Http401UnauthorizedEntryPoint.class);
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        logger.warn(exception.getMessage(), (Throwable)exception);
        String requestUri = ServletUtils.getRequestUri(request);
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry m : map.entrySet()) {
            RequestMappingInfo info = (RequestMappingInfo)m.getKey();
            HandlerMethod method = (HandlerMethod)m.getValue();
            PatternsRequestCondition p = info.getPatternsCondition();
            for (String url : p.getPatterns()) {
                if (!requestUri.equals(url) || !method.getMethod().getDeclaringClass().isAnnotationPresent(Controller.class)) continue;
                response.sendRedirect(ServletUtils.getContextPath() + "/");
                return;
            }
        }
        Class<?> clazz = exception.getClass();
        if (AccountOfflineException.class.isAssignableFrom(clazz)) {
            ResponseStatus status = clazz.getAnnotation(ResponseStatus.class);
            int httpStatus = status == null ? HttpStatus.GONE.value() : status.value().value();
            ServletUtils.responseMessage((ServletResponse)response, httpStatus, exception.getMessage());
        } else {
            ServletUtils.responseMessage((ServletResponse)response, JSON.toJSONString(Collections.singletonMap("message", "core.security.login.unauthorized")));
        }
    }
}

