/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.security.support;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.exception.database.JdbcException;
import net.sinodawn.framework.security.AccountCategory;
import net.sinodawn.framework.security.authentication.AuthenticationHelper;
import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.security.captcha.SecurityCaptchaService;
import net.sinodawn.framework.security.service.DefaultUserDetailsChecker;
import net.sinodawn.framework.security.sso.RemoteAuthenticator;
import net.sinodawn.framework.security.sso.SsoAuthenticator;
import net.sinodawn.framework.security.sso.SsoAuthenticatorRegistry;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import net.sinodawn.module.sys.password.bean.CorePasswordPolicyBean;
import net.sinodawn.module.sys.password.service.CorePasswordPolicyService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;

public class DefaultDaoAuthenticationProvider
extends DaoAuthenticationProvider {
    private static final Logger logger = LogManager.getLogger(DaoAuthenticationProvider.class);
    @Autowired
    @Lazy
    protected CoreUserService userService;
    @Autowired
    private CorePasswordPolicyService passwordPolicyService;
    @Autowired
    @Lazy
    private PasswordEncoder passwordEncoder;
    @Value(value="${sino.security.remote-authenticator-name:}")
    private String remoteAuthenticatorName;
    @Autowired
    @Lazy
    private SecurityCaptchaService captchaService;

    public DefaultDaoAuthenticationProvider() {
        this.setHideUserNotFoundExceptions(false);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        RemoteAuthenticator remoteAuthenticator;
        LoginUser loginUser;
        this.captchaService.checkCaptcha();
        String loginType = ServletUtils.getCurrentRequest().getParameter("loginType");
        if (!StringUtils.isEmpty(loginType)) {
            SsoAuthenticator authenticator = SsoAuthenticatorRegistry.INSTANCE.getAuthenticator(loginType);
            if (authenticator == null) {
                throw new SecurityException("SINO.SECURITY.SSO_LOGIN.INVALID_LOGINTYPE");
            }
            loginUser = authenticator.authenticate();
            authentication = new UsernamePasswordAuthenticationToken((Object)loginUser.getUsername(), loginUser.getAdditionalCheck() ? authentication.getCredentials() : loginUser.getPassword(), CollectionUtils.emptyList());
            if (loginUser.getAdditionalCheck()) {
                authentication.setAuthenticated(false);
            }
        }
        if (StringUtils.isEmpty(loginType) && !StringUtils.isBlank(this.remoteAuthenticatorName) && (remoteAuthenticator = (RemoteAuthenticator)ApplicationContextHelper.getBeanIfPresent(this.remoteAuthenticatorName)) != null) {
            loginUser = remoteAuthenticator.authenticate((String)authentication.getPrincipal(), AuthenticationHelper.getRawPassword((String)authentication.getCredentials()));
            CoreUserBean user = (CoreUserBean)this.userService.selectById(loginUser.getUsername());
            this.logoutPreviousLoginIfNecessary(user);
            return new UsernamePasswordAuthenticationToken((Object)loginUser, (Object)user.getPassword());
        }
        return super.authenticate(authentication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        try {
            CoreUserBean user = (CoreUserBean)this.userService.selectById(userDetails.getUsername());
            try {
                List<CorePasswordPolicyBean> passwordPolicyList;
                List expiryIntervalList;
                if (!authentication.isAuthenticated() && ((LoginUser)userDetails).getAdditionalCheck()) {
                    String rawPassword = AuthenticationHelper.getRawPassword((String)authentication.getCredentials());
                    DefaultUserDetailsChecker.checkPassword((String)authentication.getPrincipal(), rawPassword);
                }
                if (!(expiryIntervalList = (passwordPolicyList = this.passwordPolicyService.selectEffectedList(user.getId())).stream().filter(p -> p.getExpiryInterval() != null && p.getExpiryInterval() > 0L).collect(Collectors.toList())).isEmpty()) {
                    LocalDateTime now = LocalDateTime.now();
                    boolean expiredPassword = false;
                    Iterator var8 = expiryIntervalList.iterator();
                    while (true) {
                        if (!var8.hasNext()) {
                            if (!expiredPassword) break;
                            CoreUserBean updateUser = new CoreUserBean();
                            updateUser.setId(user.getId());
                            updateUser.setExpiredPasswordUses(user.getExpiredPasswordUses() + 1);
                            this.userService.update(updateUser);
                            break;
                        }
                        CorePasswordPolicyBean passwordPolicy = (CorePasswordPolicyBean)var8.next();
                        if (!user.getPasswordUpdatedTime().plusDays(passwordPolicy.getExpiryInterval()).isBefore(now)) continue;
                        if (passwordPolicy.getExpiredMaxUse() == null || passwordPolicy.getExpiredMaxUse() <= (long)user.getExpiredPasswordUses().intValue()) {
                            CoreUserBean updateUser = new CoreUserBean();
                            updateUser.setId(user.getId());
                            updateUser.setStatus("locked");
                            this.userService.update(updateUser);
                            throw new LockedException("SINO.SECURITY.LOGIN.LOCKED");
                        }
                        expiredPassword = true;
                    }
                }
                if (user.getFailedLoginAttempts() > 0) {
                    CoreUserBean updateUser = new CoreUserBean();
                    updateUser.setId(user.getId());
                    updateUser.setFailedLoginAttempts(0);
                    this.userService.update(updateUser);
                }
                this.logoutPreviousLoginIfNecessary(user);
            }
            catch (BadCredentialsException var15) {
                DefaultUserDetailsChecker.postAuthenticationFailure(userDetails.getUsername());
            }
            finally {
                if (userDetails instanceof CredentialsContainer) {
                    ((CredentialsContainer)userDetails).eraseCredentials();
                }
            }
        }
        catch (Exception var17) {
            if (AuthenticationException.class.isAssignableFrom(var17.getClass())) {
                throw var17;
            }
            logger.error(var17.getMessage(), (Throwable)var17);
            throw new JdbcException("SINO.EXCEPTION.UNEXPECTED");
        }
    }

    private void logoutPreviousLoginIfNecessary(CoreUserBean user) {
        if ("0".equals(user.getMultiLogin())) {
            List<String> tokenList = AuthenticationHelper.getLoginTokenList();
            for (String token : tokenList) {
                Authentication tokenAuthentication = AuthenticationHelper.getCacheAuthentication(token);
                if (tokenAuthentication == null || !user.getId().equals(tokenAuthentication.getName())) continue;
                AuthenticationHelper.markOffline(token, AccountCategory.OFFLINE_PRELOGIN.name());
                AuthenticationHelper.logout(token, "\u4e0d\u5141\u8bb8\u91cd\u590d\u767b\u5f55\uff0c\u5f3a\u5236\u4e0b\u7ebf");
            }
        }
    }
}

