/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.security.support;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sinodawn.framework.exception.core.HttpErrorMessage;
import net.sinodawn.framework.utils.ServletUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component
public class AjaxAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private static final Logger logger = LogManager.getLogger(AjaxAuthenticationFailureHandler.class);

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        logger.warn(exception.getMessage(), (Throwable)exception);
        ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.UNAUTHORIZED, exception.getMessage()));
    }
}

