/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.security.service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.security.sso.SsoAuthenticator;
import net.sinodawn.framework.security.sso.SsoAuthenticatorRegistry;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import net.sinodawn.module.sys.log.service.CoreLoginLogService;
import net.sinodawn.module.sys.password.bean.CorePasswordPolicyBean;
import net.sinodawn.module.sys.password.service.CorePasswordPolicyService;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class DefaultUserDetailsChecker {
    public static void checkPassword(String loginId, String encodedPassword) {
        CoreUserBean user = ApplicationContextHelper.getBean(CoreUserService.class).selectByLoginId(loginId);
        if (user == null) {
            DefaultUserDetailsChecker.getLoginLogService().insertLoginFailureLog(loginId, I18nHelper.getMessage("SINO.SECURITY.LOGIN.INCORRECT_USER_OR_PASSWORD", new String[0]));
            throw new BadCredentialsException("SINO.SECURITY.LOGIN.INCORRECT_USER_OR_PASSWORD");
        }
        if (!user.getPassword().equals(encodedPassword)) {
            DefaultUserDetailsChecker.getLoginLogService().insertLoginFailureLog(loginId, I18nHelper.getMessage("SINO.SECURITY.LOGIN.INCORRECT_USER_OR_PASSWORD", new String[0]));
            throw new BadCredentialsException("SINO.SECURITY.LOGIN.INCORRECT_USER_OR_PASSWORD");
        }
    }

    public static void check(CoreUserBean user) {
        if (user == null) {
            throw new UsernameNotFoundException("SINO.SECURITY.LOGIN.INCORRECT_USER_OR_PASSWORD");
        }
        if ("1".equals(user.getLastSuspendedFlag())) {
            DefaultUserDetailsChecker.getLoginLogService().insertLoginFailureLog(user.getId(), I18nHelper.getMessage("SINO.SECURITY.LOGIN.DEACTIVATED", new String[0]));
            throw new DisabledException("SINO.SECURITY.LOGIN.DEACTIVATED");
        }
        if ("locked".equals(user.getStatus())) {
            DefaultUserDetailsChecker.getLoginLogService().insertLoginFailureLog(user.getId(), I18nHelper.getMessage("SINO.SECURITY.LOGIN.LOCKED", new String[0]));
            throw new LockedException("SINO.SECURITY.LOGIN.LOCKED");
        }
        if ("deprecated".equals(user.getStatus())) {
            DefaultUserDetailsChecker.getLoginLogService().insertLoginFailureLog(user.getId(), I18nHelper.getMessage("SINO.SECURITY.LOGIN.DEPRECATED", new String[0]));
            throw new LockedException("SINO.SECURITY.LOGIN.DEPRECATED");
        }
        LocalDateTime now = LocalDateTime.now();
        if (user.getExpiryDate() != null && user.getExpiryDate().isBefore(now)) {
            DefaultUserDetailsChecker.getLoginLogService().insertLoginFailureLog(user.getId(), I18nHelper.getMessage("SINO.SECURITY.LOGIN.EXPIRED", new String[0]));
            throw new LockedException("SINO.SECURITY.LOGIN.EXPIRED");
        }
    }

    public static void check(UserDetails userDetails) {
        SsoAuthenticator authenticator;
        String loginType;
        CoreUserBean user = (CoreUserBean)ApplicationContextHelper.getBean(CoreUserService.class).selectById(userDetails.getUsername());
        DefaultUserDetailsChecker.check(user);
        HttpServletRequest request = ServletUtils.getCurrentRequest();
        if (request != null && !StringUtils.isBlank(loginType = request.getParameter("loginType")) && (authenticator = SsoAuthenticatorRegistry.INSTANCE.getAuthenticator(loginType)) != null) {
            authenticator.checkLoginUser((LoginUser)userDetails);
        }
    }

    public static void postAuthenticationFailure(String loginId) {
        CoreUserService userService = ApplicationContextHelper.getBean(CoreUserService.class);
        CoreUserBean user = userService.selectByLoginId(loginId);
        if (user != null) {
            List passwordPolicyList = ApplicationContextHelper.getBean(CorePasswordPolicyService.class).selectEffectedList(user.getId()).stream().filter(p -> p.getMaxFailedAttempts() != null && p.getMaxFailedAttempts() > 0L).collect(Collectors.toList());
            if (!passwordPolicyList.isEmpty()) {
                CoreUserBean updateUser = new CoreUserBean();
                updateUser.setId(user.getId());
                updateUser.setFailedLoginAttempts(user.getFailedLoginAttempts() + 1);
                if ((long)updateUser.getFailedLoginAttempts().intValue() > passwordPolicyList.stream().mapToLong(CorePasswordPolicyBean::getMaxFailedAttempts).min().getAsLong()) {
                    updateUser.setStatus("locked");
                }
                userService.update(updateUser);
                if ("locked".equals(updateUser.getStatus())) {
                    DefaultUserDetailsChecker.getLoginLogService().insertLoginFailureLog(loginId, I18nHelper.getMessage("SINO.SECURITY.LOGIN.LOCKED", new String[0]));
                    throw new LockedException("SINO.SECURITY.LOGIN.LOCKED");
                }
            }
        } else {
            DefaultUserDetailsChecker.getLoginLogService().insertLoginFailureLog(loginId, I18nHelper.getMessage("SINO.SECURITY.LOGIN.INCORRECT_USER_OR_PASSWORD", new String[0]));
        }
        throw new BadCredentialsException("SINO.SECURITY.LOGIN.INCORRECT_USER_OR_PASSWORD");
    }

    private static CoreLoginLogService getLoginLogService() {
        return ApplicationContextHelper.getBean(CoreLoginLogService.class);
    }
}

