/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.security.service;

import javax.servlet.http.HttpServletRequest;
import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.security.service.DefaultUserDetailsChecker;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.org.bean.CoreOrgBean;
import net.sinodawn.module.mdm.org.service.CoreOrgService;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class AbstractUserDetailsService
implements UserDetailsService {
    @Autowired
    @Lazy
    protected CoreOrgService orgService;
    @Autowired
    @Lazy
    protected CoreRoleService roleService;

    public UserDetails loadUserByUsername(String loginId) throws UsernameNotFoundException {
        CoreUserBean user = this.getLoginUser(loginId);
        return this.handleLoginUser(user);
    }

    protected abstract CoreUserBean getLoginUser(String var1);

    private UserDetails handleLoginUser(CoreUserBean user) {
        DefaultUserDetailsChecker.check(user);
        LoginUser loginUser = new LoginUser(user.getId(), user.getPassword());
        HttpServletRequest request = ServletUtils.getCurrentRequest();
        loginUser.setOrgId(request.getParameter("orgId"));
        if (!StringUtils.isEmpty(loginUser.getOrgId())) {
            CoreOrgBean org = (CoreOrgBean)this.orgService.selectById(loginUser.getOrgId());
            loginUser.setOrgName(org.getOrgName());
        } else {
            loginUser.setOrgId(user.getOrgId());
            loginUser.setOrgName(user.getOrgName());
        }
        loginUser.setRoleId(ConvertUtils.convert(request.getParameter("roleId"), Long.class));
        if (loginUser.getRoleId() != null) {
            CoreRoleBean role = (CoreRoleBean)this.roleService.selectById(loginUser.getRoleId());
            loginUser.setRoleName(role.getRoleName());
        }
        return loginUser;
    }
}

